#!/usr/local/bin/ruby
#
# calculate the ratio:
#   size of generated native code/
#    {size of byte code, number of byte code instructions}
#
# 1. Set JAVA_COMPILER_OPT codesize
# 2. You'll get the file `jit_codesize' running Java program with JIT compiler.
# 3. % rate_codesize.rb jit_codesize

filename = 'jit_codesize'

nmethod = 0
ninst = 0
byte_size = 0
native_size = 0

if $*[0]
  filename = $*[0]
end

#print "#{filename}\n"

begin
  f = open(filename, "r")
  $stdin = f
end

while gets()
  next if /^#/
  chomp!()
  elems = split()
  nmethod += 1
  ninst += elems[0].to_i()
  byte_size += elems[1].to_i()
  native_size += elems[2].to_i()
end

if f then
  f.close
end

print "num of compiled method:  #{nmethod}\n"
print "num of byte code inst:   #{ninst}\n"
print "byte code size (byte):   #{byte_size}\n"
print "native code size (byte): #{native_size}\n"

print "native code size / num of inst:    #{native_size.to_f() / ninst}\n"
print "native code size / byte code size: #{native_size.to_f() / byte_size}\n"
