/*
  This file is part of shuJIT,
  Just In Time compiler for Sun Java Virtual Machine.

  Copyright (C) 2000 SHUDO Kazuyuki

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  $Id$
*/

#include "compiler.h"


/*
 * Peephole optimization.
 */
#ifdef OPTIMIZE_INTERNAL_CODE
void optimizeInternalCode(CompilerContext *cc) {
#ifdef COMPILE_DEBUG
  int compile_debug = cc->compile_debug;
#endif
  pcentry *entry;
  int opcode, opcode1;
  int i;

#ifdef COMPILE_DEBUG
  if (compile_debug) {
    struct methodblock *mb = cc->mb;
    printf("optIntCode called: %s#%s %s.\n",
	cbName(fieldclass(&mb->fb)), mb->fb.name, mb->fb.signature);
    fflush(stdout);
  }
#endif

  for (i = 0; i < pctableLen(cc); i++) {
    pcentry *entry1, *entry2, *entry3, *entry4;
#define GET_1_ENTRY \
	if (!(entry1 = pctableNext(cc, entry)))  break;\
	if (pcentryBlockTop(entry1))  break
#define GET_2_ENTRIES \
	GET_1_ENTRY; \
	if (!(entry2 = pctableNext(cc, entry1)))  break;\
	if (pcentryBlockTop(entry2))  break
#define GET_3_ENTRIES \
	GET_2_ENTRIES; \
	if (!(entry3 = pctableNext(cc, entry2)))  break;\
	if (pcentryBlockTop(entry3))  break
#define GET_4_ENTRIES \
	GET_3_ENTRIES; \
	if (!(entry4 = pctableNext(cc, entry3)))  break;\
	if (pcentryBlockTop(entry4))  break

    entry = cc->pctable + i;

    switch (entry->opcode) {
    case opc_dst:
      // combine FPU store and load instructions
      GET_2_ENTRIES;
      if ((pcentryState(entry) == 0) &&
	  (entry1->opcode == opc_flush_cache) && (entry2->opcode == opc_dld)) {
#ifdef COMPILE_DEBUG
	if (compile_debug) {
	  printf("  boff:0x%x(%d)\n", entry->byteoff, entry->byteoff);
	  printf("   dst,flush_cache,dld found.\n");
	  fflush(stdout);
	}
#endif
	*entry = *entry1;	// copy opc_flush_cache
	pctableNDelete(cc, i + 1, 2);
      }
      else if ((pcentryState(entry) == 0) &&
       (entry1->opcode == opc_fill_cache) && (entry2->opcode == opc_lstore)) {
#ifdef COMPILE_DEBUG
	if (compile_debug) {
	  printf("  boff:0x%x(%d)\n", entry->byteoff, entry->byteoff);
	  printf("   dst,fill_cache,dstore %d found.\n", entry2->operand);
	  fflush(stdout);
	}
#endif
	entry->opcode = opc_dst_dstore;
	entry->operand = entry2->operand;
	pctableNDelete(cc, i + 1, 2);
      }
#ifndef METAVM
      else if ((pcentryState(entry) == 0) &&
	       (entry1->opcode == opc_fill_cache) &&
	       (entry2->opcode == opc_lastore)) {
#ifdef COMPILE_DEBUG
	if (compile_debug) {
	  printf("  boff:0x%x(%d)\n", entry->byteoff, entry->byteoff);
	  printf("   dst,fill_cache,dastore found.\n");
	  fflush(stdout);
	}
#endif
	entry->opcode = opc_dst_dastore;
	pctableNDelete(cc, i + 1, 2);
      }
#endif	// !METAVM
      break;

    case opc_fst:
      GET_1_ENTRY;
      if ((pcentryState(entry) == 0) && (entry1->opcode == opc_istore)) {
#ifdef COMPILE_DEBUG
	if (compile_debug) {
	  printf("  boff:0x%x(%d)\n", entry->byteoff, entry->byteoff);
	  printf("   fst,fstore %d found.\n", entry1->operand);
	  fflush(stdout);
	}
#endif
	entry->opcode = opc_fst_fstore;
	entry->operand = entry1->operand;
	pctableDelete(cc, i + 1);
      }
      else {
#if 0	// single-precision operations need store-reload
	// for the precise floating-point semantics

	GET_2_ENTRIES;
	// combine FPU store and load instructions
	if ((pcentryState(entry) == 0) &&
		 (entry1->opcode == opc_flush_cache) &&
		 (entry2->opcode == opc_fld)) {
#ifdef COMPILE_DEBUG
	  if (compile_debug) {
	    printf("  boff:0x%x(%d)\n", entry->byteoff, entry->byteoff);
	    printf("   fst,flush_cache,fld found.\n");
	    fflush(stdout);
	  }
#endif
	  *entry = *entry1;	// copy opc_flush_cache
	  pctableNDelete(cc, i + 1, 2);
	}
	else {
#endif	// if 0
	  GET_4_ENTRIES;
	  if ((pcentryState(entry) == 0) && (entry1->opcode == opc_iastore1)) {
#ifdef COMPILE_DEBUG
	    if (compile_debug) {
	      printf("  boff:0x%x(%d)\n", entry->byteoff, entry->byteoff);
	      printf("   fst,...,iastore found.\n");
	      fflush(stdout);
	    }
#endif
	    entry->opcode = opc_fst_fastore;
	    entry->operand = entry4->operand;
	    pctableNDelete(cc, i + 1, 3);
	  }
#if 0
	}
#endif	// 0
      }
      break;

    case opc_iload:
      // load a float value to a FPU register directly
      GET_2_ENTRIES;
      if ((entry1->opcode == opc_flush_cache) && (entry2->opcode == opc_fld)) {
#ifdef COMPILE_DEBUG
	if (compile_debug) {
	  printf("  boff:0x%x(%d)\n", entry->byteoff, entry->byteoff);
	  printf("   fload,flush_cache,fld found.\n");
	  fflush(stdout);
	}
#endif
	entry1->opcode = opc_fload_fld;
	entry1->operand = entry->operand;

	entry->opcode = opc_flush_cache;

	pctableDelete(cc, i + 2);
      }
      break;

    case opc_lload:
      // load a double value to a FPU register directly
      GET_2_ENTRIES;
      if ((entry1->opcode == opc_flush_cache) && (entry2->opcode == opc_dld)) {
#ifdef COMPILE_DEBUG
	if (compile_debug) {
	  printf("  boff:0x%x(%d)\n", entry->byteoff, entry->byteoff);
	  printf("   dload,flush_cache,dld found.\n");
	  fflush(stdout);
	}
#endif
	entry1->opcode = opc_dload_dld;
	entry1->operand = entry->operand;

	entry->opcode = opc_flush_cache;

	pctableDelete(cc, i + 2);
      }
      break;

    case opc_istore:
      // save wasteful `iload'
      GET_1_ENTRY;
      if ((entry1->opcode == opc_iload) &&
	  (entry->operand == entry1->operand)) {
#ifdef COMPILE_DEBUG
	if (compile_debug) {
	  printf("  boff:0x%x(%d)\n", entry->byteoff, entry->byteoff);
	  printf("   istore %d,iload %d found.\n",
		entry->operand, entry1->operand);
	  fflush(stdout);
	}
#endif
	entry->opcode = opc_istld;
	pctableDelete(cc, i + 1);
      }
      break;

    case opc_lstore:
      // save wasteful `lload'
      GET_1_ENTRY;
      if ((entry1->opcode == opc_lload) &&
	  (entry->operand == entry1->operand)) {
#ifdef COMPILE_DEBUG
	if (compile_debug) {
	  printf("  boff:0x%x(%d)\n", entry->byteoff, entry->byteoff);
	  printf("   lstore %d,lload %d found.\n",
		entry->operand, entry1->operand);
	  fflush(stdout);
	}
#endif
	entry->opcode = opc_lstld;
	pctableDelete(cc, i + 1);
      }
      break;

    case opc_iaload:
      GET_2_ENTRIES;
      if ((entry1->opcode == opc_flush_cache) && (entry2->opcode == opc_fld)) {
#ifdef COMPILE_DEBUG
	if (compile_debug) {
	  printf("  boff:0x%x(%d)\n", entry->byteoff, entry->byteoff);
	  printf("   faload,flush_cache,fld found.\n",
		entry->operand, entry1->operand);
	  fflush(stdout);
	}
#endif
	entry->opcode = opc_faload_fld;
	pctableNDelete(cc, i + 1, 2);
      }
      break;

    case opc_laload:
      GET_2_ENTRIES;
      if ((entry1->opcode == opc_flush_cache) && (entry2->opcode == opc_dld)) {
#ifdef COMPILE_DEBUG
	if (compile_debug) {
	  printf("  boff:0x%x(%d)\n", entry->byteoff, entry->byteoff);
	  printf("   daload,flush_cache,dld found.\n",
		entry->operand, entry1->operand);
	  fflush(stdout);
	}
#endif
	entry->opcode = opc_daload_dld;
	pctableNDelete(cc, i + 1, 2);
      }
      break;
    }
  }

#ifdef COMPILE_DEBUG
  if (compile_debug) {
    printf("optIntCode done.\n");
    fflush(stdout);
  }
#endif
}
#endif	// OPTIMIZE_INTERNAL_CODE
