/*
  This file is part of shuJIT,
  Just In Time compiler for Sun Java Virtual Machine.

  Copyright (C) 1996,1997,1998,1999,2000 SHUDO Kazuyuki

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  $Id$
*/

//
// Internal Opcodes
//
#define	opc_impdep1	254	// 0xfe
#define	opc_impdep2	255	// 0xff


#define	opc_methodhead	230	// 0xe6
#define	opc_epilogue	231
#define	opc_exc_handler	232
#define	opc_methodtail	233
#define	opc_sync_enter	234
#define	opc_sync_exit	235

#define opc_inv_head	236	// 0xec
#define opc_inv_core	237
#define opc_inv_metavm	238

#define opc_inv_vir_obj		239	// 0xef
#define opc_inv_vir_varspace	240
#define opc_invokevirtual_obj	241

#define opc_inv_spe_obj		242
#define opc_inv_spe_varspace	243

#define opc_inv_stq_obj		244
#define opc_inv_stq_varspace	245

#define opc_direct_invoke	246	// 0xf6

#define	opc_invokeignored_static	247	// 0xf7
#define	opc_invokeignored_static_quick	248

#define	opc_throw_illegalaccess	249	// 0xf9
#define	opc_throw_noclassdef	250

#define	opc_fill_cache	251
#define	opc_flush_cache	252
#define	opc_array_check	253


#define	opc_strict_enter	256	// 0x100
#define	opc_strict_exit		257

#define	opc_fld4	258	// 0x102
#define	opc_fld		259
#define	opc_fst		260
#define	opc_dld8	261
#define	opc_dld		262
#define	opc_dst		263

#define	opc_fppc_save		264	// 0x108
#define	opc_fppc_restore	265
#define	opc_fppc_single		266
#define	opc_fppc_double		267
#define	opc_fppc_extended	268

#define	opc_strict_fprep	269	// 0x10d
#define	opc_strict_fscdown	270
#define	opc_strict_fscup	271
#define	opc_strict_fsettle	272
#define	opc_strict_dprep	273
#define	opc_strict_dscdown	274
#define	opc_strict_dscup	275
#define	opc_strict_dsettle	276

#define	opc_getstatic2	277	// 0x115
#define	opc_putstatic2	278
#define	opc_getfield2	279
#define	opc_putfield2	280

#define	opc_iastore1	281	// 0x119
#define	opc_lastore1	282

#define	opc_stateto0	283	// 0x11b
#define	opc_stateto1	284
#define	opc_stateto2	285
#define	opc_stateto3	286
#define	opc_stateto4	287

#define	opc_goto_st0	288	// 0x120
#define	opc_goto_st1	289
#define	opc_goto_st2	290
#define	opc_goto_st3	291
#define	opc_goto_st4	292

#define	opc_sqrt	293	// 0x125
#define	opc_sin		294
#define	opc_cos		295
#define	opc_tan		296
#define	opc_atan2	297
#define	opc_atan	298	// 0x12a
#define	opc_exp		299
#define	opc_log		300
#define	opc_floor	301
#define	opc_ceil	302

// for OPTIMIZE_INTERNAL_CODE
#define	opc_fload_fld	303	// 0x12f
#define opc_dload_dld	304
#define	opc_faload_fld	305
#define	opc_daload_dld	306

#define opc_fst_fstore	307
#define opc_dst_dstore	308
#define opc_fst_fastore	309
#define opc_dst_dastore	310

#define opc_istld	311	// 0x137
#define opc_lstld	312

#define	NOPCODES	313
