#!/usr/bin/perl
#
#   generate opcodes.h
#   from javasrc/src/share/javavm/include/opcodes.list
#	SHUDO Kazuyuki

$opcodes_list = "opcodes.list";
$opcodes_h = "opcodes.h";
$opcodes_c = "opcodes.c";

#$opcode_len_type = "unsigned char";	# don't work correctly...
$opcode_len_type = "unsigned short";
#$opcode_len_type = "int";


open(OPCODES_LIST, "$opcodes_list") || die "$!: $opcodes_list";
open(OPCODES_H, ">$opcodes_h") || die "$!: $opcodes_h";
open(OPCODES_C, ">$opcodes_c") || die "$!: $opcodes_c";


print OPCODES_H "// $opcodes_h\n";
print OPCODES_H "//   Don't edit this file.\n";
print OPCODES_H "//   This file is generated by the script opcodes.pl.\n";
print OPCODES_H "\n";


$count = 0;

while (<OPCODES_LIST>) {
	chomp;
	split;

	$opcode	= $_[0];
	$length	= $_[1];
	$pop	= $_[2];
	$push	= $_[3];

	if ($opcode =~ /^#/ || !$opcode) {
		# $B%3%a%s%H9T(B or $B6u9T(B
		next;
	}


	push(@opcodes, $opcode);
	push(@opcode_length, $length);
	push(@opcode_pop, $pop);
	push(@opcode_push, $push);

	# define opc_<opcode> number
	print OPCODES_H "#define opc_$opcode";
	printf OPCODES_H "\t%d\t// 0x%.2x len:%d\n",
		$count, $count, $length;
	$count++;
}
print OPCODES_H "\n";


# length
print OPCODES_H "extern " . $opcode_len_type . " opcode_length[];\n";

print OPCODES_C $opcode_len_type . " opcode_length[] = { ";
#print OPCODES_C "($opcode_len_type)";	# $B7?(B
print OPCODES_C shift(@opcode_length);
while (@opcode_length) {
	$length = shift(@opcode_length);
	print OPCODES_C ", ";
#	print OPCODES_C "($opcode_len_type)";	# $B7?(B
	print OPCODES_C "$length";
}
print OPCODES_C " };\n";

print OPCODES_C "\n";


# opcode
print OPCODES_H "extern char *opcode_symbol[];\n";

print OPCODES_C "char *opcode_symbol[] = { ";
$opcode = shift(@opcodes);
print OPCODES_C "\"$opcode\"";
while (@opcodes) {
	$opcode = shift(@opcodes);
	print OPCODES_C ", \"$opcode\"";
}
print OPCODES_C " };\n";

#print OPCODES_C "\n";


# pop
#print OPCODES_C "char *opcode_pop[] = { ";
#$pop = shift(@opcode_pop);
#print OPCODES_C "\"$pop\"";
#while (@opcode_pop) {
#	$pop = shift(@opcode_pop);
#	print OPCODES_C ", \"$pop\"";
#}
#print OPCODES_C " };\n";

#print OPCODES_C "\n";


## push
#print OPCODES_C "char *opcode_push[] = { ";
#$push = shift(@opcode_push);
#print OPCODES_C "\"$push\"";
#while (@opcode_push) {
#	$push = shift(@opcode_push);
#	print OPCODES_C ", \"$push\"";
#}
#print OPCODES_C " };\n";


close(OPCODES_LIST);
close(OPCODES_H);
close(OPCODES_C);


0;
