/*
  This file is part of shuJIT,
  Just In Time compiler for Sun Java Virtual Machine.

  Copyright (C) 1998,1999 SHUDO Kazuyuki

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  $Id$
*/

#include <string.h>	/* for strlen(), memcpy() */

#include "metavm.h"
#include "native.h"
#if 0
#include "NET_shudo_metavm_Proxy.h"
#endif
#include "NET_shudo_metavm_Proxy_old.h"
#include "NET_shudo_metavm_VMAddress_old.h"

#include "java_lang_Boolean_old.h"
#include "java_lang_Byte_old.h"
#include "java_lang_Character_old.h"
#include "java_lang_Short_old.h"
#include "java_lang_Integer_old.h"
#include "java_lang_Long_old.h"
#include "java_lang_Float_old.h"
#include "java_lang_Double_old.h"

#define PROXY_CLASSNAME	METAVM_PKG "Proxy"


/* Global Varialbe */
struct methodtable *proxy_methodtable;


static jclass jclz_Boolean = NULL;
static ClassClass *clz_Boolean = NULL;
static jclass jclz_Byte = NULL;
static ClassClass *clz_Byte = NULL;
static jclass jclz_Character = NULL;
static ClassClass *clz_Character = NULL;
static jclass jclz_Short = NULL;
static ClassClass *clz_Short = NULL;
static jclass jclz_Integer = NULL;
static ClassClass *clz_Integer = NULL;
static jclass jclz_Long = NULL;
static ClassClass *clz_Long = NULL;
static jclass jclz_Float = NULL;
static ClassClass *clz_Float = NULL;
static jclass jclz_Double = NULL;
static ClassClass *clz_Double = NULL;

static jclass jclz_ArrayOfObject = NULL;
static ClassClass *clz_ArrayOfObject = NULL;

jclass jclz_Proxy = NULL;
static ClassClass *clz_Proxy = NULL;

#define MID_DECL(METHOD_NAME)	jmethodID mid_##METHOD_NAME = NULL
MID_DECL(get32field);
MID_DECL(get64field);
MID_DECL(getobjfield);
MID_DECL(aload32);
MID_DECL(aload64);
MID_DECL(aloadobj);


JNIEXPORT void JNICALL Java_NET_shudo_metavm_Proxy_initNative
  (JNIEnv *env, jclass clazz) {
  ExecEnv *ee = JNIEnv2EE(env);
  ClassClass *cb = (ClassClass *)DeRef(env, clazz);
/*
printf("cb of Proxy: 0x%08x\n", (int)cb);
*/

  proxy_methodtable = unhand(cb)->methodtable;
/*
printf("proxy_methodtable: 0x%08x\n", (int)proxy_methodtable);
fflush(stdout);
*/

#define CLAZZ_INIT(JCLASS, CLASSNAME) \
  jclz_##JCLASS = (*env)->FindClass(env, CLASSNAME);\
  jclz_##JCLASS = (*env)->NewGlobalRef(env, jclz_##JCLASS);\
  clz_##JCLASS = DeRef(env, jclz_##JCLASS)
#define LANG_CLAZZ_INIT(JCLASS) \
  CLAZZ_INIT(JCLASS, "java/lang/" #JCLASS)

  LANG_CLAZZ_INIT(Boolean);
  LANG_CLAZZ_INIT(Byte);
  LANG_CLAZZ_INIT(Character);
  LANG_CLAZZ_INIT(Short);
  LANG_CLAZZ_INIT(Integer);
  LANG_CLAZZ_INIT(Float);
  LANG_CLAZZ_INIT(Long);
  LANG_CLAZZ_INIT(Double);

  CLAZZ_INIT(ArrayOfObject, "[Ljava/lang/Object;");

  CLAZZ_INIT(Proxy, PROXY_CLASSNAME);

#define MID_INIT(METHOD_NAME, SIG) \
    mid_##METHOD_NAME =\
	(*env)->GetMethodID(env, jclz_Proxy, #METHOD_NAME, "(I)" #SIG)

  MID_INIT(get32field, I);
  MID_INIT(get64field, J);
  MID_INIT(getobjfield, Ljava/lang/Object;);
  MID_INIT(aload32, I);
  MID_INIT(aload64, J);
  MID_INIT(aloadobj, Ljava/lang/Object;);
}


JHandle *proxy_new(ExecEnv *ee, ClassClass *fromClazz,
	HNET_shudo_metavm_VMAddress *addr, ClassClass *cb) {
  JHandle *obj;

  char orig = GET_REMOTE_FLAG(ee);
  REMOTE_FLAG_OFF(ee);
#ifdef RUNTIME_DEBUG
  printf("proxy_new(0x%08x, 0x%08x, %s(0x%08x)) called.\n",
	(int)ee, (int)addr, (cb?cbName(cb):"null"), (int)cb);
  fflush(stdout);
#endif

  obj = (JHandle *)do_execute_java_method(ee, clz_Proxy,
	"get",
	"(Ljava/lang/Class;L" METAVM_PKG "VMAddress;Ljava/lang/Class;)L" METAVM_PKG "Proxy;",
	NULL,	/* struct methodblock */
	TRUE,	/* isStaticCall */
	fromClazz, addr, cb);
#ifdef RUNTIME_DEBUG
  if (exceptionOccurred(ee)) {
    printf("exc. occurred.\n");
    fflush(stdout);
  }
#endif

  SET_REMOTE_FLAG(ee, orig);

#ifdef RUNTIME_DEBUG
  printf("proxy_new() done. obj: 0x%08x\n", (int)obj);
  fflush(stdout);
#endif
  return obj;
}


JHandle *proxy_newarray(ExecEnv *ee, ClassClass *fromClazz,
	HNET_shudo_metavm_VMAddress *addr, int type, int count) {
  JHandle *obj;

  char orig = GET_REMOTE_FLAG(ee);
  REMOTE_FLAG_OFF(ee);
#ifdef RUNTIME_DEBUG
  printf("proxy_newarray() type, count: %d, %d\n", type, count);
  fflush(stdout);
#endif

  obj = (JHandle *)do_execute_java_method(ee, clz_Proxy,
	"get",
	"(Ljava/lang/Class;L" METAVM_PKG "VMAddress;II)L" METAVM_PKG "Proxy;",
	NULL,	/* struct methodblock */
	TRUE,	/* isStaticCall */
	fromClazz, addr, type, count);
#ifdef RUNTIME_DEBUG
  if (exceptionOccurred(ee)) {
    printf("exc. occurred.\n");
    fflush(stdout);
  }
#endif

  SET_REMOTE_FLAG(ee, orig);

#ifdef RUNTIME_DEBUG
  printf("proxy_newarray() done. obj: 0x%08x\n", (int)obj);
  fflush(stdout);
#endif
  return obj;
}


JHandle *proxy_anewarray(ExecEnv *ee, ClassClass *fromClazz,
	HNET_shudo_metavm_VMAddress *addr, ClassClass *cb, int count) {
  JHandle *obj;

  char orig = GET_REMOTE_FLAG(ee);
  REMOTE_FLAG_OFF(ee);

  obj = (JHandle *)do_execute_java_method(ee, clz_Proxy,
	"get",
	"(Ljava/lang/Class;L" METAVM_PKG "VMAddress;Ljava/lang/Class;I)L" METAVM_PKG "Proxy;",
	NULL,	/* struct methodblock */
	TRUE,	/* isStaticCall */
	fromClazz, addr, cb, count);
#ifdef RUNTIME_DEBUG
  if (exceptionOccurred(ee)) {
    printf("exc. occurred.\n");
    fflush(stdout);
  }
#endif

  SET_REMOTE_FLAG(ee, orig);

#ifdef RUNTIME_DEBUG
  printf("proxy_anewarray() done. obj: 0x%08x\n", (int)obj);
  fflush(stdout);
#endif
  return obj;
}


JHandle *proxy_multianewarray(ExecEnv *ee, ClassClass *fromClazz,
	HNET_shudo_metavm_VMAddress *addr, ClassClass *cb,
	int dim, stack_item *stackpointer) {
  JNIEnv *env = EE2JNIEnv(ee);
  jintArray sizes;
  jint *csizes;
  JHandle *obj;
  int i;

  char orig = GET_REMOTE_FLAG(ee);
  REMOTE_FLAG_OFF(ee);
#ifdef RUNTIME_DEBUG
  printf("proxy_multianewarray(dim: %d) called.\n", dim);
  fflush(stdout);
#endif

  sizes = (*env)->NewIntArray(env, dim);
  csizes = (*env)->GetIntArrayElements(env, sizes, NULL);

  stackpointer += (dim - 1);
  for (i = 0; i < dim; i++) {
    int size = stackpointer->i;
#ifdef RUNTIME_DEBUG
    printf("  %d: %d\n", i, size);  fflush(stdout);
#endif
#ifndef NO_CHECK
    if (size < 0)	/* NegativeArraySizeException */
      return (JHandle *)-1;
#endif
    csizes[i] = size;
    stackpointer--;
  }

  (*env)->ReleaseIntArrayElements(env, sizes, csizes, JNI_COMMIT);


  obj = (JHandle *)do_execute_java_method(ee, clz_Proxy,
	"get",
	"(Ljava/lang/Class;L" METAVM_PKG "VMAddress;Ljava/lang/Class;[I)L" METAVM_PKG "Proxy;",
	NULL,	/* struct methodblock */
	TRUE,	/* isStaticCall */
	fromClazz, addr, cb, DeRef(env, sizes));
#ifdef RUNTIME_DEBUG
  if (exceptionOccurred(ee)) {
    printf("exc. occurred.\n");
    fflush(stdout);
  }
#endif

  SET_REMOTE_FLAG(ee, orig);

#ifdef RUNTIME_DEBUG
  printf("proxy_multianewarray() done. obj: 0x%08x\n", (int)obj);
  fflush(stdout);
#endif
  return obj;
}


/* definitions of proxy_get*field() */
#define GET_FIELD(METHOD_NAME, JTYPE, SIG, CTYPE, JNITYPE, POSTPROC) \
CTYPE proxy_##METHOD_NAME(ExecEnv *ee, JHandle *proxy, int32_t slot) {\
  JNIEnv *env = EE2JNIEnv(ee);\
  jobject obj = (jobject)MkRefLocal(env, proxy, JNI_REF_HANDLE_TAG);\
  jvalue args[1];\
  JNITYPE val;\
  \
  char orig = GET_REMOTE_FLAG(ee);\
  REMOTE_FLAG_OFF(ee);\
  \
  /* prepare arguments */\
  args[0].i = (jint)slot;\
  \
  val = (*env)->Call##JTYPE##MethodA(env, obj, mid_##METHOD_NAME, args);\
  \
  SET_REMOTE_FLAG(ee, orig);\
  \
  return POSTPROC;\
}

GET_FIELD(get32field, Int, I, int32_t, jint, (int32_t)val);
GET_FIELD(get64field, Long, J, int64_t, jlong, (int64_t)val);
GET_FIELD(getobjfield, Object, Ljava/lang/Object;, JHandle *, jobject, DeRef(env, val));


/* definitions of proxy_put*field() */
#define PUT_FIELD(METHOD_NAME, SIG, CTYPE) \
void proxy_##METHOD_NAME(ExecEnv *ee,\
	JHandle *proxy, int32_t slot, CTYPE val) {\
  char orig = GET_REMOTE_FLAG(ee);\
  REMOTE_FLAG_OFF(ee);\
  \
  do_execute_java_method(ee, proxy,\
		#METHOD_NAME, "(I" #SIG ")V",\
		NULL,	/* struct methodblock */\
		FALSE,	/* isStaticCall */\
		slot, val);\
  \
  SET_REMOTE_FLAG(ee, orig);\
}

PUT_FIELD(put32field, I, int32_t);
PUT_FIELD(put64field, J, int64_t);
PUT_FIELD(putobjfield, Ljava/lang/Object;, JHandle *);


/* definitions of proxy_aload*() */
GET_FIELD(aload32, Int, I, int32_t, jint, (int32_t)val);
GET_FIELD(aload64, Long, J, int64_t, jlong, (int64_t)val);
GET_FIELD(aloadobj, Object, Ljava/lang/Object;, JHandle *, jobject, DeRef(env, val));


/* definitions of proxy_astore*() */
PUT_FIELD(astore32, I, int32_t);
PUT_FIELD(astore64, J, int64_t);
PUT_FIELD(astoreobj, Ljava/lang/Object;, JHandle *);


int32_t proxy_arraylength(ExecEnv *ee, JHandle *proxy) {
  int32_t len;

  char orig = GET_REMOTE_FLAG(ee);
  REMOTE_FLAG_OFF(ee);

  len = (int32_t)do_execute_java_method(ee, proxy,
	"arraylength", "()I",
	NULL,
	FALSE);	/* isStaticCall */
#ifdef RUNTIME_DEBUG
  if (exceptionOccurred(ee)) {
    printf("exc. occurred.\n");
    fflush(stdout);
  }
#endif

  SET_REMOTE_FLAG(ee, orig);

  return len;
}


int proxy_invoke(ExecEnv *ee, JHandle *proxy,
	struct methodblock *mb, int32_t slot, char *sig,
	stack_item *stackpointer) {
  JNIEnv *env = EE2JNIEnv(ee);
  int args_size;	/* in 4byte, mb->args_size */
  stack_item *var_base, *spptr;
  int args_len;	/* number of elements, NOT size */
  char *p;
  HArrayOfObject *args = NULL;  JHandle **args_body;  JHandle *args_elem;
  JHandle *ret;
  int ret_size;
  int i;

  char orig = GET_REMOTE_FLAG(ee);
  REMOTE_FLAG_OFF(ee);

#ifdef RUNTIME_DEBUG
  printf("proxy_invoke(sp: 0x%08x) called.\n", (int)stackpointer);
  printf("  proxy: 0x%08x\n", (int)proxy);
  printf("  slot : %d\n", slot);
  printf("  sig  : %s\n", sig);
  printf("  remote flag: %d\n",  GET_REMOTE_FLAG(ee));
  fflush(stdout);
#endif


  /* args_size and var_base */
  args_size = mb->args_size;
  var_base = stackpointer + args_size - 1;
#ifdef RUNTIME_DEBUG
  printf("args_size: %d\n", args_size);
  fflush(stdout);

  spptr = var_base;
  printf("args on stack: 0x%x", *(int *)(spptr--));
  for (i = 1; i < args_size; i++)
    printf(", 0x%x", *(int *)(spptr--));
  printf("\n");
  fflush(stdout);
#endif


  /* number of arguments */
  args_len = 0;
  for (p = sig + 1; *p != ')'; p++) {
    args_len++;

    switch (*p) {
    case 'L':
      while (*p != ';')  p++;
      break;
    case '[':
      do { p++; } while (*p == '[');
      if (*p == 'L')  while (*p != ';')  p++;
    }
  }
#ifdef RUNTIME_DEBUG
  printf("args_len: %d\n", args_len);
#endif

  p = sig + 1;

  if (args_len > 0) {
    int64_t longVal;
    double doubleVal;

    args = (HArrayOfObject *)ArrayAlloc(T_CLASS, args_len);
    unhand(args)->body[args_len] = (HObject *)classJavaLangObject;
    MkRefLocal(env, args, JNI_REF_HANDLE_TAG);	/* register as local ref */
#ifdef RUNTIME_DEBUG
    printf("classJavaLangObject: 0x%08x\n", (int)classJavaLangObject);
    fflush(stdout);
#endif

    args_body = unhand(args)->body;
#ifdef RUNTIME_DEBUG
    printf("args, args_body: 0x%08x, 0x%08x\n", (int)args, (int)args_body);
    fflush(stdout);
#endif

#define COPY_ARG(JCLASS, SIG, QUOTED_SIG, SP_PREPROC, SP_ELEM, SP_POSTPROC) \
    case QUOTED_SIG:\
      args_elem = newobject(clz_##JCLASS, NULL, ee);\
      \
      SP_PREPROC;\
      do_execute_java_method(ee, args_elem,\
		"<init>", "(" #SIG ")V",\
		NULL,	/* struct methodblock */\
		FALSE,	/* isStaticCall */\
		SP_ELEM);\
      SP_POSTPROC;\
      args_body[i] = args_elem;\
      break

    spptr = var_base - 1;
    for (i = 0; i < args_len; i++) {
      switch (*p) {
      case 'L':
	args_body[i] = (spptr--)->h;
	while (*p != ';')  p++;
	break;
      case '[':
	p++;
	args_body[i] = (spptr--)->h;
	if (*p == 'L')  while (*p != ';')  p++;
	break;
      COPY_ARG(Boolean, Z, 'Z',		, spptr->i, spptr--);
      COPY_ARG(Byte, B, 'B',		, spptr->i, spptr--);
      COPY_ARG(Character, C, 'C',	, spptr->i, spptr--);
      COPY_ARG(Short, S, 'S',  		, spptr->i, spptr--);
      COPY_ARG(Integer, I, 'I',		, spptr->i, spptr--);
      COPY_ARG(Float, F, 'F',		, spptr->f, spptr--);
      COPY_ARG(Long, J, 'J',		memcpy(&longVal, spptr-1, 8);,
		longVal, spptr-=2);
      COPY_ARG(Double, D, 'D',		memcpy(&doubleVal, spptr-1, 8);,
		doubleVal, spptr-=2);
      }

      p++;
    }
  }	/* if (args_len > 0) */
  while (*p != ')')  p++;
  p++;
	/* Now, p points sig. of return value */
#ifdef RUNTIME_DEBUG
  {
    int i;
    for (i = 0; i < args_len; i++)
      printf("args[%d]: 0x%08x\n", i, (int)args_body[i]);
    fflush(stdout);
  }
#endif


  /* calculate size of return value */
  switch (*p) {
  case 'V':
    ret_size = 0;
    break;
  case 'L':  case '[':
  case 'Z':  case 'B':  case 'C':  case 'S':  case 'I':  case 'F':
    ret_size = 1;
    break;
  case 'J':  case 'D':
    ret_size = 2;
    break;
  default:
    printf("FATAL: invalid signature of return type : %c\n", *p);
    fflush(stdout);
    break;
  }

  /* invoke */
  {
    JavaFrame *cur_frame = ee->current_frame;
    stack_item *optop = cur_frame->optop;
    JHandle *ret;

#ifdef RUNTIME_DEBUG
    printf("args: 0x%08x\n", (int)args);
    fflush(stdout);
#endif

    ret = (JHandle *)do_execute_java_method(ee, proxy,
		"invoke", "(ILjava/lang/String;[Ljava/lang/Object;)Ljava/lang/Object;",
		NULL,	/* struct methodblock */
		FALSE,	/* isStaticCall */
		slot, makeJavaStringUTF(sig), args);
    if (exceptionOccurred(ee))
      return -1;
#ifdef RUNTIME_DEBUG
    printf("ret: 0x%08x\n", (int)ret);
    fflush(stdout);
#endif

    switch (*p) {
    case 'L':  case '[':
      optop->h = ret;
      cur_frame->optop++;
      break;
    case 'Z':
      optop->i = unhand((Hjava_lang_Boolean *)ret)->value;
      cur_frame->optop++;  break;
    case 'B':
      optop->i = unhand((Hjava_lang_Byte *)ret)->value;
      cur_frame->optop++;  break;
    case 'C':
      optop->i = unhand((Hjava_lang_Character *)ret)->value;
      cur_frame->optop++;  break;
    case 'S':
      optop->i = unhand((Hjava_lang_Short *)ret)->value;
      cur_frame->optop++;  break;
    case 'I':
      optop->i = unhand((Hjava_lang_Integer *)ret)->value;
      cur_frame->optop++;  break;
    case 'J':
      {
	int64_t val = unhand((Hjava_lang_Long *)ret)->value;
	optop[0].i = ((int32_t *)&val)[0];
	optop[1].i = ((int32_t *)&val)[1];
	cur_frame->optop += 2;
      }
      break;
    case 'F':
      optop->f = unhand((Hjava_lang_Float *)ret)->value;
      cur_frame->optop++;  break;
    case 'D':
      {
	double val = unhand((Hjava_lang_Double *)ret)->value;
	optop[0].i = ((int32_t *)&val)[0];
	optop[1].i = ((int32_t *)&val)[1];
	cur_frame->optop += 2;
      }
      break;
    }
  }

  SET_REMOTE_FLAG(ee, orig);

#ifdef RUNTIME_DEBUG
  printf("proxy_invoke() done.\n");
  fflush(stdout);
#endif
  return ret_size;
}


int proxy_monitorenter(ExecEnv *ee, JHandle *proxy) {
  do_execute_java_method(ee, proxy,
		"monitorEnter", "()V",
		NULL,	/* struct methodblock */
		FALSE);	/* isStaticCall */

  if (exceptionOccurred(ee))
    return -1;
  else
    return 0;
}


int proxy_monitorexit(ExecEnv *ee, JHandle *proxy) {
  do_execute_java_method(ee, proxy,
		"monitorExit", "()V",
		NULL,	/* struct methodblock */
		FALSE);	/* isStaticCall */

  if (exceptionOccurred(ee))
    return -1;
  else
    return 0;
}
