/*
  This file is part of shuJIT,
  Just In Time compiler for Sun Java Virtual Machine.

  Copyright (C) 1998,1999 SHUDO Kazuyuki

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  $Id$
*/

#include "NET_shudo_metavm_MetaVM.h"

#include "native.h"	/* for type ExecEnv */
#include "sys_api.h"	/* for sys*() */
#include "java_lang_Thread.h"	/* for ->eetop */

#include "metavm.h"


JNIEXPORT jboolean JNICALL Java_NET_shudo_metavm_MetaVM_remoteTransparency__
  (JNIEnv *env, jclass clazz) {
  ExecEnv *ee = JNIEnv2EE(env);

  if (!ee)  return JNI_FALSE;

  return GET_REMOTE_FLAG(ee);
}

JNIEXPORT jboolean JNICALL Java_NET_shudo_metavm_MetaVM_remoteTransparency__Z
  (JNIEnv *env, jclass clazz, jboolean flag) {
  ExecEnv *ee = JNIEnv2EE(env);
  jboolean orig;
#if 0
  printf("remoteTransparency(%s) called.\n", (flag?"true":"false"));
  fflush(stdout);
#endif
  if (!ee)  return JNI_FALSE;
  orig = (jboolean)GET_REMOTE_FLAG(ee);

  SET_REMOTE_FLAG(ee, flag);	/* JNI_TRUE or JNI_FALSE */

  return orig;
}

JNIEXPORT jboolean JNICALL Java_NET_shudo_metavm_MetaVM_remoteTransparency__Ljava_lang_Thread_2Z
  (JNIEnv *env, jclass clazz, jobject thr, jboolean flag) {
  ExecEnv *ee;
  jboolean orig;

  if (!thr) {
#ifdef RUNTIME_DEBUG
    printf("remoteTransparency(): thread is null.\n");
    fflush(stdout);
#endif
    return JNI_FALSE;
  }
#if 0
  printf("remoteTransparency(0x%x, %s) called.\n",
	(int)DeRef(env, thr), (flag?"true":"false"));
  fflush(stdout);
#endif

  ee = (ExecEnv *)unhand((Hjava_lang_Thread *)DeRef(env, thr))->eetop;
  if (!ee)  return JNI_FALSE;
  orig = (jboolean)GET_REMOTE_FLAG(ee);
  SET_REMOTE_FLAG(ee, flag);

  return orig;
}


JNIEXPORT void JNICALL Java_NET_shudo_metavm_MetaVM_instantiationVM0__LNET_shudo_metavm_VMAddress_2
  (JNIEnv *env, jclass clazz, jobject vmaddr) {
  ExecEnv *ee = JNIEnv2EE(env);

  REMOTE_ADDR(ee) = (JHandle *)DeRef(env, vmaddr);
}

JNIEXPORT jobject JNICALL Java_NET_shudo_metavm_MetaVM_instantiationVM0__
  (JNIEnv *env, jclass clazz) {
  ExecEnv *ee = JNIEnv2EE(env);
  JHandle *h;

  if (!ee)  return NULL;

  h = REMOTE_ADDR(ee);
  REMOTE_ADDR(ee) = NULL;

  if (h)
    return MkRefLocal(env, (void *)h, JNI_REF_HANDLE_TAG);
  else
    return NULL;
}
