/*
  This file is part of shuJIT,
  Just In Time compiler for Sun Java Virtual Machine.

  Copyright (C) 1998,1999 SHUDO Kazuyuki

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  $Id$
*/

package NET.shudo.metavm;

import java.net.Socket;
import java.io.IOException;
import java.io.DataOutputStream;
import java.io.DataInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedInputStream;
import java.util.Dictionary;


/**
 * An object of this class distributes class definitions.
 *
 * @see NET.shudo.metavm.RemoteClassLoader
 */
public
class ClassDistributor implements Runnable {
  private Socket sock = null;
  private Dictionary classfileTable = null;
  private boolean debug;

  private DataOutputStream out;
  private DataInputStream in;


  protected ClassDistributor(Socket sock, Dictionary classfileTable)
	throws IOException {
    this.sock = sock;
    this.classfileTable = classfileTable;
    this.debug = MetaVM.debug;

    out = new DataOutputStream(new BufferedOutputStream(
					sock.getOutputStream()));
    in = new DataInputStream(new BufferedInputStream(sock.getInputStream()));
  }


  public void run() {
    while (true) {
      try {
	String classname;
	byte[] classfile;

	// receive class name
	classname = in.readUTF();
	if (debug) {
	  System.out.println("ClassDistributor classname: " + classname);
	  System.out.flush();
	}

	synchronized(classfileTable) {
	  classfile = (byte[])classfileTable.get(classname);
	}
	if (classfile == null) {
	  classfile = LocalClassLoader.loadClassfileLocally(classname);
	  if (classfile == null || classfile.length <= 0) {
	    out.writeInt(-1);
	    out.flush();
	    continue;
	  }

	  synchronized(classfileTable) {
	    classfileTable.put(classname, classfile);
	  }
	}

	if (debug) {
	  System.out.println("ClassDistributor length: " + classfile.length);
	  System.out.flush();
	}
	out.writeInt(classfile.length);
	out.write(classfile);
	out.flush();
      }
      catch (IOException e) {
	if (debug) {
	  System.out.println("ClassDistributor an exc. occurred:");
	  e.printStackTrace();
	}
	break;
      }
    }	// while (true)
  }
}
