/*
  This file is part of shuJIT,
  Just In Time compiler for Sun Java Virtual Machine.

  Copyright (C) 1998,1999 SHUDO Kazuyuki

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  $Id$
*/

package NET.shudo.metavm;

import java.net.Socket;
import java.net.ServerSocket;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;


/**
 * This daemon accepts incoming connections and invoke ClassDistributors.
 *
 * @see NET.shudo.metavm.ClassDistributor
 */
public
class ClassDistributionDaemon implements Runnable {
  private Dictionary classfileTable = new Hashtable();
  private boolean debug;


  protected ClassDistributionDaemon() {
    this.debug = MetaVM.debug;
  }


  protected void reset() {
    synchronized(classfileTable) {
      classfileTable = new Hashtable();
    }
  }


  public void run() {
    ServerSocket servsock = null;
    int distributorCount = 0;

    if (debug) {
      System.out.println("ClassDistDaemon: port no. is " +
				VMAddress.classLoaderPort);
      System.out.flush();
    }
    try {
      servsock = new ServerSocket(VMAddress.classLoaderPort);
    }
    catch (IOException e) { e.printStackTrace();  System.exit(1); }

    // main loop
    while (true) {
      // accept
      Socket sock = null;

      try {
	sock = servsock.accept();
      }
      catch (IOException e) {
	if (debug)  e.printStackTrace();

	// to avoid busy loop
	try {  Thread.sleep(2000);  }
	catch (InterruptedException ie) {}

	continue;
      }
      if (debug) {
	System.out.println("ClassDistributionDaemon accepted");
	System.out.flush();
      }


      distributorCount++;

      Runnable distributor = null;
      try {
	distributor = new ClassDistributor(sock, classfileTable);
      }
      catch (IOException e) {
	distributor = null;
	if (debug)  e.printStackTrace();
	continue;
      }
      Thread t = new Thread(distributor,
			"Class Distributor " + distributorCount);
      t.start();
    }	// while (true)
  }
}
