/*
  This file is part of shuJIT,
  Just In Time compiler for Sun Java Virtual Machine.

  Copyright (C) 1998,1999 SHUDO Kazuyuki

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  $Id$
*/

package NET.shudo.metavm;


class ArrayOfIntWrapper implements ByValue {
  transient private int[] sizes = null;

  protected ArrayOfIntWrapper(int[] sizes) { this.sizes = sizes; }

  protected int[] sizes() { return this.sizes; }

  private void writeObject(java.io.ObjectOutputStream out)
	throws java.io.IOException {
    int len;

    if (sizes == null)
      len = 0;
    else
      len = sizes.length;

    out.writeByte(len);
    for (int i = 0; i < len; i++) {
      out.writeInt(sizes[i]);
    }
  }

  private void readObject(java.io.ObjectInputStream in)
	throws java.io.IOException, ClassNotFoundException {
    int len = in.readByte();
    sizes = new int[len];
    for (int i = 0; i < len; i++) {
      sizes[i] = in.readInt();
    }
  }
}
