/*
  This file is part of shuJIT,
  Just In Time compiler for Sun Java Virtual Machine.

  Copyright (C) 1998,1999 SHUDO Kazuyuki

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  $Id$
*/

#include "NET_shudo_metavm_ObjectID.h"
#include "native.h"	/* for MkRefLocal() */


JNIEXPORT jint JNICALL Java_NET_shudo_metavm_ObjectID_idByObject
  (JNIEnv *env, jclass clazz, jobject obj) {
#ifdef RUNTIME_DEBUG
  printf("idByObject() called.\n");
  fflush(stdout);
#endif
  return (jint)DeRef(env, obj);
}


JNIEXPORT jobject JNICALL Java_NET_shudo_metavm_ObjectID_objectById
  (JNIEnv *env, jclass clazz, jint id) {
#ifdef RUNTIME_DEBUG
  printf("objectById() called.\n");
  fflush(stdout);
#endif
  return (jobject)MkRefLocal(env, id, JNI_REF_HANDLE_TAG);
}
