/*
  This file is part of shuJIT,
  Just In Time compiler for Sun Java Virtual Machine.

  Copyright (C) 1998,1999 SHUDO Kazuyuki

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  $Id$
*/

#ifndef _METAVM_H_
#define _METAVM_H_

#include "../config.h"

#include "NET_shudo_metavm_VMAddress_old.h"	/* for proxy_new() */
#include "native.h"


#define METAVM_PKG	"NET/shudo/metavm/"

#define REMOTE_ADDR(EE)	((EE)->exception.exc)
#if JDK_VER == 11
#  define GET_REMOTE_FLAG(EE)	((EE)->alloc_cache.cache_pad[0])
#  define SET_REMOTE_FLAG(EE, FLAG) \
	((EE)->alloc_cache.cache_pad[0] = (char)(FLAG))
#else
#  define GET_REMOTE_FLAG(EE)	((int)((EE)->RESERVED1))
#  define SET_REMOTE_FLAG(EE, FLAG) \
	((EE)->RESERVED1 = (void *)(FLAG))
#endif	/* JDK_VER */

#define REMOTE_FLAG_OFF(EE)	SET_REMOTE_FLAG(EE, 0)
#define REMOTE_FLAG_ON(EE)	SET_REMOTE_FLAG(EE, 1)

/*
 * Global functions
 */
/* type.c */
extern int isCheckPassType(ClassClass *cb);
extern void forceToImplement(ExecEnv *ee, ClassClass *clazz, ClassClass *intf);

/* proxy.c */
extern JHandle *proxy_new(ExecEnv *, ClassClass *,
	HNET_shudo_metavm_VMAddress *, ClassClass *);
extern JHandle *proxy_newarray(ExecEnv *, ClassClass *,
	HNET_shudo_metavm_VMAddress *, int type, int count);
extern JHandle *proxy_anewarray(ExecEnv *, ClassClass *,
	HNET_shudo_metavm_VMAddress *, ClassClass *, int count);
extern JHandle *proxy_multianewarray(ExecEnv *, ClassClass *,
	HNET_shudo_metavm_VMAddress *, ClassClass *,
	int dim, stack_item *stackpointer);

#define DECL_GET_FIELD(NAME, CTYPE) \
	extern CTYPE proxy_##NAME(ExecEnv *, JHandle *proxy, int32_t slot);
DECL_GET_FIELD(get32field, int32_t)
DECL_GET_FIELD(get64field, int64_t)
DECL_GET_FIELD(getobjfield, JHandle *)
#define DECL_PUT_FIELD(NAME, CTYPE) \
	extern void proxy_##NAME(ExecEnv *, JHandle *proxy, int32_t, CTYPE);
DECL_PUT_FIELD(put32field, int32_t)
DECL_PUT_FIELD(put64field, int64_t)
DECL_PUT_FIELD(putobjfield, JHandle *)
#define DECL_ARRAY_LOAD(NAME, CTYPE) \
	extern CTYPE proxy_##NAME(ExecEnv *, JHandle *proxy, int32_t slot);

extern int proxy_invoke(ExecEnv *, JHandle *proxy,
	struct methodblock *mb, int32_t slot, char *sig,
	stack_item *stackpointer);
extern int proxy_monitorenter(ExecEnv *, JHandle *proxy);
extern int proxy_monitorexit(ExecEnv *, JHandle *proxy);

#endif	/* _METAVM_H_ */
