/*
  This file is part of shuJIT,
  Just In Time compiler for Sun Java Virtual Machine.

  Copyright (C) 1998,1999 SHUDO Kazuyuki

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  $Id$
*/

#include "metavm.h"

#include "jni.h"
#include "native.h"


#define BYVALUEUTIL_CLASSNAME	METAVM_PKG "ByValueUtil"


static jclass clz_ByValueUtil = NULL;


bool_t isByValue(ExecEnv *ee, ClassClass *clazz) {
  JNIEnv *env = EE2JNIEnv(ee);
  static jmethodID mid_isByValue = NULL;

  jboolean result;
#ifdef RUNTIME_DEBUG
  printf("isByValue(0x%08x, 0x%08x) called: ", (int)ee, (int)clazz);
  fflush(stdout);
  printf("%s\n", (clazz ? cbName(clazz) : "null"));
  fflush(stdout);
#endif

  if (!mid_isByValue) {
    clz_ByValueUtil = (*env)->FindClass(env, BYVALUEUTIL_CLASSNAME);
#if 0
    if (!clz_ByValueUtil) {
      /* not reached */
      printf("FATAL: class \"" BYVALUEUTIL_CLASSNAME "\" is not found.\n");
    }
#endif
    clz_ByValueUtil = (*env)->NewGlobalRef(env, clz_ByValueUtil);
    mid_isByValue = (*env)->GetStaticMethodID(env, clz_ByValueUtil,
			"isByValue", "(Ljava/lang/Class;)Z");
#if 0
    if (!clz_ByValueUtil) {
      /* not reached */
      printf("FATAL: class \"" BYVALUEUTIL_CLASSNAME "\" is not found.\n");
    }
#endif
  }

  result = (*env)->CallStaticBooleanMethod(env,
		clz_ByValueUtil, mid_isByValue,
		MkRefLocal(env, (void *)clazz, JNI_REF_HANDLE_TAG));

#ifdef RUNTIME_DEBUG
  printf("isByValue() returns: %s\n", (result?"true":"false"));
  fflush(stdout);
#endif
  return (bool_t)result;
}
