/*
  This file is part of shuJIT,
  Just In Time compiler for Sun Java Virtual Machine.

  Copyright (C) 1996,1997,1998,1999 SHUDO Kazuyuki

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  $Id$
*/

#ifndef _COMPILER_H_
#define _COMPILER_H_

#include "config.h"

#include "x86tsc.h"
#include "opcodes.h"

/*
 * Internal Opcodes
 */
#define opc_invokeignored_nocheck	230	/* 0xe6 */

#define opc_getstatic2	231	/* 0xe7 */
#define opc_putstatic2	232
#define opc_getfield2	233
#define opc_putfield2	234

#define opc_methodhead	235	/* 0xeb */
#define opc_exception_handler	236
#define opc_methodtail	237

#define opc_fill_cache	238	/* 0xee */
#define opc_array_check	239

#define opc_iastore1	240	/* 0xf0 */
#define opc_lastore1	241

#define opc_stateto0	242	/* 0xf2 */
#define opc_stateto1	243
#define opc_stateto2	244
#define opc_stateto3	245
#define opc_stateto4	246

#define opc_goto_st0	247	/* 0xf7 */
#define opc_goto_st1	248
#define opc_goto_st2	249
#define opc_goto_st3	250
#define opc_goto_st4	251

#define NOPCODES	256


/* offerred by Sun */
#include "native.h"


/* Additional type definition */

#if !(defined(_ILP32) || defined(_LP64))
#  ifndef _UINT16_T
#    define _UINT16_T
typedef unsigned short uint16_t;
#    endif	/* _UINT16_T */

#  ifndef __BIT_TYPES_DEFINED__
#    ifndef _INT16_T
#      define _INT16_T
typedef short int16_t;
#    endif	/* _INT16_T */
#  endif	/* __BIT_TYPES_DEFINED__ */

#endif	/* _ILP32, LP64 */

#  ifdef __FreeBSD__
typedef u_int16_t	uint16_t;
#  endif	/* __FreeBSD__ */


/* Additional macro definition */
#define handleToClassClass(h)	(java_lang_Object_getClass((HObject *)(h)))


/*
 * macro definition
 */

/* features */

#define NULLEXC_BY_SIGNAL
#define ARITHEXC_BY_SIGNAL
#define GET_SIGCONTEXT
#undef IGNORE_DISABLE
#undef NO_REWRITE
#undef INITCLASS_IN_COMPILING
#undef CONTROL_COMPILED_FLAG

#if defined(NULLEXC_BY_SIGNAL) || defined(ARITHEXC_BY_SIGNAL)
#define EXC_BY_SIGNAL
#endif

#if 0
#  ifdef RUNTIME_DEBUG
#    undef NULLEXC_BY_SIGNAL
#    undef ARITHEXC_BY_SIGNAL
#    undef EXC_BY_SIGNAL
#  endif
#endif


/* OS dependent macros */

#if defined(linux)
#  define EXECUTEJAVA_IN_ASM
#  ifdef GLIBC2
#    undef  RESOLVE_SYMBOL_ON_CODE
#  else
#    define RESOLVE_SYMBOL_ON_CODE
#  endif
#  define SEARCH_SIGCONTEXT
#  define LIBS_ADDDLSEG	NULL
#elif defined(__FreeBSD__)
#  undef  EXECUTEJAVA_IN_ASM
#  undef  RESOLVE_SYMBOL_ON_CODE
#  undef  SEARCH_SIGCONTEXT
#  define LIBS_ADDDLSEG	"/usr/lib/libc.so.3|/usr/lib/libc.so.3.1|/usr/lib/libc.so.3.0,/usr/lib/libm.so.2|/usr/lib/libm.so.2.0"
#else
#  undef  EXECUTEJAVA_IN_ASM
#  undef  RESOLVE_SYMBOL_ON_CODE
#  undef  SEARCH_SIGCONTEXT
#  define LIBS_ADDDLSEG	NULL
#endif


#if defined(EXC_BY_SIGNAL) || defined(GET_SIGCONTEXT)
#  define SIGCONTEXT struct sigcontext
#  if defined(linux)
#    define sigcontext_struct sigcontext
	/* to permute if asm/sigcontext.h defines sigcontext_struct */
#    include <asm/sigcontext.h>	/* for struct sigcontext */
#    include <linux/version.h>	/* for kernel version */
#    define SC_EAX	eax
#    define SC_ECX	ecx
#    define SC_EDX	edx
#    define SC_EBX	ebx
#    define SC_ESI	esi
#    define SC_EDI	edi
#    define SC_EIP	eip
#    define SC_EBP	ebp
#    define SC_ESP	esp
#    define SC_TRAPNO	trapno
#    define SC_ERR	err
#  elif defined(__FreeBSD__)
#    include <machine/signal.h>	/* for struct sigcontext */
#    define SC_EAX	sc_eax
#    define SC_ECX	sc_ecx
#    define SC_EDX	sc_edx
#    define SC_EBX	sc_ebx
#    define SC_ESI	sc_esi
#    define SC_EDI	sc_edi
#    define SC_EIP	sc_eip
#    define SC_EBP	sc_ebp
#    define SC_ESP	sc_esp
#    define SC_TRAPNO	sc_trapno
#    define SC_ERR	sc_err
#  else
#    define SC_EAX	eax
#    define SC_ECX	ecx
#    define SC_EDX	edx
#    define SC_EBX	ebx
#    define SC_ESI	esi
#    define SC_EDI	edi
#    define SC_EIP	eip
#    define SC_EBP	ebp
#    define SC_ESP	esp
#    define SC_TRAPNO	trapno
#    define SC_ERR	err
#  endif
#endif	/* EXC_BY_SIGNAL || GET_SIGCONTEXT */


/* OS independent macros */

#ifdef CODE_DB
#  undef CODE_DB_DEBUG

#  define CODEDB_PREFIX		"shujit-code"
#  define CODEDB_DB_SUFFIX	".db"
#  define CODEDB_PAGE_SUFFIX	".page"

#  define CODEDB_PAGE	CODEDB_PREFIX CODEDB_PAGE_SUFFIX
#  ifdef GDBM
#    define LIBDBM	"libgdbm.so"
#    define CODEDB_DB	CODEDB_PREFIX CODEDB_DB_SUFFIX
#  else
#    define LIBDBM	"libndbm.so"
#    define CODEDB_DB	CODEDB_PREFIX
#  endif
#endif	/* CODE_DB */


/*
 * Complement macros
 */
#if 1
#  include "sys_api.h"
#else
#  define sysMalloc	malloc
#  define sysFree	free
#  define sysCalloc	calloc
#  define sysRealloc	realloc
#endif

#if JDK_VER < 12
#  define monitorEnter2(EE, KEY)	monitorEnter(KEY)
#  define monitorExit2(EE, KEY)		monitorExit(KEY)
#  define JVM_LoadLibrary(NAME)	sysAddDLSegment(NAME)
#  define JVM_Exit(CODE)	sysExit(CODE)
#endif	/* JDK_VER */

#if JDK_VER >= 12
#  define CB_INITIALIZED(CB)	(CCIs((CB), Initialized))
#else
#  define CB_INITIALIZED(CB)	(CCIs((CB), Resolved))
#endif	/* JDK_VER */

#if 1
#  include "monitor.h"	/* for monitor{Enter,Exit}() and macro BINCLASS_*() */
#else
typedef struct sys_mon sys_mon_t;
extern sys_mon_t *_binclass_lock;
#  if (JDK_VER >= 12)
#    define BINCLASS_LOCK(self)	sysMonitorEnter(self, _binclass_lock)
#    define BINCLASS_UNLOCK(self)	sysMonitorExit(self, _binclass_lock)
#  else
#    define BINCLASS_LOCK()	sysMonitorEnter(_binclass_lock)
#    define BINCLASS_UNLOCK()	sysMonitorExit(_binclass_lock)
#  endif	/* JDK_VER */
#endif


#define JIT_LIB_NAME	"shujit"

#ifdef METAVM
#  define SYS_NAME	"MetaVM"
#else
#  define SYS_NAME	"shuJIT"
#endif
#  define CREDIT "  " SYS_NAME "  for Sun JVM/IA-32  Copyright 1998,1999 by SHUDO Kazuyuki\n"

#if JDK_VER < 12
#  define COMPILER_VERSION	5
#else
#  define COMPILER_VERSION	6
#endif	/* JDK_VER */

#define CODESIZE_FNAME	"jit_codesize"

/* STR(macro) is permuted to "value of the macro" */
#define _STR(T)	#T
#define STR(MACRO)	_STR(MACRO)


/*
 * Type definition
 */

/* CatchFrame_w_state is based on CatchFrame */
/* Requirement for C compiler:
	sizeof(CatchFrame_w_state) equals sizeof(CatchFrame) */
typedef struct CatchFrame_w_state {
#if JDK_VER < 12
  long start_pc, end_pc;
  long handler_pc;
  void *compiled_CatchFrame;
  short catchType;
#else
  unsigned short start_pc, end_pc;
  unsigned short handler_pc;
  void *compiled_CatchFrame;
  unsigned short catchType;
#endif
  short state;	/* added by SHUDO */
} CatchFrame_w_state;


#ifdef EXC_BY_SIGNAL
typedef struct throw_entry {
  uint32_t start;
  uint16_t len;
  unsigned char byteoff;
  unsigned char opcode;
} throwentry;
#endif	/* EXC_BY_SIGNAL */

typedef struct compiled_code_info {
  int32_t invocation_count;

  int32_t code_size;
  int32_t ret_size;
  char *argsizes;

  uint32_t exc_handler_nativeoff;
  uint32_t finish_return_nativeoff;

#ifdef EXC_BY_SIGNAL
#define DEFAULT_THROWTABLE_SIZE	8
  throwentry *throwtable;
  uint32_t throwtablelen;
  uint32_t throwtablesize;
#endif	/* EXC_BY_SIGNAL */
} CodeInfo;


typedef struct pcentry {
  uint16_t opcode;
  uint16_t state;
  uint32_t byteoff;
  uint32_t nativeoff;
} pcentry;

typedef struct jpentry {
  unsigned int tgtoff;
  unsigned int argoff;
} jpentry;

typedef struct compiler_context {
  ExecEnv *ee;
  struct methodblock *mb;

  /* buffer for compiled code */
#define DEFAULT_BUF_SIZE	8192
  unsigned char *buffer;
  int buf_size;
  unsigned char *bufp;

  /* program counter table */
#define DEFAULT_PCTABLE_SIZE	128
  int pctablesize;
  uint32_t pctablelen;
  pcentry *pctable;

  /* jump instruction table */
#define DEFAULT_JPTABLE_SIZE	128
  int jptablesize;
  int jptablelen;
  jpentry *jptable;

  struct compiler_context *next;
} CompilerContext;


/*
 * Global Variables
 */
/* in compiler.c */

#ifndef IGNORE_DISABLE
extern bool_t compiler_enabled;
#endif	/* IGNORE_DISABLE */

#if (defined(EXC_BY_SIGNAL) || defined(GET_SIGCONTEXT)) && defined(SEARCH_SIGCONTEXT)
#  ifdef linux
extern unsigned short reg_gs;
extern unsigned short reg_fs;
#  endif
extern unsigned short reg_es;
extern unsigned short reg_ds;
#  ifdef __FreeBSD__
extern unsigned short reg_cs;
extern unsigned short reg_ss;
#  endif
#endif	/* (EXC_BY_SIGNAL || GET_SIGCONTEXT) && SEARCH_SIGCONTEXT */

#ifdef CODE_DB
#  ifdef GDBM
#    include <gdbm.h>
extern GDBM_FILE db;
#  else
#    include <ndbm.h>
extern DBM *db;
#  endif
extern int db_page;
#endif	/* CODE_DB */

#define OPT_SET(N) (options |= (1 << (N)))
#define OPT_RESET(N) (options & ~(1 << (N)))
#define OPT_SETQ(N) (options & (1 << (N)))
enum opt_bit {
  OPT_QUIET = 0,
	/* suppress initial message and some outputs */
  OPT_OUTCODE,
	/* write generated code to code_<classname>_<methodname>.s */
  OPT_CODESIZE,
	/* write code size of each methods to the file jit_codesize */
  OPT_DONTCMPLVMCLZ,
	/* suppress compilation classes
	   which is already loaded when JIT is initialized */
  OPT_IGNDISABLE,
	/* make java.lang.Compiler#disable() void */
  OPT_CMPLCLINIT,
	/* compile class initializer */
#ifdef CODE_DB
  OPT_CODEDB,
	/* save and re-use generated native code */
#endif	/* CODE_DB */
  OPT_CMPLATLOAD
	/* compile the whole class when the class is loaded */
};
extern int options;
extern int opt_cmplthreshold;

extern void *sym_compileAndInvokeMethod;
extern void *sym_invokeJITCompiledMethod;
extern void *sym_invokeJavaMethod;
extern void *sym_invokeSynchronizedJavaMethod;
extern void *sym_invokeAbstractMethod;
extern void *sym_invokeNativeMethod;
extern void *sym_invokeSynchronizedNativeMethod;
extern void *sym_invokeJNINativeMethod;
extern void *sym_invokeJNISynchronizedNativeMethod;
extern void *sym_invokeLazyNativeMethod;
#ifdef CODE_DB
#  ifdef GDBM
extern GDBM_FILE (*sym_dbm_open)(char *,int,int,int,void (*)());
extern void (*sym_dbm_close)(GDBM_FILE);
extern int (*sym_dbm_store)(GDBM_FILE,datum,datum,int);
extern datum (*sym_dbm_fetch)(GDBM_FILE,datum);
extern void (*sym_dbm_sync)(GDBM_FILE);
#  else
extern DBM *(*sym_dbm_open)(const char *,int,int);
extern void (*sym_dbm_close)(DBM *);
extern int (*sym_dbm_store)(DBM *,datum,datum,int);
extern datum (*sym_dbm_fetch)(DBM *,datum);
#  endif
#endif	/* CODE_DB */

/* in code.c */
extern struct methodtable *object_methodtable;
	/* for the macro OBJ_ARRAY_METHODTABLE in code.h */

#ifdef METAVM
/* in proxy.c */
extern struct methodtable *proxy_methodtable;
#endif	/* METAVM */


/*
 * Global Functions
 */
/* in code.c */
extern volatile void assembledCode(
	JHandle *o, struct methodblock *mb, int args_size, ExecEnv *ee
#ifdef RUNTIME_DEBUG
	,int runtime_debug
#endif
);

/* in linker.c */
#if JDK_VER < 12
#  define symbolInSystemClassLoader(NAME)	sysDynamicLink(NAME)
#else
extern void *symbolInSystemClassLoader(char *name);
#endif	/* JDK_VER */

/* in computil.c */
extern void *access2invoker(int access);
extern char *nameOfInvoker(void *inv);

extern void showCompilerContext(CompilerContext *cc);
extern CompilerContext *getCompilerContext(struct methodblock *mb);
extern void releaseCompilerContext(CompilerContext *cc);
extern void writeToBuffer(CompilerContext *cc, void *, size_t);
extern void cancelOnBuffer(CompilerContext *cc, size_t);
extern void ensureBufferSize(CompilerContext *cc, size_t req);

#ifdef CODE_DB
extern void pctableExtend(CompilerContext *cc, uint32_t size);
#endif	/* CODE_DB */
extern void pctableClear(CompilerContext *cc);
extern void pctableAdd(CompilerContext *cc,
	int opcode, int state, unsigned int byteoff, unsigned int nativeoff);
extern void pctableInsert(CompilerContext *cc, int index,
	int opcode, int state, unsigned int byteoff, unsigned int nativeoff);
extern void pctableDelete(CompilerContext *cc, int index);
extern pcentry *pctableGet(CompilerContext *cc, int byteoff);

extern void jptableAdd(CompilerContext *cc,
	unsigned int tgtoff, unsigned int argoff);

extern CodeInfo *prepareCompiledCodeInfo(ExecEnv *ee, struct methodblock *mb);
extern void freeCompiledCodeInfo(CodeInfo *info);

#ifdef EXC_BY_SIGNAL
#ifdef CODE_DB
extern void throwtableExtend(CodeInfo *info, uint32_t size);
#endif	/* CODE_DB */
extern void throwtableAdd(CodeInfo *info, uint32_t start, uint16_t len,
	unsigned char byteoff, unsigned char opcode);
extern throwentry *throwtableGet(CodeInfo *info, uint32_t nativeoff);
#endif	/* EXC_BY_SIGNAL */


/* in invoker.c */
extern bool_t compileAndInvokeMethod(
	JHandle *o, struct methodblock *mb, int args_size, ExecEnv *ee);
#ifdef REENTER_DEBUG
bool_t redirectInvoker(
	JHandle *o, struct methodblock *mb, int args_size, ExecEnv *ee);
#endif	/* REENTER_DEBUG */
extern bool_t invokeJITCompiledMethod(
	JHandle *o, struct methodblock *mb, int args_size, ExecEnv *ee);

/* in compile.c */
extern int compileMethod(struct methodblock *mb);
extern void freeMethod(struct methodblock *mb);
#ifdef RESOLVE_SYMBOL_ON_CODE
extern void initFunctionSymbols();
#endif

#ifdef CODE_DB
/* in codedb.c */
void writeCompiledCode(
#  ifdef GDBM
GDBM_FILE db
#  else
DBM *db
#  endif
, int fd, CompilerContext *cc);
int readCompiledCode(
#  ifdef GDBM
GDBM_FILE db
#  else
DBM *db
#  endif
, int fd, CompilerContext *cc);
#endif	/* CODE_DB */

/* in runtime.c */
#if defined(EXC_BY_SIGNAL) || defined(GET_SIGCONTEXT)
extern void showSigcontext(SIGCONTEXT *sc);
#endif	/* EXC_BY_SIGNAL || GET_SIGCONTEXT */
extern int invocationHelper(
#ifdef RUNTIME_DEBUG
	int runtime_debug,
#endif
	JHandle *obj, struct methodblock *method, int args_size, ExecEnv *ee,
	stack_item *stackpointer, int retsize, int bytepcoff);
extern struct methodblock *getInterfaceMethod(
#ifdef RUNTIME_DEBUG
	int runtime_debug,
#endif
	ExecEnv *ee,
	JHandle *obj, struct methodblock *imethod, unsigned char *guessptr);
extern JHandle *multianewarray(
#ifdef RUNTIME_DEBUG
	int runtime_debug,
#endif
	ExecEnv *ee, int dimensions, ClassClass *arrayclazz,
	stack_item *stackpointer);
extern struct CatchFrame *searchCatchFrame(ExecEnv *ee, struct methodblock *mb,
	int bytepcoff
#ifdef RUNTIME_DEBUG
	, int runtime_debug
#endif
);
#ifndef NO_REWRITE
extern int once_in_new(ExecEnv *ee, ClassClass *cb);
#endif
#if JDK_VER < 12
extern void InitClass(ClassClass *cb);
	/* wrapper must be a function, not a macro */
#endif
extern void showStackFrames(ExecEnv *ee);
#if defined(RUNTIME_DEBUG) || defined(COMPILE_DEBUG)
extern void showExcStackTrace(JHandle *throwable);
#endif
#if defined(RUNTIME_DEBUG) || defined(COMPILE_DEBUG) || defined(EXC_BY_SIGNAL) || defined(GET_SIGCONTEXT)
extern struct methodblock *methodByPC(unsigned char *pc);
#endif
#ifdef RUNTIME_DEBUG
extern char *showObjectBody(char *sig, JHandle *obj);
#endif

#endif /* _COMPILER_H_ */
