/*
  This file is part of shuJIT,
  Just In Time compiler for Sun Java Virtual Machine.

  Copyright (C) 1998,1999 SHUDO Kazuyuki

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  $Id$
*/

#include "compiler.h"

#include "opcodes.h"
#include "code.h"

#ifdef METAVM
#include "metavm/metavm.h"
#include "metavm/NET_shudo_metavm_Proxy_old.h"	/* for type H...Proxy */
#include "metavm/NET_shudo_metavm_VMAddress_old.h"/* for type H...VMAddress */
#endif	/* METAVM */


#define COMPILEDCODE(DST) \
    asm("movl  %0,%" #DST : : "m" (mb));	/* DST = mb */\
    METHOD_COMPILEDCODE(DST,DST);	/* DST = mb->CompiledCode */


volatile void assembledCode(
	JHandle *o /* 8(%ebp) */ , struct methodblock *mb /* 12(%ebp) */,
	int args_size, ExecEnv *ee
#ifdef RUNTIME_DEBUG
	, int runtime_debug
#endif
) {
  int32_t bytepcoff;	/* -4(%ebp) */
	/* to handle exceptions */
  /*
    %esi: stack_item *vars
   */

  /*
   * utilities
   */

  /* fill_cache */
#ifdef RUNTIME_DEBUG
#  define FILL_CACHE_DEBUG1(OPTOP1_REG, OPTOP2_REG) \
  if (runtime_debug) {\
    DEBUG_IN;\
    asm("pushl " #OPTOP2_REG "\n\tflds  (%esp)\n\t"\
	"subl  $4,%esp\n\tfstpl (%esp)\n\t"\
	"pushl " #OPTOP2_REG "\n\tpushl " #OPTOP2_REG);\
    asm("pushl " #OPTOP1_REG "\n\tflds  (%esp)\n\t"\
	"subl  $4,%esp\n\tfstpl (%esp)\n\t"\
	"pushl " #OPTOP1_REG "\n\tpushl " #OPTOP1_REG);\
    PUSH_CONSTSTR("  optop[-1]: 0x%08x %d %g, optop[-2]: 0x%08x %d %g\n");\
    asm("call  " SYMBOL(printf) "@PLT\n\t"\
	"addl  $36,%esp");\
    FFLUSH;\
    DEBUG_OUT;\
  }
#else
#  define FILL_CACHE_DEBUG1(OPTOP1_REG, OPTOP2_REG)
#endif

  CODE(opc_fill_cache, fill_cache, ST0, ST2, 0) {
    asm("popl  %ecx\n\tpopl  %edx");
    FILL_CACHE_DEBUG1(%ecx, %edx);
  }
  CODE(opc_fill_cache, fill_cache, ST1, ST4, 0) {
    asm("popl  %ecx");
    FILL_CACHE_DEBUG1(%edx, %ecx);
  }
  CODE(opc_fill_cache, fill_cache, ST2, ST2, 0) {
    FILL_CACHE_DEBUG1(%ecx, %edx);
  }
  CODE(opc_fill_cache, fill_cache, ST3, ST2, 0) {
    asm("popl  %edx");
    FILL_CACHE_DEBUG1(%ecx, %edx);
  }
  CODE(opc_fill_cache, fill_cache, ST4, ST4, 0) {
    FILL_CACHE_DEBUG1(%edx, %ecx);
  }

  /* to another state */
  CODE(opc_stateto0, stateto00, ST0, ST0, 0) {}
  CODE(opc_stateto0, stateto10, ST1, ST0, 0) { asm("pushl %edx"); }
  CODE(opc_stateto0, stateto20, ST2, ST0, 0) {
    asm("pushl %edx\n\t"
	"pushl %ecx"); }
  CODE(opc_stateto0, stateto30, ST3, ST0, 0) { asm("pushl %ecx"); }
  CODE(opc_stateto0, stateto40, ST4, ST0, 0) {
    asm("pushl %ecx\n\t"
	"pushl %edx"); }
  CODE(opc_stateto1, stateto01, ST0, ST1, 0) { asm("popl  %edx"); }
  CODE(opc_stateto1, stateto11, ST1, ST1, 0) {}
  CODE(opc_stateto1, stateto21, ST2, ST1, 0) {
    asm("pushl %edx\n\t"
	"movl  %ecx,%edx"); }
  CODE(opc_stateto1, stateto31, ST3, ST1, 0) { asm("movl  %ecx,%edx"); }
  CODE(opc_stateto1, stateto41, ST4, ST1, 0) { asm("pushl %ecx"); }
  CODE(opc_stateto2, stateto02, ST0, ST2, 0) {
    asm("popl  %ecx\n\t"
	"popl  %edx"); }
  CODE(opc_stateto2, stateto12, ST1, ST2, 0) {
    asm("movl  %edx,%ecx\n\t"
	"popl  %edx"); }
  CODE(opc_stateto2, stateto22, ST2, ST2, 0) {}
  CODE(opc_stateto2, stateto32, ST3, ST2, 0) { asm("popl  %edx"); }
  CODE(opc_stateto2, stateto42, ST4, ST2, 0) { asm("xchg  %edx,%ecx"); }
  CODE(opc_stateto3, stateto03, ST0, ST3, 0) { asm("popl  %ecx"); }
  CODE(opc_stateto3, stateto13, ST1, ST3, 0) { asm("movl  %edx,%ecx"); }
  CODE(opc_stateto3, stateto23, ST2, ST3, 0) { asm("pushl %edx"); }
  CODE(opc_stateto3, stateto33, ST3, ST3, 0) {}
  CODE(opc_stateto3, stateto43, ST4, ST3, 0) {
    asm("pushl %ecx\n\t"
	"movl  %edx,%ecx"); }
  CODE(opc_stateto4, stateto04, ST0, ST4, 0) {
    asm("popl  %edx\n\t"
	"popl  %ecx"); }
  CODE(opc_stateto4, stateto14, ST1, ST4, 0) { asm("popl  %ecx"); }
  CODE(opc_stateto4, stateto24, ST2, ST4, 0) { asm("xchg  %edx,%ecx"); }
  CODE(opc_stateto4, stateto34, ST3, ST4, 0) {
    asm("movl  %ecx,%edx\n\t"
	"popl  %ecx"); }
  CODE(opc_stateto4, stateto44, ST4, ST4, 0) {}

  /* to another state and jump */
#define JUMP_TO_ACCUMULATOR	asm("jmp   *%eax")

  CODE(opc_goto_st0, goto_st00, ST0, ST0, 0) {
    JUMP_TO_ACCUMULATOR; }
  CODE(opc_goto_st0, goto_st10, ST1, ST0, 0) {
    asm("pushl %edx");
    JUMP_TO_ACCUMULATOR; }
  CODE(opc_goto_st0, goto_st20, ST2, ST0, 0) {
    asm("pushl %edx\n\t"
	"pushl %ecx");
    JUMP_TO_ACCUMULATOR; }
  CODE(opc_goto_st0, goto_st30, ST3, ST0, 0) {
    asm("pushl %ecx");
    JUMP_TO_ACCUMULATOR; }
  CODE(opc_goto_st0, goto_st40, ST4, ST0, 0) {
    asm("pushl %ecx\n\t"
	"pushl %edx");
    JUMP_TO_ACCUMULATOR; }
  CODE(opc_goto_st1, goto_st01, ST0, ST1, 0) {
    asm("popl  %edx");
    JUMP_TO_ACCUMULATOR; }
  CODE(opc_goto_st1, goto_st11, ST1, ST1, 0) {
    JUMP_TO_ACCUMULATOR; }
  CODE(opc_goto_st1, goto_st21, ST2, ST1, 0) {
    asm("pushl %edx\n\t"
	"movl  %ecx,%edx");
    JUMP_TO_ACCUMULATOR; }
  CODE(opc_goto_st1, goto_st31, ST3, ST1, 0) {
    asm("movl  %ecx,%edx");
    JUMP_TO_ACCUMULATOR; }
  CODE(opc_goto_st1, goto_st41, ST4, ST1, 0) {
    asm("pushl %ecx");
    JUMP_TO_ACCUMULATOR; }
  CODE(opc_goto_st2, goto_st02, ST0, ST2, 0) {
    asm("popl  %ecx\n\t"
	"popl  %edx");
    JUMP_TO_ACCUMULATOR; }
  CODE(opc_goto_st2, goto_st12, ST1, ST2, 0) {
    asm("movl  %edx,%ecx\n\t"
	"popl  %edx");
    JUMP_TO_ACCUMULATOR; }
  CODE(opc_goto_st2, goto_st22, ST2, ST2, 0) {
    JUMP_TO_ACCUMULATOR; }
  CODE(opc_goto_st2, goto_st32, ST3, ST2, 0) {
    asm("popl  %edx");
    JUMP_TO_ACCUMULATOR; }
  CODE(opc_goto_st2, goto_st42, ST4, ST2, 0) {
    asm("xchg  %edx,%ecx");
    JUMP_TO_ACCUMULATOR; }
  CODE(opc_goto_st3, goto_st03, ST0, ST3, 0) {
    asm("popl  %ecx");
    JUMP_TO_ACCUMULATOR; }
  CODE(opc_goto_st3, goto_st13, ST1, ST3, 0) {
    asm("movl  %edx,%ecx");
    JUMP_TO_ACCUMULATOR; }
  CODE(opc_goto_st3, goto_st23, ST2, ST3, 0) {
    asm("pushl %edx");
    JUMP_TO_ACCUMULATOR; }
  CODE(opc_goto_st3, goto_st33, ST3, ST3, 0) {
    JUMP_TO_ACCUMULATOR; }
  CODE(opc_goto_st3, goto_st43, ST4, ST3, 0) {
    asm("pushl %ecx\n\t"
	"movl  %edx,%ecx");
    JUMP_TO_ACCUMULATOR; }
  CODE(opc_goto_st4, goto_st04, ST0, ST4, 0) {
    asm("popl  %edx\n\t"
	"popl  %ecx");
    JUMP_TO_ACCUMULATOR; }
  CODE(opc_goto_st4, goto_st14, ST1, ST4, 0) {
    asm("popl  %ecx");
    JUMP_TO_ACCUMULATOR; }
  CODE(opc_goto_st4, goto_st24, ST2, ST4, 0) {
    asm("xchg  %edx,%ecx");
    JUMP_TO_ACCUMULATOR; }
  CODE(opc_goto_st4, goto_st34, ST3, ST4, 0) {
    asm("movl  %ecx,%edx\n\t"
	"popl  %ecx");
    JUMP_TO_ACCUMULATOR; }
  CODE(opc_goto_st4, goto_st44, ST4, ST4, 0) {
    JUMP_TO_ACCUMULATOR; }


  /*
   * invocation related codes
   */

  /* method head */
  CODE_WITHOUT_DEBUG(opc_methodhead, head, STANY, STSTA, 0) {
    asm("pushl %ebp\n\t"
	"movl  %esp,%ebp\n\t"
	"subl  $4,%esp\n\t"	/* 4 * #local_var */
#define SAVED_REG_AREA	16	/* 16 bytes: ecx,edx,edi,esi */
	"pushl %ecx\n\t"
	"pushl %edx\n\t"
	"pushl %edi\n\t"
	"pushl %esi");

#ifdef RUNTIME_DEBUG
    /* write class and method name */
    if (runtime_debug) {
      register struct methodblock *mb_reg asm("edi");

      DEBUG_IN;
      mb_reg = mb;

      asm("movl  " METHOD_NAME(%edi) ",%eax\n\t"
	  "testl %eax,%eax\n\t"
	  "jz    methodhead_name_done\n\t"
	  "pushl %eax");
      asm("movl  " METHOD_CLAZZ(%edi) ",%eax");
      CB_NAME(%eax, %eax);	/* break %edi */
      asm("pushl %eax");
      PUSH_CONSTSTR("  %s#%s\n");
      asm("call  " SYMBOL(printf) "@PLT\n\t"
	  "addl  $12,%esp");
      FFLUSH;
      asm("methodhead_name_done:");
      DEBUG_OUT;
    }
#endif	/* RUNTIME_DEBUG */

#ifdef RUNTIME_DEBUG
    if (runtime_debug) {
      asm("pushl %eax\n\t"
	  "movl  %esp,%eax");
      DEBUG_IN;
      asm("pushl %eax");
      PUSH_CONSTSTR("  ESP: 0x%08x\n");
      asm("call  " SYMBOL(printf) "@PLT\n\t"
	  "addl  $8,%esp");
      FFLUSH;
      DEBUG_OUT;
      asm("popl  %eax");
    }
#endif

    /* %esi = ee->current_frame->vars */
    {
      register ExecEnv *cur_ee asm("eax");
      cur_ee = ee;
    }
    asm("movl  " EE_CURRENTFRAME(%eax) ",%edi\n\t"
	"movl  " FRAME_VARS(%edi) ",%esi");
#ifdef RUNTIME_DEBUG
    if (runtime_debug) {
      DEBUG_IN;
      asm("pushl %esi");
      PUSH_CONSTSTR("  cached vars: 0x%08x\n");
      asm("call  " SYMBOL(printf) "@PLT\n\t"
	  "addl  $8,%esp");
      FFLUSH;
      DEBUG_OUT;
    }
#endif
  }

  /* method tail */
  CODE(opc_methodtail, tail, STANY, STSTA, 0) {
    asm("leal  -20(%ebp),%esp");
		/* -4 * (#local_var + #registers_on_stack) */
    asm("popl  %esi\n\t"
	"popl  %edi\n\t"
	"popl  %edx\n\t"
	"popl  %ecx\n\t"
	"leave\n\t"
	"ret");
  }

  /* exception handler */
  CODE(opc_exception_handler, exception_handler, STANY, STSTA, 0) {
#ifdef METAVM
    /* clear remote flag */
    asm("movl  %0,%%edi\n\t"
	"movb  $0," EE_REMOTE_FLAG(%%edi)
	: : "m" (ee));
#endif
#ifdef RUNTIME_DEBUG
    asm("pushl %0" : : "m" (runtime_debug));
#endif
    asm("pushl %0\n\t"
	"pushl %1\n\t"
	"pushl %2"
	: : "m" (bytepcoff), "m" (mb), "m" (ee));
    asm("call  " SYMBOL(searchCatchFrame) "@PLT");
#ifdef RUNTIME_DEBUG
    asm("addl  $16,%esp");
#else
    asm("addl  $12,%esp");
#endif
	/* eax is CatchFrame */

    asm("testl %eax,%eax\n\t"
	"jz    exc_through");

    /* clear the stack */
    asm("leal  -" STR(SAVED_REG_AREA) "(%ebp),%esp");

    {	/* place the exception object on TOS */
      register ExecEnv *cur_ee asm("edi");
      register JHandle *excobj asm("edx");
      cur_ee = ee;
      excobj = cur_ee->exception.exc;
      asm("pushl %edx");
		/* now state 0 */

      cur_ee->exception.exc = NULL;
    }

    {
      register struct CatchFrame_w_state *cf asm("eax");
      register unsigned char *tgt asm("edi");
      register int32_t handler_state asm("ecx");

      handler_state = cf->state;
#ifdef RUNTIME_DEBUG
      if (runtime_debug) {
	DEBUG_IN;
	printf("  exc handler state: %d\n", handler_state);
	fflush(stdout);
	DEBUG_OUT;
      }
#endif

      /* shift to the state which handler assumes */
      asm("cmpl  $0,%ecx\n\t"	/* if (hanlder_state == 0) */
	  "je   exc_handler_shift_done\n\t"
	"exc_handler_shift_1:\n\t"
	  "cmpl  $1,%ecx\n\t"	/* if (handler_state == 1) */
	  "jne   exc_handler_shift_2\n\t"
	  "popl  %edx\n\t"
	  "jmp   exc_handler_shift_done\n\t"
	"exc_handler_shift_2:\n\t"
	  "cmpl  $3,%ecx\n\t"	/* if (handler_state == 3) */
	  "jne   exc_handler_shift_3\n\t"
	  "popl  %ecx\n\t"
	  "jmp   exc_handler_shift_done\n\t"
	"exc_handler_shift_3:\n\t"
	  "cmpl  $2,%ecx\n\t"	/* if (handler_stat == 2) */
	  "jne   exc_handler_shift_4\n\t"
	  "popl  %ecx\n\t"
	  "xorl  %edx,%edx\n\t"
	  "jmp   exc_handler_shift_done\n\t"
	"exc_handler_shift_4:\n\t"
	  "cmpl  $4,%ecx\n\t"	/* if (handler_stat == 4) */
	  "jne   exc_handler_shift_done\n\t"
	  "popl  %edx\n\t"
	  "xorl  %ecx,%ecx\n\t"
	"exc_handler_shift_done:");

      COMPILEDCODE(%edi);	/* tgt(edi) = mb->CompiledCode */
      tgt/*edi*/ += (int)cf/*eax*/->compiled_CatchFrame;
      asm("jmp   *%edi");
    }
    asm("exc_through:");
  }

  /* nop */
  CODE(opc_nop, nop, STANY, STSTA, 0) {
  }

  /* iconst_0 */
  CODE(opc_iconst_0, [ifa]const_0, ST0, ST1, 0) { asm("xorl  %edx,%edx"); }
  CODE(opc_iconst_0, [ifa]const_0, ST1, ST2, 0) { asm("xorl  %ecx,%ecx"); }
  CODE(opc_iconst_0, [ifa]const_0, ST2, ST4, 0) {
    asm("pushl %edx\n\t"
	"xorl  %edx,%edx");
  }
  CODE(opc_iconst_0, [ifa]const_0, ST3, ST4, 0) { asm("xorl  %edx,%edx"); }
  CODE(opc_iconst_0, [ifa]const_0, ST4, ST2, 0) {
    asm("pushl %ecx\n\t"
	"xorl  %ecx,%ecx");
  }

  /* iconst_m1, iconst_[1-5] */
#define CODE_ICONST_N(S, N) \
  CODE(opc_iconst_##S, iconst_##S, ST0, ST1, 0) {\
    asm("movl  $" #N ",%edx"); }\
  CODE(opc_iconst_##S, iconst_##S, ST1, ST2, 0) {\
    asm("movl  $" #N ",%ecx"); }\
  CODE(opc_iconst_##S, iconst_##S, ST2, ST4, 0){\
    asm("pushl %edx\n\t"\
	"movl  $" #N ",%edx");\
  }\
  CODE(opc_iconst_##S, iconst_##S, ST3, ST4, 0) {\
    asm("movl  $" #N ",%edx"); }\
  CODE(opc_iconst_##S, iconst_##S, ST4, ST2, 0) {\
    asm("pushl %ecx\n\t"\
	"movl  $" #N ",%ecx");\
  }

  CODE_ICONST_N(m1, -1);
  CODE_ICONST_N(1, 1);
  CODE_ICONST_N(2, 2);
  CODE_ICONST_N(3, 3);
  CODE_ICONST_N(4, 4);
  CODE_ICONST_N(5, 5);

  /* lconst_0 */
  CODE(opc_lconst_0, [ld]const_0, ST0, ST2, 0) {
    asm("xorl  %edx,%edx\n\t"
	"xorl  %ecx,%ecx");
  }
  CODE(opc_lconst_0, [ld]const_0, ST1, ST2, 0) {
    asm("pushl %edx\n\t"
	"xorl  %ecx,%ecx\n\t"
	"xorl  %edx,%edx");
  }
  CODE(opc_lconst_0, [ld]const_0, ST2, ST2, 0) {
    asm("pushl %edx\n\t"
	"pushl %ecx\n\t"
	"xorl  %edx,%edx\n\t"
	"xorl  %ecx,%ecx");
  }
  CODE(opc_lconst_0, [ld]const_0, ST3, ST2, 0) {
    asm("pushl %ecx\n\t"
	"xorl  %edx,%edx\n\t"
	"xorl  %ecx,%ecx");
  }
  CODE(opc_lconst_0, [ld]const_0, ST4, ST2, 0) {
    asm("pushl %ecx\n\t"
	"pushl %edx\n\t"
	"xorl  %ecx,%ecx\n\t"
	"xorl  %edx,%edx");
  }

  /* lconst_1 */
#define LCONST_ST02 \
    asm("movl  $1,%ecx\n\t"\
	"xorl  %edx,%edx")
	/* now state 2 */

#define LCONST_ST04 \
    asm("movl  $1,%edx\n\t"\
	"xorl  %ecx,%ecx")
	/* now state 4 */

  CODE(opc_lconst_1, lconst_1, ST0, ST2, 0) {
    LCONST_ST02;
  }
  CODE(opc_lconst_1, lconst_1, ST1, ST2, 0) {
    asm("pushl %edx");	/* now state 0 */
    LCONST_ST02;
  }
  CODE(opc_lconst_1, lconst_1, ST2, ST4, 0) {
    asm("pushl %edx\n\t"
	"pushl %ecx");	/* now state 0 */
    LCONST_ST04;
  }
  CODE(opc_lconst_1, lconst_1, ST3, ST4, 0) {
    asm("pushl %ecx");	/* now state 0 */
    LCONST_ST04;
  }
  CODE(opc_lconst_1, lconst_1, ST4, ST2, 0) {
    asm("pushl %ecx\n\t"
	"pushl %edx");	/* now state 0 */
    LCONST_ST02;
  }

  /* fconst_1 */
  CODE(opc_fconst_1, fconst_1, ST0, ST1, 0) {
    asm("movl  $0x3f800000,%edx");
  }
  CODE(opc_fconst_1, fconst_1, ST1, ST2, 0) {
    asm("movl  $0x3f800000,%ecx");
  }
  CODE(opc_fconst_1, fconst_1, ST2, ST4, 0) {
    asm("pushl %edx\n\t"
	"movl  $0x3f800000,%edx");
  }
  CODE(opc_fconst_1, fconst_1, ST3, ST4, 0) {
    asm("movl  $0x3f800000,%edx");
  }
  CODE(opc_fconst_1, fconst_1, ST4, ST2, 0) {
    asm("pushl %ecx\n\t"
	"movl  $0x3f800000,%ecx");
  }

  /* fconst_2 */
  CODE(opc_fconst_2, fconst_2, ST0, ST1, 0) {
    asm("movl  $0x40000000,%edx");
  }
  CODE(opc_fconst_2, fconst_2, ST1, ST2, 0) {
    asm("movl  $0x40000000,%ecx");
  }
  CODE(opc_fconst_2, fconst_2, ST2, ST4, 0) {
    asm("pushl %edx\n\t"
	"movl  $0x40000000,%edx");
  }
  CODE(opc_fconst_2, fconst_2, ST3, ST4, 0) {
    asm("movl  $0x40000000,%edx");
  }
  CODE(opc_fconst_2, fconst_2, ST4, ST2, 0) {
    asm("pushl %ecx\n\t"
	"movl  $0x40000000,%ecx");
  }

  /* dconst_1 */
#define DCONST_ST02 \
    asm("movl  $0x3ff00000,%edx\n\t"	/* high word */\
	"xorl  %ecx,%ecx")		/* low word */

#define DCONST_ST04 \
    asm("movl  $0x3ff00000,%ecx\n\t"	/* high word */\
	"xorl  %edx,%edx")		/* low word */

  CODE(opc_dconst_1, dconst_1, ST0, ST2, 0) {
    DCONST_ST02;
  }
  CODE(opc_dconst_1, dconst_1, ST1, ST4, 0) {
    asm("pushl %edx");	/* now state 0 */
    DCONST_ST04;
  }
  CODE(opc_dconst_1, dconst_1, ST2, ST2, 0) {
    asm("pushl %edx\n\t"
	"pushl %ecx");	/* now state 0 */
    DCONST_ST02;
  }
  CODE(opc_dconst_1, dconst_1, ST3, ST2, 0) {
    asm("pushl %ecx");	/* now state 0 */
    DCONST_ST02;
  }
  CODE(opc_dconst_1, dconst_1, ST4, ST4, 0) {
    asm("pushl %ecx\n\t"
	"pushl %edx");	/* now state 0 */
    DCONST_ST04;
  }

  /* bipush */
#ifdef RUNTIME_DEBUG
#  define BIPUSH_DEBUG1(REG) \
  if (runtime_debug) {\
    DEBUG_IN;\
    asm("pushl " #REG "\n\t"\
	"flds  (%esp)\n\t"\
	"subl  $4,%esp\n\t"\
	"fstpl (%esp)\n\t"\
	"pushl " #REG "\n\t"\
	"pushl " #REG);\
    PUSH_CONSTSTR("  0x%08x %d %g\n");\
    asm("call  " SYMBOL(printf) "@PLT\n\t"\
	"addl  $20,%esp");\
    FFLUSH;\
    DEBUG_OUT;\
  }
#else
#  define BIPUSH_DEBUG1(REG)
#endif
	/* const: value */
  CODE(opc_bipush, a_const, ST0, ST1, 0) {
    asm("movl  $" STR(CONST) ",%edx");
    BIPUSH_DEBUG1(%edx);
  }
  CODE(opc_bipush, a_const, ST1, ST2, 0) {
    asm("movl  $" STR(CONST) ",%ecx");
    BIPUSH_DEBUG1(%ecx);
  }
  CODE(opc_bipush, a_const, ST2, ST4, 0) {
    asm("pushl %edx\n\t"
	"movl  $" STR(CONST) ",%edx");
    BIPUSH_DEBUG1(%edx);
  }
  CODE(opc_bipush, a_const, ST3, ST4, 0) {
    asm("movl  $" STR(CONST) ",%edx");
    BIPUSH_DEBUG1(%edx);
  }
  CODE(opc_bipush, a_const, ST4, ST2, 0) {
    asm("pushl %ecx\n\t"
	"movl  $" STR(CONST) ",%ecx");
    BIPUSH_DEBUG1(%ecx);
  }

  /* ldc2_w */
	/* const: val[32:63], val[0:31] */
#ifdef RUNTIME_DEBUG
#  define LDC2_W_DEBUG1(OPTOP1_REG, OPTOP2_REG) \
  if (runtime_debug) {\
    DEBUG_IN;\
    asm("pushl " #OPTOP2_REG "\n\tpushl " #OPTOP1_REG "\n\t"\
	"fldl  (%esp)\n\tfstpl (%esp)\n\t"\
	"pushl " #OPTOP2_REG "\n\tpushl " #OPTOP1_REG "\n\t"\
	"pushl " #OPTOP2_REG "\n\tpushl " #OPTOP1_REG);\
    PUSH_CONSTSTR("  0x%016llx %lld %g\n");\
    asm("call  " SYMBOL(printf) "@PLT\n\t"\
	"addl  $28,%esp");\
    FFLUSH;\
    DEBUG_OUT;\
  }
#else
#  define LDC2_W_DEBUG1(OPTOP1_REG, OPTOP2_REG)
#endif

  CODE(opc_ldc2_w, ldc2_w, ST0, ST2, 0) {
    asm("movl  $" STR(CONST) ",%edx\n\t"
	"movl  $" STR(CONST) ",%ecx");
    LDC2_W_DEBUG1(%ecx, %edx);
  }
  CODE(opc_ldc2_w, ldc2_w, ST1, ST4, 0) {
    asm("pushl %edx\n\t"
	"movl  $" STR(CONST) ",%ecx\n\t"
	"movl  $" STR(CONST) ",%edx");
    LDC2_W_DEBUG1(%edx, %ecx);
  }
  CODE(opc_ldc2_w, ldc2_w, ST2, ST2, 0) {
    asm("pushl %edx\n\t"
	"pushl %ecx\n\t"
	"movl  $" STR(CONST) ",%edx\n\t"
	"movl  $" STR(CONST) ",%ecx");
    LDC2_W_DEBUG1(%ecx, %edx);
  }
  CODE(opc_ldc2_w, ldc2_w, ST3, ST2, 0) {
    asm("pushl %ecx\n\t"
	"movl  $" STR(CONST) ",%edx\n\t"
	"movl  $" STR(CONST) ",%ecx");
    LDC2_W_DEBUG1(%ecx, %edx);
  }
  CODE(opc_ldc2_w, ldc2_w, ST4, ST4, 0) {
    asm("pushl %ecx\n\t"
	"pushl %edx\n\t"
	"movl  $" STR(CONST) ",%ecx\n\t"
	"movl  $" STR(CONST) ",%edx");
    LDC2_W_DEBUG1(%edx, %ecx);
  }

  /* iload */
	/* const: index * 4 */
#ifdef RUNTIME_DEBUG
#  define ILOAD_DEBUG1(VAL) \
  if (runtime_debug) {\
    DEBUG_IN;\
    asm("pushl " #VAL "\n\t"\
	"flds  (%esp)\n\t"\
	"subl  $4,%esp\n\t"\
	"fstpl (%esp)\n\t"\
	"pushl " #VAL "\n\t"\
	"pushl " #VAL "\n\t"\
	"pushl $" STR(CONST));\
    PUSH_CONSTSTR("  [%d] 0x%08x %d %g\n");\
    asm("call  " SYMBOL(printf) "@PLT\n\t"\
	"addl  $24,%esp");\
    FFLUSH;\
    DEBUG_OUT;\
  }
#else
#  define ILOAD_DEBUG1(VAL)
#endif
  CODE(opc_iload, [ifa]load, ST0, ST1, 0) {
    asm("movl " STR(CONST) "(%esi),%edx");
    ILOAD_DEBUG1(%edx);
  }
  CODE(opc_iload, [ifa]load, ST1, ST2, 0) {
    asm("movl " STR(CONST) "(%esi),%ecx");
    ILOAD_DEBUG1(%ecx);
  }
  CODE(opc_iload, [ifa]load, ST2, ST4, 0) {
    asm("pushl %edx\n\t"
	"movl  " STR(CONST) "(%esi),%edx");
    ILOAD_DEBUG1(%edx);
  }
  CODE(opc_iload, [ifa]load, ST3, ST4, 0) {
    asm("movl " STR(CONST) "(%esi),%edx");
    ILOAD_DEBUG1(%edx);
  }
  CODE(opc_iload, [ifa]load, ST4, ST2, 0) {
    asm("pushl %ecx\n\t"
	"movl  " STR(CONST) "(%esi),%ecx");
    ILOAD_DEBUG1(%ecx);
  }

  /* lload */
	/* const: index * 4, (index + 1) * 4 */
#ifdef RUNTIME_DEBUG
#  define LLOAD_DEBUG1(OPTOP1_REG, OPTOP2_REG) \
  if (runtime_debug) {\
    DEBUG_IN;\
    asm("pushl " #OPTOP2_REG "\n\tpushl " #OPTOP1_REG "\n\t"\
	"pushl " #OPTOP2_REG "\n\tpushl " #OPTOP1_REG "\n\t"\
	"pushl " #OPTOP2_REG "\n\tpushl " #OPTOP1_REG "\n\t"\
	"movl  $" STR(CONST) ",%eax\n\t"\
	"sarl  $2,%eax\n\t"\
	"negl  %eax\n\t"\
	"subl  $1,%eax\n\t"\
	"pushl %eax");\
    PUSH_CONSTSTR("  var[%d]: 0x%016llx, %lld, %g\n");\
    asm("call  " SYMBOL(printf) "@PLT\n\t"\
	"addl  $32,%esp");\
    FFLUSH;\
    DEBUG_OUT;\
  }
#else
#  define LLOAD_DEBUG1(OPTOP1_REG, OPTOP2_REG)
#endif

#define LLOAD_ST02 \
    asm("movl  " STR(CONST) "(%esi),%ecx\n\t"\
	"movl  " STR(CONST) "(%esi),%edx");\
    LLOAD_DEBUG1(%ecx, %edx)
#define LLOAD_ST04 \
    asm("movl  " STR(CONST) "(%esi),%edx\n\t"\
	"movl  " STR(CONST) "(%esi),%ecx");\
    LLOAD_DEBUG1(%edx, %ecx)

  CODE(opc_lload, [ld]load, ST0, ST2, 0) {
    LLOAD_ST02;
  }
  CODE(opc_lload, [ld]load, ST1, ST2, 0) {
    asm("pushl %edx");	/* now state 0 */
    LLOAD_ST02;
  }
  CODE(opc_lload, [ld]load, ST2, ST4, 0) {
    asm("pushl %edx\n\t"
	"pushl %ecx");	/* now state 0 */
    LLOAD_ST04;
  }
  CODE(opc_lload, [ld]load, ST3, ST4, 0) {
    asm("pushl %ecx");	/* now state 0 */
    LLOAD_ST04;
  }
  CODE(opc_lload, [ld]load, ST4, ST2, 0) {
    asm("pushl %ecx\n\t"
	"pushl %edx");	/* now state 0 */
    LLOAD_ST02;
  }

  /* iload_[0-3] */
#define CODE_ILOAD_N(N, OFF) \
  CODE(opc_iload_##N, [ifa]load_##N, ST0, ST1, 0) {\
    asm("movl  " #OFF "(%esi),%edx");\
    BIPUSH_DEBUG1(%edx);\
  }\
  CODE(opc_iload_##N, [ifa]load_##N, ST1, ST2, 0) {\
    asm("movl  " #OFF "(%esi),%ecx");\
    BIPUSH_DEBUG1(%ecx);\
  }\
  CODE(opc_iload_##N, [ifa]load_##N, ST2, ST4, 0) {\
    asm("pushl %edx\n\t"\
	"movl  " #OFF "(%esi),%edx");\
    BIPUSH_DEBUG1(%edx);\
  }\
  CODE(opc_iload_##N, [ifa]load_##N, ST3, ST4, 0) {\
    asm("movl  " #OFF "(%esi),%edx");\
    BIPUSH_DEBUG1(%edx);\
  }\
  CODE(opc_iload_##N, [ifa]load_##N, ST4, ST2, 0) {\
    asm("pushl %ecx\n\t"\
	"movl  " #OFF "(%esi),%ecx");\
    BIPUSH_DEBUG1(%ecx);\
  }

  CODE_ILOAD_N(0, );
  CODE_ILOAD_N(1, -4);
  CODE_ILOAD_N(2, -8);
  CODE_ILOAD_N(3, -12);

  /* lload_[0-3] */
#define LLOAD_N_ST02(OFF1, OFF2) \
    asm("movl  " #OFF1 "(%esi),%ecx\n\t"\
	"movl  " #OFF2 "(%esi),%edx");\
    LDC2_W_DEBUG1(%ecx, %edx)
#define LLOAD_N_ST04(OFF1, OFF2) \
    asm("movl  " #OFF1 "(%esi),%edx\n\t"\
	"movl  " #OFF2 "(%esi),%ecx");\
    LDC2_W_DEBUG1(%edx, %ecx)

#define CODE_LLOAD_N(N, OFF1, OFF2) \
  CODE(opc_lload_##N, [ld]load_##N, ST0, ST2, 0) {\
    LLOAD_N_ST02(OFF1, OFF2);\
  }\
  CODE(opc_lload_##N, [ld]load_##N, ST1, ST2, 0) {\
    asm("pushl %edx");	/* now state 0 */\
    LLOAD_N_ST02(OFF1, OFF2);\
  }\
  CODE(opc_lload_##N, [ld]load_##N, ST2, ST4, 0) {\
    asm("pushl %edx\n\t"\
	"pushl %ecx");	/* now state 0 */\
    LLOAD_N_ST04(OFF1, OFF2);\
  }\
  CODE(opc_lload_##N, [ld]load_##N, ST3, ST4, 0) {\
    asm("pushl %ecx");	/* now state 0 */\
    LLOAD_N_ST04(OFF1, OFF2);\
  }\
  CODE(opc_lload_##N, [ld]load_##N, ST4, ST2, 0) {\
    asm("pushl %ecx\n\t"\
	"pushl %edx");	/* now state 0 */\
    LLOAD_N_ST02(OFF1, OFF2);\
  }

  CODE_LLOAD_N(0, -4, );
  CODE_LLOAD_N(1, -8, -4);
  CODE_LLOAD_N(2, -12, -8);
  CODE_LLOAD_N(3, -16, -12);

  /*
   * array access
   */

  /* array_check */
#if 0
  CODE(opc_array_check, array_check, ST[24], ST[24], 1) {
    if (!h) { SIGNAL_ERROR0(NullPointerException); }

    if ((index < 0) || (index >= obj_length(h))) {
      SIGNAL_ERROR0(ArrayIndexOutOfBoundsException);
    }
  }
#endif

#ifdef RUNTIME_DEBUG
#  define ARRAY_CHECK_DEBUG1(INDEX) \
  if (runtime_debug) {\
    DEBUG_IN;\
    asm("pushl " #INDEX);\
    PUSH_CONSTSTR("  index:  %d\n");\
    asm("call  " SYMBOL(printf) "@PLT\n\t"\
	"addl  $8,%esp");\
    FFLUSH;\
    DEBUG_OUT;\
  }
#  define ARRAY_CHECK_DEBUG2(LEN) \
  if (runtime_debug) {\
    DEBUG_IN;\
    asm("pushl " #LEN);\
    PUSH_CONSTSTR("  length: %d\n");\
    asm("call  " SYMBOL(printf) "@PLT\n\t"\
	"addl  $8,%esp");\
    FFLUSH;\
    DEBUG_OUT;\
  }
#else
#  define ARRAY_CHECK_DEBUG1(INDEX)
#  define ARRAY_CHECK_DEBUG2(INDEX)
#endif

#if defined(METAVM) && !defined(METAVM_NO_ARRAY)
#  define METAVM_ARRAY_CHECK(HANDLE, LABEL) \
    asm("pushl %edi");		/* save HANDLE for opc_lastore */\
    JUMP_IF_NOT_PROXY(HANDLE, LABEL "_arychk_local");\
    asm("movl  (%esp),%edi");	/* restore */\
    JUMP_IF_NOT_REMOTE(LABEL "_arychk_local");\
    asm("popl  %edi\n\t"	/* restore */\
	"jmp  " LABEL "_arychk_done\n\t"\
      LABEL "_arychk_local:\n\t"\
	"popl  %edi");		/* restore */
#else
#  define METAVM_ARRAY_CHECK(HANDLE, LABEL)
#endif	/* METAVM_NO_ARRAY */

#ifndef NO_CHECK
#  define ARRAY_CHECK(HANDLE, INDEX, LABEL, STATE) \
    NULL_TEST(HANDLE, LABEL "_1", STATE);\
    \
    ARRAY_CHECK_DEBUG1(INDEX);\
    asm("testl " #INDEX "," #INDEX "\n\t"\
	"jl    " LABEL "_exc");\
    \
    METAVM_ARRAY_CHECK(HANDLE, LABEL);\
    OBJ_LENGTH(HANDLE, %edi);			/* edi = obj_length(handle) */\
    ARRAY_CHECK_DEBUG2(%edi);\
    asm("cmpl  %edi," #INDEX "\n\t"\
	"jl    " LABEL "_arychk_done");\
    asm(LABEL "_exc:");		/* label */\
    SIGNAL_ERROR0(ArrayIndexOutOfBoundsException, STATE);\
    asm(LABEL "_arychk_done:")		/* label */
#else
#  define ARRAY_CHECK(HANDLE, INDEX, LABEL, STATE) \
    METAVM_ARRAY_CHECK(HANDLE, LABEL);\
    OBJ_LENGTH(HANDLE, %edi);			/* edi = obj_length(handle) */\
    asm(LABEL "_arychk_done:")
#endif	/* NO_CHECK */
	/* destroy %edi */
	/* edi = obj_length(handle) */

  CODE(opc_array_check, array_check, ST2, ST2, 1) {
    ARRAY_CHECK(%edx, %ecx, "arychk_st2", 2);
  }
  CODE(opc_array_check, array_check, ST4, ST4, 1) {
    ARRAY_CHECK(%ecx, %edx, "arychk_st4", 4);
  }

  /* iaload */
	/* compile: fill_cache, array_check, iaload */
#ifdef METAVM
#  define METAVM_READ(HANDLE, SLOT, TGT, LABEL, STATE, FUNC32, FUNCOBJ) \
    JUMP_IF_NOT_PROXY(HANDLE, LABEL "_local");\
    JUMP_IF_NOT_REMOTE(LABEL "_local");\
    \
    FUNCCALL_IN(STATE);\
    \
    asm("pushl " #SLOT "\n\t"	/* slot */\
	"pushl " #HANDLE);	/* obj (Proxy) */\
    asm("pushl %0" : : "m" (ee));	/* ee */\
    \
    asm("movl  $" STR(CONST) ",%edi");\
    asm("testl %edi,%edi\n\t"\
	"jnz   " LABEL "_obj\n\t"\
	"call  " SYMBOL(FUNC32) "@PLT\n\t"\
	"jmp   " LABEL "_remoteget_done\n\t"\
      LABEL "_obj:\n\t"\
	"call  " SYMBOL(FUNCOBJ) "@PLT\n\t"\
      LABEL "_remoteget_done:");\
    asm("popl  %edi\n\t"	/* edi = ee */\
	"addl  $8,%esp");\
    \
    FUNCCALL_OUT(STATE);\
    \
    asm("movl  %eax," #TGT);\
    \
    JUMP_IF_EXC_HASNT_OCCURRED(%edi /* is ee */, LABEL "_done");\
DEBUG_IN;\
PUSH_CONSTSTR("METAVM_READ exc. occurred.\n");\
asm("call  " SYMBOL(printf) "@PLT\n\t"\
    "addl  $4,%esp");\
FFLUSH;\
DEBUG_OUT;\
    SIGNAL_ERROR_JUMP(STATE);\
    \
    asm(LABEL "_local:")
#  define METAVM_GETFIELD(HANDLE, SLOT, TGT, LABEL, STATE) \
   METAVM_READ(HANDLE, SLOT, TGT, LABEL, STATE, proxy_get32field, proxy_getobjfield)
#else
#  define METAVM_GETFIELD(HANDLE, SLOT, TGT, LABEL, STATE)
#endif	/* METAVM */

#if defined(METAVM) && !defined(METAVM_NO_ARRAY)
#  define METAVM_ALOAD(HANDLE, SLOT, TGT, LABEL, STATE) \
   METAVM_READ(HANDLE, SLOT, TGT, LABEL, STATE, proxy_aload32, proxy_aloadobj)
#else
#  define METAVM_ALOAD(HANDLE, SLOT, TGT, LABEL, STATE)
#endif	/* METAVM_NO_ARRAY */

  CODE(opc_iaload, [ifa]aload, ST2, ST1, 0) {
    METAVM_ALOAD(%edx, %ecx, %edx, "iaload_st2", 0);
    UNHAND(%edx, %eax);
    asm("movl  (%eax,%ecx,4),%edx");
    asm("iaload_st2_done:");
    BIPUSH_DEBUG1(%edx);
  }
  CODE(opc_iaload, [ifa]aload, ST4, ST3, 0) {
    METAVM_ALOAD(%ecx, %edx, %ecx, "iaload_st4", 0);
    UNHAND(%ecx, %eax);
    asm("movl  (%eax,%edx,4),%ecx");
    asm("iaload_st4_done:");
    BIPUSH_DEBUG1(%ecx);
  }

  /* laload */
	/* compile: fill_cache, array_check, laload */
#ifdef METAVM
#  define METAVM_READ2(HANDLE, SLOT, TGT_LOW, TGT_HIGH, LABEL, STATE, FUNC) \
    JUMP_IF_NOT_PROXY(HANDLE, LABEL "_local");\
    JUMP_IF_NOT_REMOTE(LABEL "_local");\
    \
    asm("pushl " #SLOT "\n\t"	/* slot */\
	"pushl " #HANDLE);	/* obj (Proxy) */\
    asm("pushl %0" : : "m" (ee));	/* ee */\
    \
    asm("call  " SYMBOL(FUNC) "@PLT\n\t"\
	"movl  %edx," #TGT_HIGH "\n\t"\
	"popl  %edi\n\t"	/* edi = ee */\
	"movl  %eax," #TGT_LOW "\n\t"\
	"addl  $8,%esp");\
    \
    JUMP_IF_EXC_HASNT_OCCURRED(%edi /* is ee */, LABEL "_done");\
DEBUG_IN;\
PUSH_CONSTSTR("METAVM_READ2 exc. occurred.\n");\
asm("call  " SYMBOL(printf) "@PLT\n\t"\
    "addl  $4,%esp");\
FFLUSH;\
DEBUG_OUT;\
    SIGNAL_ERROR_JUMP(STATE);\
    \
    asm(LABEL "_local:")
#  define METAVM_GETFIELD2(HANDLE, SLOT, TGT_LOW, TGT_HIGH, LABEL, STATE) \
   METAVM_READ2(HANDLE, SLOT, TGT_LOW, TGT_HIGH, LABEL, STATE, proxy_get64field)
#else
#  define METAVM_GETFIELD2(HANDLE, SLOT, TGT_LOW, TGT_HIGH, LABEL, STATE)
#endif	/* METAVM */

#if defined(METAVM) && !defined(METAVM_NO_ARRAY)
#  define METAVM_ALOAD2(HANDLE, SLOT, TGT_LOW, TGT_HIGH, LABEL, STATE) \
   METAVM_READ2(HANDLE, SLOT, TGT_LOW, TGT_HIGH, LABEL, STATE, proxy_aload64)
#else
#  define METAVM_ALOAD2(HANDLE, SLOT, TGT_LOW, TGT_HIGH, LABEL, STATE)
#endif	/* METAVM_NO_ARRAY */

  CODE(opc_laload, [ld]aload, ST2, ST4, 0) {
    METAVM_ALOAD2(%edx, %ecx, %edx, %ecx, "laload_st2", 2);
    UNHAND(%edx, %eax);
    asm("leal  (%eax,%ecx,8),%edi\n\t"
	"movl  (%edi),%edx\n\t"
	"movl  4(%edi),%ecx");
    asm("laload_st2_done:");
    LDC2_W_DEBUG1(%edx, %ecx);
  }
  CODE(opc_laload, [ld]aload, ST4, ST2, 0) {
    METAVM_ALOAD2(%ecx, %edx, %ecx, %edx, "laload_st4", 4);
    UNHAND(%ecx, %eax);
    asm("leal  (%eax,%edx,8),%edi\n\t"
	"movl  (%edi),%ecx\n\t"
	"movl  4(%edi),%edx");
    asm("laload_st4_done:");
    LDC2_W_DEBUG1(%ecx, %edx);
  }

  /* baload */
	/* compile: fill_cache, array_check, baload */
  CODE(opc_baload, baload, ST2, ST1, 0) {
    METAVM_ALOAD(%edx, %ecx, %edx, "baload_st2", 0);
    UNHAND(%edx, %eax);
    asm("movsbl (%eax,%ecx),%edx");
    asm("baload_st2_done:");
    BIPUSH_DEBUG1(%edx);
  }
  CODE(opc_baload, baload, ST4, ST3, 0) {
    METAVM_ALOAD(%ecx, %edx, %ecx, "baload_st4", 0);
    UNHAND(%ecx, %eax);
    asm("movsbl (%eax,%edx),%ecx");
    asm("baload_st4_done:");
    BIPUSH_DEBUG1(%ecx);
  }

  /* caload */
	/* compile: fill_cache, array_check, caload */
  CODE(opc_caload, caload, ST2, ST1, 0) {
    METAVM_ALOAD(%edx, %ecx, %edx, "caload_st2", 0);
    UNHAND(%edx, %eax);
    asm("movzwl (%eax,%ecx,2),%edx");
    asm("caload_st2_done:");
    BIPUSH_DEBUG1(%edx);
  }
  CODE(opc_caload, caload, ST4, ST3, 0) {
    METAVM_ALOAD(%ecx, %edx, %ecx, "caload_st4", 0);
    UNHAND(%ecx, %eax);
    asm("movzwl (%eax,%edx,2),%ecx");
    asm("caload_st4_done:");
    BIPUSH_DEBUG1(%ecx);
  }

  /* saload */
	/* compile: fill_cache, array_check, saload */
  CODE(opc_saload, saload, ST2, ST1, 0) {
    METAVM_ALOAD(%edx, %ecx, %edx, "saload_st2", 0);
    UNHAND(%edx, %eax);
    asm("movswl (%eax,%ecx,2),%edx");
    asm("saload_st2_done:");
    BIPUSH_DEBUG1(%edx);
  }
  CODE(opc_saload, saload, ST4, ST3, 0) {
    METAVM_ALOAD(%ecx, %edx, %ecx, "saload_st4", 0);
    UNHAND(%ecx, %eax);
    asm("movswl (%eax,%edx,2),%ecx");
    asm("saload_st4_done:");
    BIPUSH_DEBUG1(%ecx);
  }

  /* istore */
	/* const: index * 4 */
  CODE(opc_istore, [ifa]store, ST0, ST0, 0) {
    asm("popl  %edx\n\t"
	"movl  %edx," STR(CONST) "(%esi)");
    ILOAD_DEBUG1(%edx);
  }
  CODE(opc_istore, [ifa]store, ST1, ST0, 0) {
    asm("movl  %edx," STR(CONST) "(%esi)");
    ILOAD_DEBUG1(%edx);
  }
  CODE(opc_istore, [ifa]store, ST2, ST1, 0) {
    asm("movl  %ecx," STR(CONST) "(%esi)");
    ILOAD_DEBUG1(%ecx);
  }
  CODE(opc_istore, [ifa]store, ST3, ST0, 0) {
    asm("movl  %ecx," STR(CONST) "(%esi)");
    ILOAD_DEBUG1(%ecx);
  }
  CODE(opc_istore, [ifa]store, ST4, ST3, 0) {
    asm("movl  %edx," STR(CONST) "(%esi)");
    ILOAD_DEBUG1(%edx);
  }

  /* lstore */
	/* const: index * 4, (index + 1) * 4 */
	/* compile: fill_cache, lstore */
  CODE(opc_lstore, [ld]store, ST2, ST0, 0) {
    asm("movl  %ecx," STR(CONST) "(%esi)\n\t"
	"movl  %edx," STR(CONST) "(%esi)");
    LLOAD_DEBUG1(%ecx, %edx);
  }
  CODE(opc_lstore, [ld]store, ST4, ST0, 0) {
    asm("movl  %edx," STR(CONST) "(%esi)\n\t"
	"movl  %ecx," STR(CONST) "(%esi)");
    LLOAD_DEBUG1(%edx, %ecx);
  }

  /* istore_[0-3] */
#define CODE_ISTORE_N(N, OFF) \
  CODE(opc_istore_##N, [ifa]store_##N, ST0, ST0, 0) {\
    asm("popl  %edx\n\t"		/* now state 1 */\
	"movl  %edx," #OFF "(%esi)");\
    BIPUSH_DEBUG1(%edx);\
  }\
  CODE(opc_istore_##N, [ifa]store_##N, ST1, ST0, 0) {\
    asm("movl  %edx," #OFF "(%esi)");\
    BIPUSH_DEBUG1(%edx);\
  }\
  CODE(opc_istore_##N, [ifa]store_##N, ST2, ST1, 0) {\
    asm("movl  %ecx," #OFF "(%esi)");\
    BIPUSH_DEBUG1(%ecx);\
  }\
  CODE(opc_istore_##N, [ifa]store_##N, ST3, ST0, 0) {\
    asm("movl  %ecx," #OFF "(%esi)");\
    BIPUSH_DEBUG1(%ecx);\
  }\
  CODE(opc_istore_##N, [ifa]store_##N, ST4, ST3, 0) {\
    asm("movl  %edx," #OFF "(%esi)");\
    BIPUSH_DEBUG1(%edx);\
  }

  CODE_ISTORE_N(0, );
  CODE_ISTORE_N(1, -4);
  CODE_ISTORE_N(2, -8);
  CODE_ISTORE_N(3, -12);

  /* lstore_[0-3] */
#define LSTORE_N_ST2(OFF1, OFF2) \
    asm("movl  %ecx," #OFF1 "(%esi)\n\t"\
	"movl  %edx," #OFF2 "(%esi)");\
    LDC2_W_DEBUG1(%ecx, %edx)
#define LSTORE_N_ST4(OFF1, OFF2) \
    asm("movl  %edx," #OFF1 "(%esi)\n\t"\
	"movl  %ecx," #OFF2 "(%esi)");\
    LDC2_W_DEBUG1(%edx, %ecx)

#define CODE_LSTORE_N(N, OFF1, OFF2) \
  CODE(opc_lstore_##N, [ld]store_##N, ST0, ST0, 0) {\
    asm("popl  %ecx\n\t"\
	"popl  %edx");		/* now state 2 */\
    LSTORE_N_ST2(OFF1, OFF2);\
  }\
  CODE(opc_lstore_##N, [ld]store_##N, ST1, ST0, 0) {\
    asm("popl  %ecx");		/* now state 4 */\
    LSTORE_N_ST4(OFF1, OFF2);\
  }\
  CODE(opc_lstore_##N, [ld]store_##N, ST2, ST0, 0) {\
    LSTORE_N_ST2(OFF1, OFF2);\
  }\
  CODE(opc_lstore_##N, [ld]store_##N, ST3, ST0, 0) {\
    asm("popl  %edx");		/* now state 2 */\
    LSTORE_N_ST2(OFF1, OFF2);\
  }\
  CODE(opc_lstore_##N, [ld]store_##N, ST4, ST0, 0) {\
    LSTORE_N_ST4(OFF1, OFF2);\
  }

  CODE_LSTORE_N(0, -4, );
  CODE_LSTORE_N(1, -8, -4);
  CODE_LSTORE_N(2, -12, -8);
  CODE_LSTORE_N(3, -16, -12);

  /* iastore */
	/* compile: iastore1, fill_cache, array_check, iastore */
  CODE(opc_iastore1, [ifa]astore1, ST0, ST0, 0) {
    asm("popl  %eax");
    BIPUSH_DEBUG1(%eax);
  }
  CODE(opc_iastore1, [ifa]astore1, ST1, ST0, 0) {
    asm("movl  %edx,%eax");
    BIPUSH_DEBUG1(%eax);
  }
  CODE(opc_iastore1, [ifa]astore1, ST2, ST1, 0) {
    asm("movl  %ecx,%eax");
    BIPUSH_DEBUG1(%eax);
  }
  CODE(opc_iastore1, [ifa]astore1, ST3, ST0, 0) {
    asm("movl  %ecx,%eax");
    BIPUSH_DEBUG1(%eax);
  }
  CODE(opc_iastore1, [ifa]astore1, ST4, ST3, 0) {
    asm("movl  %edx,%eax");
    BIPUSH_DEBUG1(%eax);
  }
	/* eax: value */

#ifdef METAVM
#  define METAVM_WRITE(HANDLE, SLOT, VAL, LABEL, STATE, FUNC32, FUNCOBJ) \
    JUMP_IF_NOT_PROXY(HANDLE, LABEL "_local");\
    JUMP_IF_NOT_REMOTE(LABEL "_local");\
    \
    asm("pushl " #VAL "\n\t"/* value */\
	"pushl " #SLOT "\n\t"	/* slot */\
	"pushl " #HANDLE);	/* obj (Proxy) */\
    asm("pushl %0" : : "m" (ee));	/* ee */\
    \
    asm("movl  $" STR(CONST) ",%edi");\
    asm("testl %edi,%edi\n\t"\
	"jnz   " LABEL "_obj\n\t"\
	"call  " SYMBOL(FUNC32) "@PLT\n\t"\
	"jmp   " LABEL "_return\n\t"\
      LABEL "_obj:\n\t"\
	"call  " SYMBOL(FUNCOBJ) "@PLT");\
    asm(LABEL "_return:\n\t"\
	"popl  %edi\n\t"	/* edi = ee */\
	"addl  $12,%esp");\
    \
    JUMP_IF_EXC_HASNT_OCCURRED(%edi /* is ee */, LABEL "_done");\
DEBUG_IN;\
PUSH_CONSTSTR("METAVM_WRITE exc. occurred.\n");\
asm("call  " SYMBOL(printf) "@PLT\n\t"\
    "addl  $4,%esp");\
FFLUSH;\
DEBUG_OUT;\
    SIGNAL_ERROR_JUMP(STATE);\
    \
    asm(LABEL "_local:")
#  define METAVM_PUTFIELD(HANDLE, SLOT, VAL, LABEL, STATE) \
   METAVM_WRITE(HANDLE, SLOT, VAL, LABEL, STATE, proxy_put32field, proxy_putobjfield)
#else
#  define METAVM_PUTFIELD(HANDLE, SLOT, VAL, LABEL, STATE)
#endif	/* METAVM */

#if defined(METAVM) && !defined(METAVM_NO_ARRAY)
#  define METAVM_ASTORE(HANDLE, SLOT, VAL, LABEL, STATE) \
   METAVM_WRITE(HANDLE, SLOT, VAL, LABEL, STATE, proxy_astore32,proxy_astoreobj)
#else
#  define METAVM_ASTORE(HANDLE, SLOT, VAL, LABEL, STATE)
#endif	/* METAVM_NO_ARRAY */

  CODE(opc_iastore, [ifa]astore, ST2, ST0, 0) {
    METAVM_ASTORE(%edx, %ecx, %eax, "iastore_st2", 2);
    UNHAND(%edx, %edi);
    asm("movl  %eax,(%edi,%ecx,4)");	/* array->body[ecx] = eax */
    asm("iastore_st2_done:");
  }
  CODE(opc_iastore, [ifa]astore, ST4, ST0, 0) {
    METAVM_ASTORE(%ecx, %edx, %eax, "iastore_st4", 4);
    UNHAND(%ecx, %edi);
    asm("movl  %eax,(%edi,%edx,4)");	/* array->body[edx] = eax */
    asm("iastore_st4_done:");
  }

  /* aastore */
	/* compile: iastore1, fill_cache, array_check, aastore */
  /*
   * assumption: eax is obj_handle(handle).
   */
#ifdef RUNTIME_DEBUG
#  define AASTORE_TEST_DEBUG \
  if (runtime_debug) {\
    DEBUG_IN;\
    asm("pushl %edi\n\tpushl %ecx\n\tpushl %edx");\
    PUSH_CONSTSTR("  edx: 0x%08x, ecx: 0x%08x, edi: 0x%08x\n");\
    asm("call  " SYMBOL(printf) "@PLT\n\t"\
	"addl  $16,%esp");\
    FFLUSH;\
    DEBUG_OUT;\
  }
#else
#  define AASTORE_TEST_DEBUG
#endif

#if defined(METAVM) && !defined(METAVM_NO_ARRAY)
#  define METAVM_AASTORE(HANDLE) \
    OBJ_LENGTH(HANDLE, %edi)	/* edi = obj_length(obj) */
	/* JUMP_IF_NOT_* in METAVM_ASTORE break edi serving obj_length() */
#else
#  define METAVM_AASTORE(HANDLE)
#endif	/* METAVM_NO_ARRAY */

#ifndef NO_CHECK
#  define AASTORE_TEST(OBJ, HANDLE, STATE) \
    asm("pushl %eax");\
    FUNCCALL_IN(2);\
    asm("pushl %0" : : "m" (ee));	/* push ee */\
    AASTORE_TEST_DEBUG;\
    asm("pushl (" #OBJ ",%edi,4)\n\t"\
				/* push array->body[obj_length(..)] */\
	"pushl %eax\n\t"		/* push value */\
	/* call is_instance_of(value, array->body[eax], ee) */\
	"call  " SYMBOL(is_instance_of) "@PLT\n\t"\
	"addl  $12,%esp");\
	/* if (eax)  goto ... */\
    asm("testl %eax,%eax");\
    FUNCCALL_OUT(2);\
    asm("popl  %eax");\
    \
    asm("jnz   aastore_st" #STATE "_1");\
    SIGNAL_ERROR0(ArrayStoreException, STATE);\
    asm("aastore_st" #STATE "_1:")
#else
#  define AASTORE_TEST(OBJ, HANDLE, STATE)
#endif	/* NO_CHECK */

  CODE(opc_aastore, aastore, ST2, ST0, 0) {
    METAVM_ASTORE(%edx, %ecx, %eax, "aastore_st2", 2);
    METAVM_AASTORE(%edx);	/* edi = obj_length(%edx) */
    UNHAND(%edx, %edx);
    AASTORE_TEST(%edx, %edx, 2);
    asm("movl  %eax,(%edx,%ecx,4)");/* array->body[ecx] = eax */
    asm("aastore_st2_done:");
  }
  CODE(opc_aastore, aastore, ST4, ST0, 0) {
    METAVM_ASTORE(%ecx, %edx, %eax, "aastore_st4", 4);
    METAVM_AASTORE(%ecx);	/* edi = obj_length(%edx) */
    UNHAND(%ecx, %ecx);
    AASTORE_TEST(%ecx, %ecx, 4);
    asm("movl  %eax,(%ecx,%edx,4)");/* array->body[ecx] = eax */
    asm("aastore_st4_done:");
  }

  /* lastore */
	/* compile: fill_cache, lastore */
#ifdef METAVM
#  define METAVM_WRITE2(HANDLE, SLOT, VAL_LOW, VAL_HIGH, LABEL, STATE, FUNC) \
    asm("pushl %eax\n\tpushl %edi");	/* save */\
    asm("movl  " #HANDLE ",%eax");	/* eax = handle */\
    JUMP_IF_NOT_PROXY(%eax, LABEL "_local");	/* 1st arg must not be %edi */\
    JUMP_IF_NOT_REMOTE(LABEL "_local");\
    asm("popl  %edi\n\tpopl  %eax");	/* restore */\
    \
    asm("pushl " #VAL_HIGH "\n\t"/* value */\
	"pushl " #VAL_LOW "\n\t"/* value */\
	"pushl " #SLOT "\n\t"	/* slot */\
	"pushl " #HANDLE);	/* obj (Proxy) */\
    asm("pushl %0" : : "m" (ee));	/* ee */\
    \
    asm("call  " SYMBOL(FUNC) "@PLT\n\t"\
	"popl  %edi\n\t"	/* edi = ee */\
	"addl  $16,%esp");\
    \
    JUMP_IF_EXC_HASNT_OCCURRED(%edi /* is ee */, LABEL "_done");\
DEBUG_IN;\
PUSH_CONSTSTR("METAVM_WRITE2 exc. occurred.\n");\
asm("call  " SYMBOL(printf) "@PLT\n\t"\
    "addl  $4,%esp");\
FFLUSH;\
DEBUG_OUT;\
    SIGNAL_ERROR_JUMP(STATE);\
    \
    asm(LABEL "_local:\n\t"\
	"popl  %edi\n\tpopl  %eax")		/* restore */
#  define METAVM_PUTFIELD2(HANDLE, SLOT, VAL_LOW, VAL_HIGH, LABEL, STATE) \
   METAVM_WRITE2(HANDLE, SLOT, VAL_LOW, VAL_HIGH, LABEL, STATE,proxy_put64field)
#else
#  define METAVM_PUTFIELD2(HANDLE, SLOT, VAL_LOW, VAL_HIGH, LABEL, STATE)
#endif	/* METAVM */

#if defined(METAVM) && !defined(METAVM_NO_ARRAY)
#  define METAVM_ASTORE2(HANDLE, SLOT, VAL_LOW, VAL_HIGH, LABEL, STATE) \
   METAVM_WRITE2(HANDLE, SLOT, VAL_LOW, VAL_HIGH, LABEL, STATE, proxy_astore64)
#else
#  define METAVM_ASTORE2(HANDLE, SLOT, VAL_LOW, VAL_HIGH, LABEL, STATE)
#endif	/* METAVM_NO_ARRAY */

#define CODE_LASTORE(OPTOP1_REG, OPTOP2_REG, STATE) \
  CODE(opc_lastore, [ld]astore, ST##STATE, ST0, 1) {\
    asm("popl  %eax\n\t"\
	"movl  (%esp),%edi");\
    METAVM_ASTORE2(%edi, %eax, OPTOP1_REG, OPTOP2_REG, "lastore_st" #STATE, STATE);\
    ARRAY_CHECK(%edi, %eax, "lastore_st" #STATE, STATE);\
    asm("popl  %edi");\
    UNHAND(%edi, %edi);\
    asm("leal  (%edi,%eax,8),%edi\n\t"\
	"movl  " #OPTOP1_REG ",(%edi)\n\t"\
	"movl  " #OPTOP2_REG ",4(%edi)");\
    asm("lastore_st" #STATE "_done:");\
    LDC2_W_DEBUG1(OPTOP1_REG, OPTOP2_REG);\
  }

  CODE_LASTORE(%ecx, %edx, 2);
  CODE_LASTORE(%edx, %ecx, 4);

  /* bastore */
	/* compile: iastore1, fill_cache, array_check, bastore */
  CODE(opc_bastore, bastore, ST2, ST0, 0) {
    METAVM_ASTORE(%edx, %ecx, %eax, "bastore_st2", 2);
    UNHAND(%edx, %edi);
    asm("movb  %al,(%edi,%ecx)");
    asm("bastore_st2_done:");
    BIPUSH_DEBUG1(%eax);
  }
  CODE(opc_bastore, bastore, ST4, ST0, 0) {
    METAVM_ASTORE(%ecx, %edx, %eax, "bastore_st4", 4);
    UNHAND(%ecx, %edi);
    asm("movb  %al,(%edi,%edx)");
    asm("bastore_st4_done:");
    BIPUSH_DEBUG1(%eax);
  }

  /* castore */
	/* compile: iastore1, fill_cache, array_check, castore */
  CODE(opc_castore, castore, ST2, ST0, 0) {
    METAVM_ASTORE(%edx, %ecx, %eax, "castore_st2", 2);
    UNHAND(%edx, %edi);
    asm("movw  %ax,(%edi,%ecx,2)");
    asm("castore_st2_done:");
    BIPUSH_DEBUG1(%eax);
  }
  CODE(opc_castore, castore, ST4, ST0, 0) {
    METAVM_ASTORE(%ecx, %edx, %eax, "castore_st4", 2);
    UNHAND(%ecx, %edi);
    asm("movw  %ax,(%edi,%edx,2)");
    asm("castore_st4_done:");
    BIPUSH_DEBUG1(%eax);
  }

  /* sastore */
	/* compile: iastore1, fill_cache, array_check, sastore */
  CODE(opc_sastore, sastore, ST2, ST0, 0) {
    METAVM_ASTORE(%edx, %ecx, %eax, "sastore_st2", 2);
    UNHAND(%edx, %edi);
    asm("movw  %ax,(%edi,%ecx,2)");
    asm("sastore_st2_done:");
    BIPUSH_DEBUG1(%eax);
  }
  CODE(opc_sastore, sastore, ST4, ST0, 0) {
    METAVM_ASTORE(%ecx, %edx, %eax, "sastore_st4", 4);
    UNHAND(%ecx, %edi);
    asm("movw  %ax,(%edi,%edx,2)");
    asm("sastore_st4_done:");
    BIPUSH_DEBUG1(%eax);
  }

  /* pop */
  CODE(opc_pop, pop, ST0, ST0, 0) {
    asm("addl  $4,%esp");
  }
  CODE(opc_pop, pop, ST1, ST0, 0) {}
  CODE(opc_pop, pop, ST2, ST1, 0) {}
  CODE(opc_pop, pop, ST3, ST0, 0) {}
  CODE(opc_pop, pop, ST4, ST3, 0) {}

  /* pop2 */
  CODE(opc_pop2, pop2, ST0, ST0, 0) {
    asm("addl  $8,%esp");
  }
  CODE(opc_pop2, pop2, ST1, ST0, 0) {
    asm("addl  $4,%esp");
  }
  CODE(opc_pop2, pop2, ST2, ST0, 0) {}
  CODE(opc_pop2, pop2, ST3, ST0, 0) {
    asm("addl  $4,%esp");
  }
  CODE(opc_pop2, pop2, ST4, ST0, 0) {}

  /* dup */
  CODE(opc_dup, dup, ST0, ST1, 0) {
    asm("movl  (%esp),%edx");
    BIPUSH_DEBUG1(%edx);
  }
  CODE(opc_dup, dup, ST1, ST2, 0) {
    asm("movl  %edx,%ecx");
    BIPUSH_DEBUG1(%ecx);
  }
  CODE(opc_dup, dup, ST2, ST2, 0) {
    asm("pushl %edx\n\t"
	"movl  %ecx,%edx");
    BIPUSH_DEBUG1(%edx);
  }
  CODE(opc_dup, dup, ST3, ST2, 0) {
    asm("movl  %ecx,%edx");
    BIPUSH_DEBUG1(%edx);
  }
  CODE(opc_dup, dup, ST4, ST2, 0) {
    asm("pushl %ecx\n\t"
	"movl  %edx,%ecx");
    BIPUSH_DEBUG1(%ecx);
  }

  /* dup_x1 */
  CODE(opc_dup_x1, dup_x1, ST0, ST2, 0) {
#if 0
    asm("popl  %ecx\n\t"		/* now state 3 */
	"movl  (%esp),%edx\n\t"
	"movl  %ecx,(%esp)");
#else
    asm("popl  %ecx\n\t"		/* now state 3 */
	"popl  %edx\n\t"
	"pushl %ecx");
#endif
  }
  CODE(opc_dup_x1, dup_x1, ST1, ST4, 0) {
#if 0
    asm("movl  (%esp),%ecx\n\t"
	"movl  %edx,(%esp)");
#else
    asm("popl  %ecx\n\t"
	"pushl %edx");
#endif
  }
  CODE(opc_dup_x1, dup_x1, ST2, ST2, 0) {
    asm("pushl %ecx");
  }
  CODE(opc_dup_x1, dup_x1, ST3, ST2, 0) {
#if 0
    asm("movl  (%esp),%edx\n\t"
	"movl  %ecx,(%esp)");
#else
    asm("popl  %edx\n\t"
	"pushl %ecx");
#endif
  }
  CODE(opc_dup_x1, dup_x1, ST4, ST4, 0) {
    asm("pushl %edx");
  }

  /* dup_x2 */
#if 0
#define DUP_X2_ST24(OPTOP1_REG) \
    asm("pushl (%esp)\n\t"\
	"movl  " #OPTOP1_REG ",4(%esp)")
#else
#define DUP_X2_ST24(OPTOP1_REG) \
    asm("popl  %eax\n\t"\
	"pushl " #OPTOP1_REG "\n\t"\
	"pushl %eax")
#endif

  CODE(opc_dup_x2, dup_x2, ST0, ST2, 0) {
    asm("popl  %ecx\n\t"
	"popl  %edx");		/* now state 2 */
    DUP_X2_ST24(%ecx);
  }
  CODE(opc_dup_x2, dup_x2, ST1, ST4, 0) {
    asm("popl  %ecx");		/* now state 4 */
    DUP_X2_ST24(%edx);
  }
  CODE(opc_dup_x2, dup_x2, ST2, ST2, 0) {
    DUP_X2_ST24(%ecx);
  }
  CODE(opc_dup_x2, dup_x2, ST3, ST2, 0) {
    asm("popl  %edx");		/* now state 2 */
    DUP_X2_ST24(%ecx);
  }
  CODE(opc_dup_x2, dup_x2, ST4, ST4, 0) {
    DUP_X2_ST24(%edx);
  }

  /* dup2 */
  CODE(opc_dup2, dup2, ST0, ST2, 0) {
#if 0
    asm("movl  (%esp),%ecx\n\t"
	"movl  4(%esp),%edx");
#else
    asm("popl  %ecx\n\t"
	"popl  %edx\n\t"
	"subl  $8,%esp");
#endif
  }
  CODE(opc_dup2, dup2, ST1, ST4, 0) {
    asm("movl  (%esp),%ecx\n\t"
	"pushl %edx");
  }
  CODE(opc_dup2, dup2, ST2, ST2, 0) {
    asm("pushl %edx\n\t"
	"pushl %ecx");
  }
  CODE(opc_dup2, dup2, ST3, ST2, 0) {
    asm("movl  (%esp),%edx\n\t"
	"pushl %ecx");
  }
  CODE(opc_dup2, dup2, ST4, ST4, 0) {
    asm("pushl %ecx\n\t"
	"pushl %edx");
  }

  /* dup2_x1 */
#define DUP2_X1_ST24(OPTOP1_REG, OPTOP2_REG) \
    asm("popl  %eax\n\t"		/* eax = optop[-3] */\
	"pushl " #OPTOP2_REG "\n\t"	/* optop[-5] = optop[-2] */\
	"pushl " #OPTOP1_REG "\n\t"	/* optop[-4] = optop[-1] */\
	"pushl %eax")		/* optop[-3] = eax */

  CODE(opc_dup2_x1, dup2_x1, ST0, ST2, 0) {
    asm("popl  %ecx\n\t"
	"popl  %edx");	/* now state 2 */
    DUP2_X1_ST24(%ecx, %edx);
  }
  CODE(opc_dup2_x1, dup2_x1, ST1, ST4, 0) {
    asm("popl  %ecx");	/* now state 4 */
    DUP2_X1_ST24(%edx, %ecx);
  }
  CODE(opc_dup2_x1, dup2_x1, ST2, ST2, 0) {
    DUP2_X1_ST24(%ecx, %edx);
  }
  CODE(opc_dup2_x1, dup2_x1, ST3, ST2, 0) {
    asm("popl  %edx");	/* now state 2 */
    DUP2_X1_ST24(%ecx, %edx);
  }
  CODE(opc_dup2_x1, dup2_x1, ST4, ST4, 0) {
    DUP2_X1_ST24(%edx, %ecx);
  }

  /* dup2_x2 */
#define DUP2_X2_ST24(OPTOP1_REG, OPTOP2_REG) \
    asm("popl  %eax\n\t"		/* eax = optop[-3] */\
	"popl  %edi\n\t"		/* edi = optop[-4] */\
	"pushl " #OPTOP2_REG "\n\t"	/* optop[-4] = optop[-2] */\
	"pushl " #OPTOP1_REG "\n\t"	/* optop[-3] = optop[-1] */\
	"pushl %edi\n\t"		/* optop[-2] = edi */\
	"pushl %eax");		/* optop[-1] = eax */

  CODE(opc_dup2_x2, dup2_x2, ST0, ST2, 0) {
    asm("popl  %ecx\n\t"
	"popl  %edx");	/* now state 2 */
    DUP2_X2_ST24(%ecx, %edx);
  }
  CODE(opc_dup2_x2, dup2_x2, ST1, ST4, 0) {
    asm("popl  %ecx");	/* now state 4 */
    DUP2_X2_ST24(%edx, %ecx);
  }
  CODE(opc_dup2_x2, dup2_x2, ST2, ST2, 0) {
    DUP2_X2_ST24(%ecx, %edx);
  }
  CODE(opc_dup2_x2, dup2_x2, ST3, ST2, 0) {
    asm("popl  %edx");	/* now state 2 */
    DUP2_X2_ST24(%ecx, %edx);
  }
  CODE(opc_dup2_x2, dup2_x2, ST4, ST4, 0) {
    DUP2_X2_ST24(%edx, %ecx);
  }

  /* swap */
  CODE(opc_swap, swap, ST0, ST4, 0) {
    asm("popl  %ecx\n\t"
	"popl  %edx");	/* now state 2 */
  }
  CODE(opc_swap, swap, ST1, ST2, 0) {
    asm("popl  %ecx");	/* now state 4 */
  }
  CODE(opc_swap, swap, ST2, ST4, 0) {}
  CODE(opc_swap, swap, ST3, ST4, 0) {
    asm("popl  %edx");	/* now state 2 */
  }
  CODE(opc_swap, swap, ST4, ST2, 0) {}

  /* iadd, isub, imul, iand, ior, ixor */
#ifdef RUNTIME_DEBUG
#  define ARITH_INT_DEBUG1(VAL1, VAL2, SYM) \
  if (runtime_debug) {\
    DEBUG_IN;\
    asm("pushl " #VAL2 "\n\t"\
	"pushl " #VAL1);\
    PUSH_CONSTSTR("  %d " SYM " %d\n");\
    asm("call  " SYMBOL(printf) "@PLT\n\t"\
	"addl  $12,%esp");\
    FFLUSH;\
    DEBUG_OUT;\
  }
#else
#  define ARITH_INT_DEBUG1(VAL1, VAL2, SYM)
#endif

#define CODE_ARITH_INT(VOP, ROP, SYM) \
  CODE(opc_i##VOP, i##VOP, ST0, ST1, 0) {\
    asm("popl  %ecx\n\t"\
	"popl  %edx");	/* now state 2 */\
    ARITH_INT_DEBUG1(%edx, %ecx, SYM);\
    asm(#ROP "l  %ecx,%edx");\
  }\
  CODE(opc_i##VOP, i##VOP, ST1, ST3, 0) {\
    asm("popl  %ecx");	/* now state 4 */\
    ARITH_INT_DEBUG1(%ecx, %edx, SYM);\
    asm(#ROP "l  %edx,%ecx");\
  }\
  CODE(opc_i##VOP, i##VOP, ST2, ST1, 0) {\
    ARITH_INT_DEBUG1(%edx, %ecx, SYM);\
    asm(#ROP "l  %ecx,%edx");\
  }\
  CODE(opc_i##VOP, i##VOP, ST3, ST1, 0) {\
    asm("popl  %edx");	/* now state 2 */\
    ARITH_INT_DEBUG1(%edx, %ecx, SYM);\
    asm(#ROP "l  %ecx,%edx");\
  }\
  CODE(opc_i##VOP, i##VOP, ST4, ST3, 0) {\
    ARITH_INT_DEBUG1(%ecx, %edx, SYM);\
    asm(#ROP "l  %edx,%ecx");\
  }

  CODE_ARITH_INT(add, add, "+");
  CODE_ARITH_INT(sub, sub, "-");
  CODE_ARITH_INT(mul, imul, "*");
  CODE_ARITH_INT(and, and, "&");
  CODE_ARITH_INT(or, or, "|");
  CODE_ARITH_INT(xor, xor, "^");

  /* idiv, irem */
#ifdef ARITHEXC_BY_SIGNAL
#  define INT_TEST(VOP, LABEL, STATE, DIVISOR)
#else
#  define INT_TEST(VOP, LABEL, STATE, DIVISOR)	/* dividend is %eax */\
    asm("testl " #DIVISOR "," #DIVISOR "\n\t"\
	"jnz   " LABEL "_1");\
    SIGNAL_ERROR0(ArithmeticException, STATE);\
    asm(LABEL "_1:");\
    asm("cmpl  $-1," #DIVISOR "\n\t"\
	"jne   " LABEL "_2\n\t"\
	"cmpl  $0x80000000,%eax\n\t"\
	"jne   " LABEL "_2\n\t"\
	/* %eax,%edx must be 0x80000000,0 */\
	"xorl  %edx,%edx\n\t"\
	"jmp   " LABEL "_done");\
    asm(LABEL "_2:");
#endif

#define CODE_ARITH_INT_TEST(VOP, RESULT_REG, SYM) \
  CODE(opc_i##VOP, i##VOP, ST0, ST3, 1) {\
    asm("popl  %ecx");	/* now state 3 */\
    asm("popl  %eax");\
    ARITH_INT_DEBUG1(%eax, %ecx, SYM);\
    INT_TEST(VOP, "i" #VOP "_st0", 0, %ecx);\
    asm("cdq");\
    asm("idivl %ecx\n\t"\
      "i" #VOP "_st0_done:"\
	"movl  " #RESULT_REG ",%ecx");\
  }\
  CODE(opc_i##VOP, i##VOP, ST1, ST3, 1) {\
    asm("popl  %eax\n\t"\
	"movl  %edx,%ecx");\
    ARITH_INT_DEBUG1(%eax, %ecx, SYM);\
    INT_TEST(VOP, "i" #VOP "_st1", 1, %ecx);\
    asm("cdq");\
    asm("idivl %ecx\n\t"\
      "i" #VOP "_st1_done:"\
	"movl  " #RESULT_REG ",%ecx");\
  }\
  CODE(opc_i##VOP, i##VOP, ST2, ST3, 1) {\
    asm("movl  %edx,%eax");\
    ARITH_INT_DEBUG1(%eax, %ecx, SYM);\
    INT_TEST(VOP, "i" #VOP "_st2", 2, %ecx);\
    asm("cdq");\
    asm("idivl %ecx\n\t"\
      "i" #VOP "_st2_done:"\
	"movl  " #RESULT_REG ",%ecx");\
  }\
  CODE(opc_i##VOP, i##VOP, ST3, ST3, 1) {\
    asm("popl  %eax");\
    ARITH_INT_DEBUG1(%eax, %ecx, SYM);\
    INT_TEST(VOP, "i" #VOP "_st3", 3, %ecx);\
    asm("cdq");\
    asm("idivl %ecx\n\t"	/* %eax ... %edx = %edx:%eax / %ecx */\
      "i" #VOP "_st3_done:"\
	"movl  " #RESULT_REG ",%ecx");\
  }\
  CODE(opc_i##VOP, i##VOP, ST4, ST3, 1) {\
    asm("movl  %ecx,%eax\n\t"\
	"movl  %edx,%ecx");\
    ARITH_INT_DEBUG1(%eax, %ecx, SYM);\
    INT_TEST(VOP, "i" #VOP "_st4", 4, %ecx);\
    asm("cdq");\
    asm("idivl %ecx\n\t"\
      "i" #VOP "_st4_done:"\
	"movl  " #RESULT_REG ",%ecx");\
  }

  CODE_ARITH_INT_TEST(div, %eax, "/");
  CODE_ARITH_INT_TEST(rem, %edx, "%%");

  /* ladd, lsub, land, lor, lxor */
#ifdef RUNTIME_DEBUG
#  define ARITH_LONG_DEBUG1(VAL1_LOW, VAL1_HIGH, VAL2_LOW, VAL2_HIGH, SYM) \
  if (runtime_debug) {\
    DEBUG_IN;\
    asm("pushl " #VAL2_HIGH "\n\tpushl " #VAL2_LOW "\n\t"\
	"pushl " #VAL2_HIGH "\n\tpushl " #VAL2_LOW "\n\t"\
	"pushl " #VAL1_HIGH "\n\tpushl " #VAL1_LOW "\n\t"\
	"pushl " #VAL1_HIGH "\n\tpushl " #VAL1_LOW);\
    PUSH_CONSTSTR("  %lld(0x%016llx) " SYM " %lld(0x%016llx)\n");\
    asm("call  " SYMBOL(printf) "@PLT\n\t"\
	"addl  $36,%esp");\
    FFLUSH;\
    DEBUG_OUT;\
  }
#else
#  define ARITH_LONG_DEBUG1(VAL1_LOW, VAL1_HIGH, VAL2_LOW, VAL2_HIGH, SYM)
#endif

#define ARITH_LONG_SUB(ROP1, ROP2, OPTOP1_REG, OPTOP2_REG, SYM) \
    asm("popl  " #OPTOP1_REG "\n\t"	/* val1[0:31] */\
	"popl  " #OPTOP2_REG);	/* val2[32:63] */\
    ARITH_LONG_DEBUG1(OPTOP1_REG, OPTOP2_REG, %eax, %edi, SYM);\
    asm(#ROP1 "l  %eax," #OPTOP1_REG "\n\t"	/* [0:31] */\
	#ROP2 "l  %edi," #OPTOP2_REG)	/* [32:63] */

#define CODE_ARITH_LONG_SUB(VOP, ROP1, ROP2, SYM) \
  CODE(opc_l##VOP, l##VOP, ST0, ST2, 0) {\
    asm("popl  %eax\n\t"\
	"popl  %edi");\
    ARITH_LONG_SUB(ROP1, ROP2, %ecx, %edx, SYM);\
  }\
  CODE(opc_l##VOP, l##VOP, ST1, ST4, 0) {\
    asm("movl  %edx,%eax\n\t"\
	"popl  %edi");\
    ARITH_LONG_SUB(ROP1, ROP2, %edx, %ecx, SYM);\
  }\
  CODE(opc_l##VOP, l##VOP, ST2, ST2, 0) {\
    asm("movl  %ecx,%eax\n\t"\
	"movl  %edx,%edi");\
    ARITH_LONG_SUB(ROP1, ROP2, %ecx, %edx, SYM);\
  }\
  CODE(opc_l##VOP, l##VOP, ST3, ST2, 0) {\
    asm("movl  %ecx,%eax\n\t"\
	"popl  %edi");\
    ARITH_LONG_SUB(ROP1, ROP2, %ecx, %edx, SYM);\
  }\
  CODE(opc_l##VOP, l##VOP, ST4, ST4, 0) {\
    asm("movl  %edx,%eax\n\t"\
	"movl  %ecx,%edi");\
    ARITH_LONG_SUB(ROP1, ROP2, %edx, %ecx, SYM);\
  }

#define ARITH_LONG(ROP1, ROP2, OPTOP1_REG, OPTOP2_REG, SYM) \
    asm("popl  %eax\n\t"	/* eax = val1[0:31] */\
	"popl  %edi");	/* edi = val2[32:63] */\
    ARITH_LONG_DEBUG1(%eax, %edi, OPTOP1_REG, OPTOP2_REG, SYM);\
    asm(#ROP1 "l  %eax," #OPTOP1_REG "\n\t"	/* [0:31] */\
	#ROP2 "l  %edi," #OPTOP2_REG)	/* [32:63] */

#define CODE_ARITH_LONG(VOP, ROP1, ROP2, SYM) \
  CODE(opc_l##VOP, l##VOP, ST0, ST2, 0) {\
    asm("popl  %ecx\n\t"\
	"popl  %edx");		/* now state 2 */\
    ARITH_LONG(ROP1, ROP2, %ecx, %edx, SYM);\
  }\
  CODE(opc_l##VOP, l##VOP, ST1, ST4, 0) {\
    asm("popl  %ecx");		/* now state 4 */\
    ARITH_LONG(ROP1, ROP2, %edx, %ecx, SYM);\
  }\
  CODE(opc_l##VOP, l##VOP, ST2, ST2, 0) {\
    ARITH_LONG(ROP1, ROP2, %ecx, %edx, SYM);\
  }\
  CODE(opc_l##VOP, l##VOP, ST3, ST2, 0) {\
    asm("popl  %edx");		/* now state 2 */\
    ARITH_LONG(ROP1, ROP2, %ecx, %edx, SYM);\
  }\
  CODE(opc_l##VOP, l##VOP, ST4, ST4, 0) {\
    ARITH_LONG(ROP1, ROP2, %edx, %ecx, SYM);\
  }

  CODE_ARITH_LONG(add, add, adc, "+");
  CODE_ARITH_LONG_SUB(sub, sub, sbb, "-");
  CODE_ARITH_LONG(and, and, and, "&");
  CODE_ARITH_LONG(or, or, or, "|");
  CODE_ARITH_LONG(xor, xor, xor, "^");

  /* lmul */
#ifdef RUNTIME_DEBUG
#  define ARITH_LONG_CALL_DEBUG1(OPTOP1_REG, OPTOP2_REG, SYM) \
  if (runtime_debug) {\
    asm("pushl %eax\n\tpushl %edi");\
    asm("movl  8(%esp),%eax\n\t"\
	"movl  12(%esp),%edi");\
    DEBUG_IN;\
    asm("pushl " #OPTOP2_REG "\n\t"\
	"pushl " #OPTOP1_REG "\n\t"\
	"pushl %edi\n\tpushl %eax");\
    PUSH_CONSTSTR("  %lld " SYM " %lld\n");\
    asm("call  " SYMBOL(printf) "@PLT\n\t"\
	"addl  $20,%esp");\
    FFLUSH;\
    DEBUG_OUT;\
    asm("popl %edi\n\tpopl %eax");\
  }
#else
#  define ARITH_LONG_CALL_DEBUG1(OPTOP1_REG, OPTOP2_REG, SYM)
#endif

#define LMUL_ST24(OPTOP1, LOW_WORD, HIGH_WORD) \
    asm("movl  " #OPTOP1 ",%eax\n\t"\
	"movl  %edx,%edi\n\t"\
	"mull  (%esp)\n\t"\
	"movl  %eax,-8(%esp)\n\t"\
	"movl  %edx,-4(%esp)\n\t"\
	"imull 4(%esp)," #LOW_WORD "\n\t"\
	"addl  " #LOW_WORD ",-4(%esp)\n\t"\
	"imull (%esp)," #HIGH_WORD "\n\t"\
	"addl  " #HIGH_WORD ",-4(%esp)\n\t"\
	"movl  -8(%esp),%ecx\n\t"\
	"movl  -4(%esp),%edx\n\t"	/* now state 2 */\
	"addl  $8,%esp")

  CODE(opc_lmul, lmul, ST0, ST2, 0) {
    asm("popl  %ecx\n\t"
	"popl  %edx");	/* now state 2 */
    ARITH_LONG_CALL_DEBUG1(%ecx, %edx, "*");
    LMUL_ST24(%ecx, %ecx, %edi);
  }
  CODE(opc_lmul, lmul, ST1, ST2, 0) {
    asm("popl  %ecx");	/* now state 4 */
    ARITH_LONG_CALL_DEBUG1(%edx, %ecx, "*");
    LMUL_ST24(%edx, %edi, %ecx);
  }
  CODE(opc_lmul, lmul, ST2, ST2, 0) {
    ARITH_LONG_CALL_DEBUG1(%ecx, %edx, "*");
    LMUL_ST24(%ecx, %ecx, %edi);
  }
  CODE(opc_lmul, lmul, ST3, ST2, 0) {
    asm("popl  %edx");	/* now state 2 */
    ARITH_LONG_CALL_DEBUG1(%ecx, %edx, "*");
    LMUL_ST24(%ecx, %ecx, %edi);
  }
  CODE(opc_lmul, lmul, ST4, ST2, 0) {
    ARITH_LONG_CALL_DEBUG1(%edx, %ecx, "*");
    LMUL_ST24(%edx, %edi, %ecx);
  }

  /* ldiv, lrem */
#define ARITH_LONG_CALL_ST24(ROP, OPTOP1_REG, OPTOP2_REG, SYM) \
    ARITH_LONG_CALL_DEBUG1(OPTOP1_REG, OPTOP2_REG, SYM);\
    asm("popl  %eax\n\t"	/* eax = v1[0:31] */\
	"popl  %edi");	/* edi = v1[32:63] */\
    FUNCCALL_IN(0);\
    asm("pushl %ebp\n\t");	/* back up for signal handler */\
    asm("pushl " #OPTOP2_REG "\n\t"	/* push v2[32:63] */\
	"pushl " #OPTOP1_REG "\n\t"	/* push v2[0:31] */\
	"pushl %edi\n\t"	/* push v1[32:63] */\
	"pushl %eax\n\t"	/* push v1[0:31] */\
	"call  " ROP "@PLT\n\t"\
	"addl  $20,%esp");\
    asm(/* movl %edx,%edx */\
	"movl  %eax,%ecx");\
    FUNCCALL_OUT(0)
	/* now state 2 */

#ifdef ARITHEXC_BY_SIGNAL
#  define LONG_TEST_ST24(VOP, LABEL, STATE)
#else
#  define LONG_TEST_ST24(VOP, LABEL, STATE) \
	/* if ((%edx == 0) && (%ecx == 0))  throw ArithmeticException; */\
    asm("movl  %edx,%eax\n\t"\
	"orl   %ecx,%eax\n\t"\
	"jnz   " LABEL "_1");\
    SIGNAL_ERROR0(ArithmeticException, STATE);\
    asm(LABEL "_1:")
	/* now state [24] */
#endif

#define CODE_ARITH_LONG_TEST(VOP, ROP, SYM) \
  CODE(opc_l##VOP, l##VOP, ST0, ST2, 1) {\
    asm("popl  %ecx\n\t"\
	"popl  %edx");	/* now state 2 */\
    LONG_TEST_ST24(VOP, "l" #VOP "_st0", 0);\
    ARITH_LONG_CALL_ST24(ROP, %ecx, %edx, SYM);\
  }\
  CODE(opc_l##VOP, l##VOP, ST1, ST2, 1) {\
    asm("popl  %ecx");	/* now state 4 */\
    LONG_TEST_ST24(VOP, "l" #VOP "_st1", 1);\
    ARITH_LONG_CALL_ST24(ROP, %edx, %ecx, SYM);\
  }\
  CODE(opc_l##VOP, l##VOP, ST2, ST2, 1) {\
    LONG_TEST_ST24(VOP, "l" #VOP "_st2", 2);\
    ARITH_LONG_CALL_ST24(ROP, %ecx, %edx, SYM);\
  }\
  CODE(opc_l##VOP, l##VOP, ST3, ST2, 1) {\
    asm("popl  %edx");	/* now state 2 */\
    LONG_TEST_ST24(VOP, "l" #VOP "_st3", 3);\
    ARITH_LONG_CALL_ST24(ROP, %ecx, %edx, SYM);\
  }\
  CODE(opc_l##VOP, l##VOP, ST4, ST2, 1) {\
    LONG_TEST_ST24(VOP, "l" #VOP "_st4", 4);\
    ARITH_LONG_CALL_ST24(ROP, %edx, %ecx, SYM);\
  }

  CODE_ARITH_LONG_TEST(div, SYMBOL(__divdi3), "/");
  CODE_ARITH_LONG_TEST(rem, SYMBOL(__moddi3), "mod");

  /* fadd, fsub, fmul, fdiv */
#ifdef RUNTIME_DEBUG
#  define ARITH_FLOAT_DEBUG1(SYM) \
  if (runtime_debug) {\
    asm("flds  4(%esp)\n\t"\
	"flds  (%esp)");\
    DEBUG_IN;\
    asm("subl  $16,%esp\n\t"\
	"fstpl 8(%esp)\n\t"\
	"fstpl (%esp)");\
    PUSH_CONSTSTR("%g " SYM " %g = ");\
    asm("call  " SYMBOL(printf) "@PLT\n\t"\
	"addl  $20,%esp");\
    FFLUSH;\
    DEBUG_OUT;\
  }
#  define ARITH_FLOAT_DEBUG2 \
  if (runtime_debug) {\
    asm("flds  (%esp)");\
    DEBUG_IN;\
    asm("subl  $8,%esp\n\t"\
	"fstpl (%esp)");\
    PUSH_CONSTSTR("%g\n");\
    asm("call  " SYMBOL(printf) "@PLT\n\t"\
	"addl  $12,%esp");\
    FFLUSH;\
    DEBUG_OUT;\
  }
#else
#  define ARITH_FLOAT_DEBUG1(SYM)
#  define ARITH_FLOAT_DEBUG2
#endif

#define CODE_ARITH_FLOAT(VOP, ROP, SYM) \
  CODE(opc_f##VOP, f##VOP, ST0, ST0, 0) {\
    ARITH_FLOAT_DEBUG1(SYM);\
    asm("flds  4(%esp)\n\t"\
	"f" #ROP "s (%esp)\n\t"\
	"addl  $4,%esp\n\t"\
	"fstps (%esp)");\
    ARITH_FLOAT_DEBUG2;\
  }\
  CODE(opc_f##VOP, f##VOP, ST1, ST0, 0) {\
    asm("flds  (%esp)\n\t"\
	"pushl %edx");\
    ARITH_FLOAT_DEBUG1(SYM);\
    asm("f" #ROP "s (%esp)\n\t"\
	"addl  $4,%esp\n\t"\
	"fstps (%esp)");\
    ARITH_FLOAT_DEBUG2;\
  }\
  CODE(opc_f##VOP, f##VOP, ST2, ST0, 0) {\
    asm("pushl %edx\n\t"\
	"flds  (%esp)\n\t"\
	"pushl %ecx");\
    ARITH_FLOAT_DEBUG1(SYM);\
    asm("f" #ROP "s (%esp)\n\t"\
	"addl  $4,%esp\n\t"\
	"fstps (%esp)");\
    ARITH_FLOAT_DEBUG2;\
  }\
  CODE(opc_f##VOP, f##VOP, ST3, ST0, 0) {\
    asm("flds  (%esp)\n\t"\
	"pushl %ecx");\
    ARITH_FLOAT_DEBUG1(SYM);\
    asm("f" #ROP "s (%esp)\n\t"\
	"addl  $4,%esp\n\t"\
	"fstps (%esp)");\
    ARITH_FLOAT_DEBUG2;\
  }\
  CODE(opc_f##VOP, f##VOP, ST4, ST0, 0) {\
    asm("pushl %ecx\n\t"\
	"flds  (%esp)\n\t"\
	"pushl %edx\n\t"\
	"f" #ROP "s (%esp)\n\t"\
	"addl  $4,%esp\n\t"\
	"fstps (%esp)");\
    ARITH_FLOAT_DEBUG2;\
  }

  CODE_ARITH_FLOAT(add, add, "+");
  CODE_ARITH_FLOAT(sub, sub, "-");
  CODE_ARITH_FLOAT(mul, mul, "*");
  CODE_ARITH_FLOAT(div, div, "/");

  /* dadd, dsub, dmul, ddiv */
#ifdef RUNTIME_DEBUG
#  define ARITH_DOUBLE_DEBUG1(OPTOP1_REG, OPTOP2_REG, SYM) \
  if (runtime_debug) {\
    asm("movl  (%esp),%edi\n\t"\
	"movl  4(%esp),%eax");\
    DEBUG_IN;\
    asm("pushl " #OPTOP2_REG "\n\t"\
	"pushl " #OPTOP1_REG "\n\t"\
	"pushl %eax\n\tpushl %edi");\
    PUSH_CONSTSTR("  %g " SYM " %g = ");\
    asm("call  " SYMBOL(printf) "@PLT\n\t"\
	"addl  $20,%esp");\
    FFLUSH;\
    DEBUG_OUT;\
  }
#  define ARITH_DOUBLE_DEBUG2 \
  if (runtime_debug) {\
    asm("movl  (%esp),%edi\n\t"\
	"movl  4(%esp),%eax");\
    DEBUG_IN;\
    asm("pushl %eax\n\tpushl %edi");\
    PUSH_CONSTSTR("%g\n");\
    asm("call  " SYMBOL(printf) "@PLT\n\t"\
	"addl  $12,%esp");\
    FFLUSH;\
    DEBUG_OUT;\
  }
#else
#  define ARITH_DOUBLE_DEBUG1(OPTOP1_REG, OPTOP2_REG, SYM)
#  define ARITH_DOUBLE_DEBUG2
#endif

#define DOUBLE_ST24(ROP, OPTOP1_REG, OPTOP2_REG, SYM) \
    ARITH_DOUBLE_DEBUG1(OPTOP1_REG, OPTOP2_REG, SYM);\
    asm("fldl  (%esp)\n\t"	/* load v1[0:63] */\
	"addl  $8,%esp\n\t"\
	"pushl " #OPTOP2_REG "\n\t"	/* v2[32:63] */\
	"pushl " #OPTOP1_REG "\n\t"	/* v2[0:31] */\
	"f" #ROP "l (%esp)\n\t"\
	"fstpl (%esp)");\
    ARITH_DOUBLE_DEBUG2
	/* now state 0 */

#define CODE_ARITH_DOUBLE(VOP, ROP, SYM) \
  CODE(opc_d##VOP, d##VOP, ST0, ST0, 0) {\
    asm("popl  %ecx\n\t"\
	"popl  %edx");		/* now state 2 */\
    DOUBLE_ST24(ROP, %ecx, %edx, SYM);\
  }\
  CODE(opc_d##VOP, d##VOP, ST1, ST0, 0) {\
    asm("popl  %ecx");		/* now state 4 */\
    DOUBLE_ST24(ROP, %edx, %ecx, SYM);\
  }\
  CODE(opc_d##VOP, d##VOP, ST2, ST0, 0) {\
    DOUBLE_ST24(ROP, %ecx, %edx, SYM);\
  }\
  CODE(opc_d##VOP, d##VOP, ST3, ST0, 0) {\
    asm("popl  %edx");		/* now state 2 */\
    DOUBLE_ST24(ROP, %ecx, %edx, SYM);\
  }\
  CODE(opc_d##VOP, d##VOP, ST4, ST0, 0) {\
    DOUBLE_ST24(ROP, %edx, %ecx, SYM);\
  }

  CODE_ARITH_DOUBLE(add, add, "+");
  CODE_ARITH_DOUBLE(sub, sub, "-");
  CODE_ARITH_DOUBLE(mul, mul, "*");
  CODE_ARITH_DOUBLE(div, div, "/");

  /* frem */
#define FREM_ST0 \
    ARITH_FLOAT_DEBUG1("mod");\
    asm("flds  (%esp)\n\t"		/* fld optop[-1].f (value2) */\
	"flds  4(%esp)");		/* fld optop[-2].f (value1) */\
    FUNCCALL_IN(0);\
    asm("subl  $16,%esp");\
    asm("fstpl (%esp)\n\t"		/* stack top   = optop[-2] (value1) */\
	"fstpl 8(%esp)\n\t"		/* stack top-1 = optop[-1] (value2) */\
	"call  " SYMBOL(fmod) "@PLT\n\t"\
	"addl  $16,%esp");\
    FUNCCALL_OUT(0);\
    asm("addl  $4,%esp\n\t"\
	"fstps (%esp)");\
    ARITH_FLOAT_DEBUG2
	/* now state 0 */

  CODE(opc_frem, frem, ST0, ST0, 0) { FREM_ST0; }
  CODE(opc_frem, frem, ST1, ST0, 0) {
    asm("pushl %edx");	/* now state 0 */
    FREM_ST0;
  }
  CODE(opc_frem, frem, ST2, ST0, 0) {
    asm("pushl %edx\n\t"
	"pushl %ecx");	/* now state 0 */
    FREM_ST0;
  }
  CODE(opc_frem, frem, ST3, ST0, 0) {
    asm("pushl %ecx");	/* now state 0 */
    FREM_ST0;
  }
  CODE(opc_frem, frem, ST4, ST0, 0) {
    asm("pushl %ecx\n\t"
	"pushl %edx");	/* now state 0 */
    FREM_ST0;
  }

  /* drem */
#define DREM_ST24(OPTOP1_REG, OPTOP2_REG) \
    ARITH_DOUBLE_DEBUG1(OPTOP1_REG, OPTOP2_REG, "mod");\
    asm("popl  %eax\n\t"	/* eax = v1[0:31] */\
	"popl  %edi");	/* edi = v1[32:63] */\
    FUNCCALL_IN(0);\
    asm("pushl " #OPTOP2_REG "\n\t"	/* push v2[32:63] */\
	"pushl " #OPTOP1_REG "\n\t"	/* push v2[0:31] */\
	"pushl %edi\n\t"	/* push v1[32:63] */\
	"pushl %eax\n\t"	/* push v1[0:31] */\
	"call  " SYMBOL(fmod) "@PLT\n\t"\
	"addl  $16,%esp");\
    FUNCCALL_OUT(0);\
    asm("subl  $8,%esp\n\t"\
	"fstpl (%esp)");\
    ARITH_DOUBLE_DEBUG2
	/* now state 0 */

  CODE(opc_drem, drem, ST0, ST0, 0) {
    asm("popl  %ecx\n\t"
	"popl  %edx");	/* now state 2 */
    DREM_ST24(%ecx, %edx);
  }
  CODE(opc_drem, drem, ST1, ST0, 0) {
    asm("popl  %ecx");	/* now state 4 */
    DREM_ST24(%edx, %ecx);
  }
  CODE(opc_drem, drem, ST2, ST0, 0) {
    DREM_ST24(%ecx, %edx);
  }
  CODE(opc_drem, drem, ST3, ST0, 0) {
    asm("popl  %edx");	/* now state 2 */
    DREM_ST24(%ecx, %edx);
  }
  CODE(opc_drem, drem, ST4, ST0, 0) {
    DREM_ST24(%edx, %ecx);
  }

  /* ineg */
  CODE(opc_ineg, ineg, ST0, ST1, 0) {
    asm("popl  %edx\n\t"	/* now state 1 */
	"negl  %edx");
    BIPUSH_DEBUG1(%edx);
  }
  CODE(opc_ineg, ineg, ST1, ST1, 0) {
    asm("negl  %edx");
    BIPUSH_DEBUG1(%edx);
  }
  CODE(opc_ineg, ineg, ST2, ST2, 0) {
    asm("negl  %ecx");
    BIPUSH_DEBUG1(%ecx);
  }
  CODE(opc_ineg, ineg, ST3, ST3, 0) {
    asm("negl  %ecx");
    BIPUSH_DEBUG1(%ecx);
  }
  CODE(opc_ineg, ineg, ST4, ST4, 0) {
    asm("negl  %edx");
    BIPUSH_DEBUG1(%edx);
  }

  /* lneg */
#define LNEG_ST24(OPTOP1_REG, OPTOP2_REG) \
    asm("negl  " #OPTOP1_REG "\n\t"\
	"adcl  $0," #OPTOP2_REG "\n\t"\
	"negl  " #OPTOP2_REG);\
    LDC2_W_DEBUG1(OPTOP1_REG, OPTOP2_REG)
	/* now state [24] */

  CODE(opc_lneg, lneg, ST0, ST2, 0) {
    asm("popl  %ecx\n\t"
	"popl  %edx");	/* now state 2 */
    LNEG_ST24(%ecx, %edx);
  }
  CODE(opc_lneg, lneg, ST1, ST4, 0) {
    asm("popl  %ecx");	/* now state 4 */
    LNEG_ST24(%edx, %ecx);
  }
  CODE(opc_lneg, lneg, ST2, ST2, 0) {
    LNEG_ST24(%ecx, %edx);
  }
  CODE(opc_lneg, lneg, ST3, ST2, 0) {
    asm("popl  %edx");	/* now state 2 */
    LNEG_ST24(%ecx, %edx);
  }
  CODE(opc_lneg, lneg, ST4, ST4, 0) {
    LNEG_ST24(%edx, %ecx);
  }

  /* fneg */
#define FNEG_ST0 \
    asm("flds  (%esp)\n\t"\
	"fchs\n\t"\
	"fstps (%esp)")
	/* now state 0 */

  CODE(opc_fneg, fneg, ST0, ST0, 0) {
    FNEG_ST0;
  }
  CODE(opc_fneg, fneg, ST1, ST0, 0) {
    asm("pushl %edx");	/* now state 0 */
    FNEG_ST0;
  }
  CODE(opc_fneg, fneg, ST2, ST0, 0) {
    asm("pushl %edx\n\t"
	"pushl %ecx");	/* now state 0 */
    FNEG_ST0;
  }
  CODE(opc_fneg, fneg, ST3, ST0, 0) {
    asm("pushl %ecx");	/* now state 0 */
    FNEG_ST0;
  }
  CODE(opc_fneg, fneg, ST4, ST0, 0) {
    asm("pushl %ecx\n\t"
	"pushl %edx");	/* now state 0 */
    FNEG_ST0;
  }

  /* dneg */
#define DNEG_ST0 \
    asm("fldl  (%esp)\n\t"\
	"fchs\n\t"\
	"fstpl (%esp)")
	/* now state 0 */

  CODE(opc_dneg, dneg, ST0, ST0, 0) {
    DNEG_ST0;
  }
  CODE(opc_dneg, dneg, ST1, ST0, 0) {
    asm("pushl %edx");	/* now state 0 */
    DNEG_ST0;
  }
  CODE(opc_dneg, dneg, ST2, ST0, 0) {
    asm("pushl %edx\n\t"
	"pushl %ecx");	/* now state 0 */
    DNEG_ST0;
  }
  CODE(opc_dneg, dneg, ST3, ST0, 0) {
    asm("pushl %ecx");	/* now state 0 */
    DNEG_ST0;
  }
  CODE(opc_dneg, dneg, ST4, ST0, 0) {
    asm("pushl %ecx\n\t"
	"pushl %edx");	/* now state 0 */
    DNEG_ST0;
  }

  /* ishl */
#define SHIFT_INT_ST2(ROP) \
    asm(#ROP "l  %cl,%edx")
	/* now state 1 */

#define CODE_SHIFT_INT(VOP, ROP) \
  CODE(opc_i##VOP, i##VOP, ST0, ST1, 0) {\
    asm("popl  %ecx\n\t"\
	"popl  %edx");	/* now state 2 */\
    SHIFT_INT_ST2(ROP);\
    BIPUSH_DEBUG1(%edx);\
  }\
  CODE(opc_i##VOP, i##VOP, ST1, ST1, 0) {\
    asm("movl  %edx,%ecx\n\t"\
	"popl  %edx\n\t");	/* now state 2 */\
    SHIFT_INT_ST2(ROP);\
    BIPUSH_DEBUG1(%edx);\
  }\
  CODE(opc_i##VOP, i##VOP, ST2, ST1, 0) {\
    SHIFT_INT_ST2(ROP);\
    BIPUSH_DEBUG1(%edx);\
  }\
  CODE(opc_i##VOP, i##VOP, ST3, ST1, 0) {\
    asm("popl  %edx");	/* now state 2 */\
    SHIFT_INT_ST2(ROP);\
    BIPUSH_DEBUG1(%edx);\
  }\
  CODE(opc_i##VOP, i##VOP, ST4, ST1, 0) {\
    asm("xchg  %ecx,%edx");	/* now state 2 */\
    SHIFT_INT_ST2(ROP);\
    BIPUSH_DEBUG1(%edx);\
  }

  CODE_SHIFT_INT(shl, shl);
  CODE_SHIFT_INT(shr, sar);
  CODE_SHIFT_INT(ushr, shr);

  /* lshl, lshr, lushr */
	/*
	 * %cl is shift count.
	 * OP2 and OP3 are %eax and %edx.
	 */
#if 1	/* code generated by egcs-1.0.3 */
#define SHIFT_SIGNED_LONG(ROP64, ROP32, OP2_REG, OP3_REG, LABEL) \
    asm(#ROP64 "l %cl," #OP2_REG "," #OP3_REG "\n\t"\
	#ROP32 "l %cl," #OP2_REG "\n\t"\
	"testb $0x20,%cl\n\t"\
	"jz    " LABEL "\n\t"\
	"movl  " #OP2_REG "," #OP3_REG "\n\t"\
	#ROP32 "l $0x1f," #OP2_REG "\n\t"\
      LABEL ":\n\t"\
	"movl  %eax,%ecx")
	/* now state 2 or 4 */
#define SHIFT_UNSIGNED_LONG(ROP64, ROP32, OP2_REG, OP3_REG, LABEL) \
    asm(#ROP64 "l %cl," #OP2_REG "," #OP3_REG "\n\t"\
	#ROP32 "l %cl," #OP2_REG "\n\t"\
	"testb $0x20,%cl\n\t"\
	"jz    " LABEL "\n\t"\
	"movl  " #OP2_REG "," #OP3_REG "\n\t"\
	"xorl  " #OP2_REG "," #OP2_REG "\n\t"	/* clear OP2_REG */\
      LABEL ":\n\t"\
	"movl  %eax,%ecx")
	/* now state 2 or 4 */
#else	/* code generated by gcc-2.7.2.3 */
#define SHIFT_LONG(ROP64, ROP32, OP2_REG, OP3_REG, LABEL) \
    asm("rorb  %cl\n\t"\
	#ROP64 "l %cl," #OP2_REG "," #OP3_REG "\n\t"\
	#ROP32 "l  %cl," #OP2_REG "\n\t"\
	#ROP64 "l %cl," #OP2_REG "," #OP3_REG "\n\t"\
	#ROP32 "l  %cl," #OP2_REG "\n\t"\
	"shrb  $7,%cl\n\t"\
	#ROP64 "l %cl," #OP2_REG "," #OP3_REG "\n\t"\
	#ROP32 "l  %cl," #OP2_REG "\n\t"\
	"movl  %eax,%ecx")
	/* now state 2 or 4 */
#endif

#define CODE_SHIFT_LONG(SIGNEDP, VOP, ROP64, ROP32, REG_A, REG_B) \
  CODE(opc_l##VOP, l##VOP, ST0, ST2, 0) {\
    asm("popl  %ecx\n\t"		/* ecx = shift count */\
	"popl  %eax\n\t"		/* eax = [0:31] */\
	"popl  %edx");		/* edx = [32:63] */\
    SHIFT_##SIGNEDP##_LONG(ROP64, ROP32, REG_A, REG_B, #VOP "_st0");\
    LDC2_W_DEBUG1(%ecx, %edx);\
  }\
  CODE(opc_l##VOP, l##VOP, ST1, ST2, 0) {\
    asm("movl  %edx,%ecx\n\t"	/* ecx = shift count (%edx) */\
	"popl  %eax\n\t"		/* eax = [0:31] */\
	"popl  %edx");		/* edx = [32:63] */\
    SHIFT_##SIGNEDP##_LONG(ROP64, ROP32, REG_A, REG_B, #VOP "_st1");\
    LDC2_W_DEBUG1(%ecx, %edx);\
  }\
  CODE(opc_l##VOP, l##VOP, ST2, ST4, 0) {\
    asm("popl  %eax");		/* eax = [32:63] */\
    SHIFT_##SIGNEDP##_LONG(ROP64, ROP32, REG_B, REG_A, #VOP "_st2");\
    LDC2_W_DEBUG1(%edx, %ecx);\
  }\
  CODE(opc_l##VOP, l##VOP, ST3, ST2, 0) {\
    asm("popl  %eax\n\t"		/* eax = [0:31] */\
	"popl  %edx");		/* edx = [32:63] */\
    SHIFT_##SIGNEDP##_LONG(ROP64, ROP32, REG_A, REG_B, #VOP "_st3");\
    LDC2_W_DEBUG1(%ecx, %edx);\
  }\
  CODE(opc_l##VOP, l##VOP, ST4, ST2, 0) {\
    asm("movl  %ecx,%eax\n\t"	/* eax = [0:31] (ecx) */\
	"movl  %edx,%ecx\n\t"	/* ecx = shift count (edx) */\
	"popl  %edx");		/* edx = [32:63] */\
    SHIFT_##SIGNEDP##_LONG(ROP64, ROP32, REG_A, REG_B, #VOP "_st4");\
    LDC2_W_DEBUG1(%ecx, %edx);\
  }

  CODE_SHIFT_LONG(UNSIGNED, shl, shld, shl, %eax, %edx);
  CODE_SHIFT_LONG(SIGNED, shr, shrd, sar, %edx, %eax);
  CODE_SHIFT_LONG(UNSIGNED, ushr, shrd, shr, %edx, %eax);

  /* iinc */
	/* const: (signed char *pc)[2], pc[1] * 4 */
#ifdef RUNTIME_DEBUG
#  define IINC_DEBUG1 \
  if (runtime_debug) {\
    DEBUG_IN;\
    asm("pushl " STR(CONST) "(%esi)\n\t"\
	"movl  $" STR(CONST) ",%eax\n\t"\
	"sarl  $2,%eax\n\t"\
	"negl  %eax\n\t"\
	"pushl %eax");\
    PUSH_CONSTSTR("  var[%d] %d");\
    asm("call  " SYMBOL(printf) "@PLT\n\t"\
	"addl  $12,%esp");\
    FFLUSH;\
    DEBUG_OUT;\
  }

#  define IINC_DEBUG2 \
  if (runtime_debug) {\
    DEBUG_IN;\
    asm("pushl " STR(CONST) "(%esi)\n\t"\
	"pushl $" STR(CONST));\
    PUSH_CONSTSTR(" + %d = %d\n");\
    asm("call  " SYMBOL(printf) "@PLT\n\t"\
	"addl  $12,%esp");\
    FFLUSH;\
    DEBUG_OUT;\
  }
#else
#  define IINC_DEBUG1
#  define IINC_DEBUG2
#endif

  CODE(opc_iinc, iinc, STANY, STSTA, 0) {
    IINC_DEBUG1;
    asm("addl  $" STR(CONST) "," STR(CONST) "(%esi)");
    IINC_DEBUG2;
  }

  /* i2l */
  CODE(opc_i2l, i2l, ST0, ST2, 0) {
    asm("popl  %edx\n\t"	/* now state 1 */
	"movl  %edx,%ecx\n\t"
	"sarl  $31,%edx");
  }
  CODE(opc_i2l, i2l, ST1, ST2, 0) {
    asm("movl  %edx,%ecx\n\t"
	"sarl  $31,%edx");
  }
  CODE(opc_i2l, i2l, ST2, ST4, 0) {
    asm("pushl %edx\n\t"	/* now state 3 */
	"movl  %ecx,%edx\n\t"
	"sarl  $31,%ecx");
  }
  CODE(opc_i2l, i2l, ST3, ST4, 0) {
    asm("movl  %ecx,%edx\n\t"
	"sarl  $31,%ecx");
  }
  CODE(opc_i2l, i2l, ST4, ST2, 0) {
    asm("pushl %ecx\n\t"	/* now state 1 */
	"movl  %edx,%ecx\n\t"
	"sarl  $31,%edx");
  }

  /* i2f */
#define I2F_ST0 \
    asm("fildl (%esp)\n\t"\
	"fstps (%esp)")

  CODE(opc_i2f, i2f, ST0, ST0, 0) {
    I2F_ST0;
  }
  CODE(opc_i2f, i2f, ST1, ST0, 0) {
    asm("pushl %edx");	/* now state 0 */
    I2F_ST0;
  }
  CODE(opc_i2f, i2f, ST2, ST0, 0) {
    asm("pushl %edx\n\t"
	"pushl %ecx");	/* now state 0 */
    I2F_ST0;
  }
  CODE(opc_i2f, i2f, ST3, ST0, 0) {
    asm("pushl %ecx");	/* now state 0 */
    I2F_ST0;
  }
  CODE(opc_i2f, i2f, ST4, ST0, 0) {
    asm("pushl %ecx\n\t"
	"pushl %edx");	/* now state 0 */
    I2F_ST0;
  }

  /* i2d */
#define I2D_ST0 \
    asm("fildl (%esp)\n\t"\
	"fstpl -4(%esp)\n\t"\
	"subl  $4,%esp")

  CODE(opc_i2d, i2d, ST0, ST0, 0) {
    I2D_ST0;
  }
  CODE(opc_i2d, i2d, ST1, ST0, 0) {
    asm("pushl %edx");	/* now state 0 */
    I2D_ST0;
  }
  CODE(opc_i2d, i2d, ST2, ST0, 0) {
    asm("pushl %edx\n\t"
	"pushl %ecx");	/* now state 0 */
    I2D_ST0;
  }
  CODE(opc_i2d, i2d, ST3, ST0, 0) {
    asm("pushl %ecx");	/* now state 0 */
    I2D_ST0;
  }
  CODE(opc_i2d, i2d, ST4, ST0, 0) {
    asm("pushl %ecx\n\t"
	"pushl %edx");	/* now state 0 */
    I2D_ST0;
  }

  /* l2i */
  CODE(opc_l2i, l2i, ST0, ST1, 0) {
    asm("popl  %edx\n\t"	/* now state 1 */
	"addl  $4,%esp");
  }
  CODE(opc_l2i, l2i, ST1, ST1, 0) {
    asm("addl  $4,%esp");
  }
  CODE(opc_l2i, l2i, ST2, ST3, 0) {}
  CODE(opc_l2i, l2i, ST3, ST3, 0) {
    asm("addl  $4,%esp");
  }
  CODE(opc_l2i, l2i, ST4, ST1, 0) {}

  /* l2f */
#define L2F_ST0 \
    asm("fildll (%esp)\n\t"\
	"fstps 4(%esp)\n\t"\
	"addl  $4,%esp")

  CODE(opc_l2f, l2f, ST0, ST0, 0) {
    L2F_ST0;
  }
  CODE(opc_l2f, l2f, ST1, ST0, 0) {
    asm("pushl %edx");	/* now state 0 */
    L2F_ST0;
  }
  CODE(opc_l2f, l2f, ST2, ST0, 0) {
    asm("pushl %edx\n\t"
	"pushl %ecx");	/* now state 0 */
    L2F_ST0;
  }
  CODE(opc_l2f, l2f, ST3, ST0, 0) {
    asm("pushl %ecx");	/* now state 0 */
    L2F_ST0;
  }
  CODE(opc_l2f, l2f, ST4, ST0, 0) {
    asm("pushl %ecx\n\t"
	"pushl %edx");	/* now state 0 */
    L2F_ST0;
  }

  /* l2d */
#define L2D_ST0 \
    asm("fildll (%esp)\n\t"\
	"fstpl (%esp)")

  CODE(opc_l2d, l2d, ST0, ST0, 0) {
    L2D_ST0;
  }
  CODE(opc_l2d, l2d, ST1, ST0, 0) {
    asm("pushl %edx");	/* now state 0 */
    L2D_ST0;
  }
  CODE(opc_l2d, l2d, ST2, ST0, 0) {
    asm("pushl %edx\n\t"
	"pushl %ecx");	/* now state 0 */
    L2D_ST0;
  }
  CODE(opc_l2d, l2d, ST3, ST0, 0) {
    asm("pushl %ecx");	/* now state 0 */
    L2D_ST0;
  }
  CODE(opc_l2d, l2d, ST4, ST0, 0) {
    asm("pushl %ecx\n\t"
	"pushl %edx");	/* now state 0 */
    L2D_ST0;
  }

  /* f2i, f2l, d2i, d2l */
#ifdef RUNTIME_DEBUG
#  define REAL2INT_DEBUG1 \
  if (runtime_debug) {\
    DEBUG_IN;\
    asm("subl  $8,%esp\n\t"\
	"fstl  (%esp)");\
    PUSH_CONSTSTR("  %g\n");\
    asm("call  " SYMBOL(printf) "@PLT\n\t"\
	"addl  $12,%esp");\
    DEBUG_OUT;\
  }
#  define REAL2INT_DEBUG2 \
  if (runtime_debug) {\
    DEBUG_IN;\
    asm("pushl $0\n"\
	"fstcw (%esp)");\
    PUSH_CONSTSTR("  FPU cw: 0x%x\n");\
    asm("call " SYMBOL(printf) "@PLT\n\t"\
	"addl  $8,%esp");\
    FFLUSH;\
    DEBUG_OUT;\
  }
#else
#  define REAL2INT_DEBUG1
#  define REAL2INT_DEBUG2
#endif

#define REAL2INT_ST0(FLD, ADJ, FIST) \
    asm(#FLD "  (%esp)");\
    REAL2INT_DEBUG1;\
    asm("subl  $(4+(" #ADJ ")),%esp\n\t"\
	"fstcw (%esp)\n\t"	/* original control word */\
	"ftst\n\t"\
	"movw  (%esp),%ax\n\t"\
	"orw   $(3<<10),%ax\n\t"	/* rounding mode */\
	"movw  %ax,2(%esp)\n\t"\
	"fldcw 2(%esp)\n\t"\
	#FIST " 4(%esp)\n\t"\
	"fldcw (%esp)\n\t"\
	"addl  $4,%esp");\
    REAL2INT_DEBUG2;
	/* now state 0 */

#define REAL2INT_F2I_ST0	REAL2INT_ST0(flds, 0, fistpl)
#define REAL2INT_F2L_ST0	REAL2INT_ST0(flds, 4, fistpll)
#define REAL2INT_D2I_ST0	REAL2INT_ST0(fldl, -4, fistpl)
#define REAL2INT_D2L_ST0	REAL2INT_ST0(fldl, 0, fistpll)

#define REAL2INT_CHECK_INT(VOP, STATE) \
    asm("popl  %edx\n\t"	/* now state 1 */\
	"cmpl  $0x80000000,%edx\n\t"\
	"jne   " #VOP "_st" #STATE "_done\n\t"\
	"fnstsw %ax\n\t"\
	"sahf\n\t"\
	"jp    " #VOP "_st" #STATE "_nan\n\t"	/* jump if not NaN */\
	"adcl  $-1,%edx\n\t"	/* carry flag is set if result < 0 */\
	"jmp   " #VOP "_st" #STATE "_done\n\t"\
      #VOP "_st" #STATE "_nan:\n\t"	/* result is NaN: return 0 */\
	"xorl  %edx,%edx\n\t"\
      #VOP "_st" #STATE "_done:")
	/* now state 1 */

#define REAL2INT_CHECK_LONG(VOP, STATE) \
    asm("popl  %ecx\n\t"	/* ecx = low word */\
	"popl  %edx\n\t"	/* edx = high word */\
		/* now state 2 */\
	/* check if high word is 0x80000000 and low word is 0 */\
	"movl  %edx,%eax\n\t"\
	"xorl  $0x80000000,%eax\n\t"\
	"orl   %ecx,%eax\n\t"\
	"jnz   " #VOP "_st" #STATE "_done\n\t"\
	"fnstsw %ax\n\t"\
	"sahf\n\t"\
	"jp    " #VOP "_st" #STATE "_nan\n\t"	/* jump if not NaN */\
	"adcl  $-1,%ecx\n\t"	/* carry flag is set if result < 0 */\
	"adcl  $-1,%edx\n\t"\
	"jmp   " #VOP "_st" #STATE "_done\n\t"\
      #VOP "_st" #STATE "_nan:\n\t"	/* result is NaN: return 0 */\
	"xorl  %edx,%edx\n\t"\
	"xorl  %ecx,%ecx\n\t"\
      #VOP "_st" #STATE "_done:")
	/* now state 2 */

#define CODE_REAL2INT(vop, VOP, RET_TYPE, LAST_STATE) \
  CODE(opc_##vop, vop, ST0, ST##LAST_STATE, 0) {\
    REAL2INT_##VOP##_ST0;\
    REAL2INT_CHECK_##RET_TYPE(vop, 0);\
  }\
  CODE(opc_##vop, vop, ST1, ST##LAST_STATE, 0) {\
    asm("pushl %edx");	/* now state 0 */\
    REAL2INT_##VOP##_ST0;\
    REAL2INT_CHECK_##RET_TYPE(vop, 1);\
  }\
  CODE(opc_##vop, vop, ST2, ST##LAST_STATE, 0) {\
    asm("pushl %edx\n\t"\
	"pushl %ecx");	/* now state 0 */\
    REAL2INT_##VOP##_ST0;\
    REAL2INT_CHECK_##RET_TYPE(vop, 2);\
  }\
  CODE(opc_##vop, vop, ST3, ST##LAST_STATE, 0) {\
    asm("pushl %ecx");	/* now state 0 */\
    REAL2INT_##VOP##_ST0;\
    REAL2INT_CHECK_##RET_TYPE(vop, 3);\
  }\
  CODE(opc_##vop, vop, ST4, ST##LAST_STATE, 0) {\
    asm("pushl %ecx\n\t"\
	"pushl %edx");	/* now state 0 */\
    REAL2INT_##VOP##_ST0;\
    REAL2INT_CHECK_##RET_TYPE(vop, 4);\
  }

  CODE_REAL2INT(f2i, F2I, INT, 1);
  CODE_REAL2INT(f2l, F2L, LONG, 2);
  CODE_REAL2INT(d2i, D2I, INT, 1);
  CODE_REAL2INT(d2l, D2L, LONG, 2);

  /* f2d */
#define F2D_ST0 \
    asm("flds  (%esp)\n\t"\
	"fstpl -4(%esp)\n\t"\
	"subl  $4,%esp")

  CODE(opc_f2d, f2d, ST0, ST0, 0) {
    F2D_ST0;
  }
  CODE(opc_f2d, f2d, ST1, ST0, 0) {
    asm("pushl %edx");	/* now state 0 */\
    F2D_ST0;
  }
  CODE(opc_f2d, f2d, ST2, ST0, 0) {
    asm("pushl %edx\n\t"\
	"pushl %ecx");	/* now state 0 */\
    F2D_ST0;
  }
  CODE(opc_f2d, f2d, ST3, ST0, 0) {
    asm("pushl %ecx");	/* now state 0 */\
    F2D_ST0;
  }
  CODE(opc_f2d, f2d, ST4, ST0, 0) {
    asm("pushl %ecx\n\t"\
	"pushl %edx");	/* now state 0 */\
    F2D_ST0;
  }

  /* d2f */
#define D2F_ST0 \
    asm("fldl  (%esp)\n\t"\
	"fstps 4(%esp)\n\t"\
	"addl  $4,%esp")

  CODE(opc_d2f, d2f, ST0, ST0, 0) {
    D2F_ST0;
  }
  CODE(opc_d2f, d2f, ST1, ST0, 0) {
    asm("pushl %edx");	/* now state 0 */\
    D2F_ST0;
  }
  CODE(opc_d2f, d2f, ST2, ST0, 0) {
    asm("pushl %edx\n\t"\
	"pushl %ecx");	/* now state 0 */\
    D2F_ST0;
  }
  CODE(opc_d2f, d2f, ST3, ST0, 0) {
    asm("pushl %ecx");	/* now state 0 */\
    D2F_ST0;
  }
  CODE(opc_d2f, d2f, ST4, ST0, 0) {
    asm("pushl %ecx\n\t"\
	"pushl %edx");	/* now state 0 */\
    D2F_ST0;
  }

  /* i2b, i2c, i2s */
#define I2B(REG) \
    asm("shl  $24," #REG "\n\t"\
	"sar  $24," #REG)
#define I2C(REG) \
    asm("shl  $16," #REG "\n\t"\
	"shr  $16," #REG)
#define I2S(REG) \
    asm("shl  $16," #REG "\n\t"\
	"sar  $16," #REG)

#define CODE_I2BCS(vop, VOP) \
  CODE(opc_##vop, vop, ST0, ST1, 0) {\
    asm("popl  %edx");	/* now state 1 */\
    VOP(%edx);\
  }\
  CODE(opc_##vop, vop, ST1, ST1, 0) {\
    VOP(%edx);\
  }\
  CODE(opc_##vop, vop, ST2, ST2, 0) {\
    VOP(%ecx);\
  }\
  CODE(opc_##vop, vop, ST3, ST3, 0) {\
    VOP(%ecx);\
  }\
  CODE(opc_##vop, vop, ST4, ST4, 0) {\
    VOP(%edx);\
  }

  CODE_I2BCS(i2b, I2B);
  CODE_I2BCS(i2c, I2C);
  CODE_I2BCS(i2s, I2S);

  /* lcmp */
#define LCMP_ST24(OPTOP1_REG, OPTOP2_REG, STATE) \
    asm("popl  %eax\n\t"	/* eax = v1[0:31] */\
	"popl  %edi");	/* edi = v1[32:63] */\
    ARITH_LONG_DEBUG1(%eax, %edi, OPTOP1_REG, OPTOP2_REG, "");\
    asm("cmpl  " #OPTOP2_REG ",%edi\n\t"	/* cmp v1[32:63] - v2[32:63]*/\
	"jl    lcmp_st" #STATE "_lt\n\t"\
	"jg    lcmp_st" #STATE "_ge\n\t"\
	"cmpl  " #OPTOP1_REG ",%eax\n\t"	/* cmp v1[0:31] - v2[0:31] */\
	"jb    lcmp_st" #STATE "_lt\n\t"\
      "lcmp_st" #STATE "_ge:\n\t"\
	"movl  $0,%edx\n\t"\
	"setnz %dl\n\t"\
	"jmp   lcmp_st" #STATE "_done\n\t"\
      "lcmp_st" #STATE "_lt:\n\t"\
	"movl  $-1,%edx\n\t"\
      "lcmp_st" #STATE "_done:")
	/* now state 1 */

  CODE(opc_lcmp, lcmp, ST0, ST1, 0) {
    asm("popl  %ecx\n\t"
	"popl  %edx");	/* now state 2 */
    LCMP_ST24(%ecx, %edx, 0);
  }
  CODE(opc_lcmp, lcmp, ST1, ST1, 0) {
    asm("popl  %ecx");	/* now state 4 */
    LCMP_ST24(%edx, %ecx, 1);
  }
  CODE(opc_lcmp, lcmp, ST2, ST1, 0) {
    LCMP_ST24(%ecx, %edx, 2);
  }
  CODE(opc_lcmp, lcmp, ST3, ST1, 0) {
    asm("popl  %edx");	/* now state 2 */
    LCMP_ST24(%ecx, %edx, 3);
  }
  CODE(opc_lcmp, lcmp, ST4, ST1, 0) {
    LCMP_ST24(%edx, %ecx, 4);
  }

  /* fcmpl, fcmpg, dcmpl, dcmpg */
#ifdef RUNTIME_DEBUG
#  define FCMP_DEBUG1 \
  if (runtime_debug) {\
    asm("flds  4(%esp)\n\t"\
	"flds  (%esp)");\
    DEBUG_IN;\
    asm("subl  $16,%esp\n\t"\
	"fstpl 8(%esp)\n\t"\
	"fstpl (%esp)");\
    PUSH_CONSTSTR("  %g %g\n");\
    asm("call  " SYMBOL(printf) "@PLT\n\t"\
	"addl  $20,%esp");\
    FFLUSH;\
    DEBUG_OUT;\
  }
#  define DCMP_DEBUG1 \
  if (runtime_debug) {\
    asm("movl  (%esp),%edi\n\t"\
	"movl  4(%esp),%eax\n\t"\
	"movl  8(%esp),%ecx\n\t"\
	"movl  12(%esp),%edx");\
    DEBUG_IN;\
    asm("pushl %eax\n\tpushl %edi\n\t"\
	"pushl %edx\n\tpushl %ecx");\
    PUSH_CONSTSTR("  %g %g\n");\
    asm("call  " SYMBOL(printf) "@PLT\n\t"\
	"addl  $20,%esp");\
    FFLUSH;\
    DEBUG_OUT;\
  }
#else
#  define FCMP_DEBUG1
#  define DCMP_DEBUG1
#endif

#define FCMPL_COMPARE_ST0 \
    FCMP_DEBUG1;\
    asm("flds  4(%esp)\n\t"\
	"fcomps (%esp)\n\t"\
	"addl  $8,%esp")
#define FCMPG_COMPARE_ST0	FCMPL_COMPARE_ST0

#define DCMPL_COMPARE_ST0 \
    DCMP_DEBUG1;\
    asm("fldl  8(%esp)\n\t"\
	"fcompl (%esp)\n\t"\
	"addl  $16,%esp")
#define DCMPG_COMPARE_ST0	DCMPL_COMPARE_ST0

#define FLOAT_CMP_NAN_g(LABEL) \
	"jnp  " LABEL "_normal\n\t"/* PF indicates NaN */\
	"movl  $1,%edx\n\t"\
	"jmp  " LABEL "_done\n\t"
#define FLOAT_CMP_NAN_l(LABEL) \
	"jp   " LABEL "_l\n\t"	/* PF indicates NaN */

#define FLOAT_CMP_ST0(SUF, LABEL) \
    asm("fnstsw %ax\n\t"\
	"sahf\n\t"\
	FLOAT_CMP_NAN_##SUF(LABEL)\
      LABEL "_normal:\n\t"\
	"jc    " LABEL "_l\n\t"\
      LABEL "_g:\n\t"\
	"movl  $0,%edx\n\t"\
	"setnz %dl\n\t"\
	"jmp   " LABEL "_done\n\t"\
      LABEL "_l:\n\t"\
	"movl  $-1,%edx\n\t"\
      LABEL "_done:")
	/* now state 1 */

#define CODE_FLOAT_CMP(vop, VOP, SUF) \
  CODE(opc_##vop, vop, ST0, ST1, 0) {\
    VOP##_COMPARE_ST0;\
    FLOAT_CMP_ST0(SUF, #VOP "_st0");\
  }\
  CODE(opc_##vop, vop, ST1, ST1, 0) {\
    asm("pushl %edx");	/* now state 0 */\
    VOP##_COMPARE_ST0;\
    FLOAT_CMP_ST0(SUF, #VOP "_st1");\
  }\
  CODE(opc_##vop, vop, ST2, ST1, 0) {\
    asm("pushl %edx\n\t"\
	"pushl %ecx");	/* now state 0 */\
    VOP##_COMPARE_ST0;\
    FLOAT_CMP_ST0(SUF, #VOP "_st2");\
  }\
  CODE(opc_##vop, vop, ST3, ST1, 0) {\
    asm("pushl %ecx");	/* now state 0 */\
    VOP##_COMPARE_ST0;\
    FLOAT_CMP_ST0(SUF, #VOP "_st3");\
  }\
  CODE(opc_##vop, vop, ST4, ST1, 0) {\
    asm("pushl %ecx\n\t"\
	"pushl %edx");	/* now state 0 */\
    VOP##_COMPARE_ST0;\
    FLOAT_CMP_ST0(SUF, #VOP "_st4");\
  }

  CODE_FLOAT_CMP(fcmpl, FCMPL, l);
  CODE_FLOAT_CMP(fcmpg, FCMPG, g);
  CODE_FLOAT_CMP(dcmpl, DCMPL, l);
  CODE_FLOAT_CMP(dcmpg, DCMPG, g);

  /* ifeq, ifne, iflt, ifge, ifgt, ifle */
#ifdef RUNTIME_DEBUG
#  define IF_DEBUG1(OPTOP1_REG) \
  if (runtime_debug) {\
    DEBUG_IN;\
    asm("pushl " #OPTOP1_REG);\
    PUSH_CONSTSTR("  %d\n");\
    asm("call  " SYMBOL(printf) "@PLT\n\t"\
	"addl  $8,%esp");\
    FFLUSH;\
    DEBUG_OUT;\
  }
#else
#  define IF_DEBUG1(OPTOP1_REG)
#endif

#define IF(OPTOP1_REG, JP_ROP) \
    IF_DEBUG1(OPTOP1_REG);\
    asm("testl " #OPTOP1_REG "," #OPTOP1_REG)
    /* jump: #JP_ROP STR(ADDR_JP) */

#define CODE_IF(VOP, JP_ROP) \
  CODE(opc_if##VOP, if##VOP, ST0, ST0, 0) {\
    asm("popl  %eax");\
    IF(%eax, JP_ROP);\
  }\
  CODE(opc_if##VOP, if##VOP, ST1, ST0, 0) {\
    IF(%edx, JP_ROP);\
  }\
  CODE(opc_if##VOP, if##VOP, ST2, ST1, 0) {\
    IF(%ecx, JP_ROP);\
  }\
  CODE(opc_if##VOP, if##VOP, ST3, ST0, 0) {\
    IF(%ecx, JP_ROP);\
  }\
  CODE(opc_if##VOP, if##VOP, ST4, ST3, 0) {\
    IF(%edx, JP_ROP);\
  }

  CODE_IF(eq, je);
  CODE_IF(ne, jne);
  CODE_IF(lt, jl);
  CODE_IF(ge, jge);
  CODE_IF(gt, jg);
  CODE_IF(le, jle);

  /* if_icmp{eq,ne,lt,ge,gt,le} */
#ifdef RUNTIME_DEBUG
#  define IF_ICMP_DEBUG(OPTOP1_REG, OPTOP2_REG) \
  if (runtime_debug) {\
    DEBUG_IN;\
    asm("pushl " #OPTOP1_REG "\n\t"\
	"pushl " #OPTOP2_REG);\
    PUSH_CONSTSTR("  %d %d\n");\
    asm("call  " SYMBOL(printf) "@PLT\n\t"\
	"addl  $12,%esp");\
    FFLUSH;\
    DEBUG_OUT;\
  }
#else
#  define IF_ICMP_DEBUG(OPTOP1_REG, OPTOP2_REG)
#endif

#define IF_ICMP_ST24(OPTOP1_REG, OPTOP2_REG, JP_ROP) \
    IF_ICMP_DEBUG(OPTOP1_REG, OPTOP2_REG);\
    asm("cmpl  " #OPTOP1_REG "," #OPTOP2_REG)
    /* jump: #JP_ROP STR(ADDR_JP) */
	/* now state 0 */

#define CODE_IF_ICMP(VOP, JP_ROP) \
  CODE(opc_if_icmp##VOP, if_icmp##VOP, ST0, ST0, 0) {\
    asm("popl  %ecx\n\t"\
	"popl  %edx");	/* now state 2 */\
    IF_ICMP_ST24(%ecx, %edx, JP_ROP);\
  }\
  CODE(opc_if_icmp##VOP, if_icmp##VOP, ST1, ST0, 0) {\
    asm("popl  %ecx");	/* now state 4 */\
    IF_ICMP_ST24(%edx, %ecx, JP_ROP);\
  }\
  CODE(opc_if_icmp##VOP, if_icmp##VOP, ST2, ST0, 0) {\
    IF_ICMP_ST24(%ecx, %edx, JP_ROP);\
  }\
  CODE(opc_if_icmp##VOP, if_icmp##VOP, ST3, ST0, 0) {\
    asm("popl  %edx");	/* now state 2 */\
    IF_ICMP_ST24(%ecx, %edx, JP_ROP);\
  }\
  CODE(opc_if_icmp##VOP, if_icmp##VOP, ST4, ST0, 0) {\
    IF_ICMP_ST24(%edx, %ecx, JP_ROP);\
  }

  CODE_IF_ICMP(eq, je);
  CODE_IF_ICMP(ne, jne);
  CODE_IF_ICMP(lt, jl);
  CODE_IF_ICMP(ge, jge);
  CODE_IF_ICMP(gt, jg);
  CODE_IF_ICMP(le, jle);

  /* goto */
  CODE(opc_goto, goto, STANY, STSTA, 0) {
    /* jump: "jmp   " STR(ADDR_JP) */
  }

  /* jsr */
	/* const: native offset of a next instruction */
#ifdef RUNTIME_DEBUG
#  define JSR_DEBUG1(REG) \
  if (runtime_debug) {\
    DEBUG_IN;\
    asm("pushl " #REG);\
    PUSH_CONSTSTR("  push 0x%08x\n");\
    asm("call  " SYMBOL(printf) "@PLT\n\t"\
	"addl  $8,%esp");\
    FFLUSH;\
    DEBUG_OUT;\
  }
#else
#  define JSR_DEBUG1(REG)
#endif

#define JSR(REG) \
    asm("movl  $" STR(CONST) "," #REG);\
    JSR_DEBUG1(REG)
    /* jump: "jmp  " STR(ADDR_JP) */

  CODE(opc_jsr, jsr, ST0, ST1, 0) {
    JSR(%edx);
  }
  CODE(opc_jsr, jsr, ST1, ST2, 0) {
    JSR(%ecx);
  }
  CODE(opc_jsr, jsr, ST2, ST4, 0) {
    asm("pushl %edx");	/* now state 3 */
    JSR(%edx);
  }
  CODE(opc_jsr, jsr, ST3, ST4, 0) {
    JSR(%edx);
  }
  CODE(opc_jsr, jsr, ST4, ST2, 0) {
    asm("pushl %ecx");	/* now state 1 */
    JSR(%ecx);
  }

  /* ret */
	/* const: index * 4 */
  CODE(opc_ret, ret, STANY, STSTA, 0) {
    asm("movl " STR(CONST) "(%esi),%eax");	/* eax = vars[index] */
    ILOAD_DEBUG1(%eax);
    COMPILEDCODE(%edi);	/* edi = mb->CompiledCode */
    asm("addl  %edi,%eax");
    /* jump: "jmp   *%eax" */
  }

  /* tableswitch */
	/* const: low, high, table offset (in native) */
  /*
   * table:  Each element is 8 byte.
   *  An element consists of an offset of target in native code
   *  and a pointer to trampoline code.
   *	default, offset(low), offset(low+1), ..., offset(high)
   */
#ifdef RUNTIME_DEBUG
#  define TBLSW_DEBUG1(INDEX) \
  if (runtime_debug) {\
    DEBUG_IN;\
    asm("pushl %eax\n\tpushl %edi\n\tpushl " #INDEX);\
    PUSH_CONSTSTR("  index: %d [%d:%d]\n");\
    asm("call  " SYMBOL(printf) "@PLT\n\t"\
	"addl  $16,%esp");\
    DEBUG_OUT;\
  }
#  define TBLSW_DEBUG2(OFF) \
  if (runtime_debug) {\
    DEBUG_IN;\
    asm("pushl " #OFF "\n\tpushl " #OFF);\
    PUSH_CONSTSTR("  native off: 0x%08x(%d)\n");\
    asm("call  " SYMBOL(printf) "@PLT\n\t"\
	"addl  $12,%esp");\
    FFLUSH;\
    DEBUG_OUT;\
  }
#else
#  define TBLSW_DEBUG1(INDEX)
#  define TBLSW_DEBUG2(OFF)
#endif

#define TBLSW(INDEX, STATE) \
    asm("movl  $" STR(CONST) ",%edi\n\t"	/* low */\
	"movl  $" STR(CONST) ",%eax");	/* high */\
    TBLSW_DEBUG1(INDEX);\
    asm("subl  %edi," #INDEX "\n\t"		/* index -= low */\
	"subl  %edi,%eax");			/* high -= low */\
    \
    COMPILEDCODE(%edi);				/* edi = mb->CompiledCode */\
    asm("pushl %edi");	/* push mb->CompiledCode */\
    \
    asm("addl  $" STR(CONST) ",%edi"); /* edi += offset of the table */\
		/* edi = addr. of the table */\
    asm("cmpl  " #INDEX ",%eax\n\t"		/* test high - index */\
	"jb    tblsw_st" #STATE "_default\n\t"\
	"leal  8(%edi," #INDEX ",8),%edi\n\t"	/* edi = tgt offset */\
      "tblsw_st" #STATE "_default:\n\t"\
	"movl  (%edi),%eax");\
    TBLSW_DEBUG2(%eax);\
    \
    asm("addl  (%esp),%eax\n\t"	/* eax += mb->CompiledCode */\
	"addl  $4,%esp");\
		/* eax = target address */\
    \
    asm("jmp   *4(%edi)")

  CODE(opc_tableswitch, tableswitch, ST0, ST0, 0) {
    asm("popl  %edx");	/* now state 1 */
    TBLSW(%edx, 0);
  }
  CODE(opc_tableswitch, tableswitch, ST1, ST0, 0) {
    TBLSW(%edx, 1);
  }
  CODE(opc_tableswitch, tableswitch, ST2, ST1, 0) {
    TBLSW(%ecx, 2);
  }
  CODE(opc_tableswitch, tableswitch, ST3, ST0, 0) {
    TBLSW(%ecx, 3);
  }
  CODE(opc_tableswitch, tableswitch, ST4, ST3, 0) {
    TBLSW(%edx, 4);
  }

  /* lookupswitch */
	/* const: npairs, table offset (in native) */
  /*
   * table:  Each element is 12 byte.
   *  An element consists of a key, an offset of target in native code
   *  and a pointer to trampoline code.
   *
   *	element(1), element(2), ..., element(npairs), element(default)
   */
#ifdef RUNTIME_DEBUG
#  define LUSW_DEBUG1(KEY) \
  if (runtime_debug) {\
    DEBUG_IN;\
    asm("pushl %eax\n\tpushl " #KEY);\
    PUSH_CONSTSTR("  key: %d, npairs: %d\n");\
    asm("call  " SYMBOL(printf) "@PLT\n\t"\
	"addl  $12,%esp");\
    DEBUG_OUT;\
  }
#  define LUSW_DEBUG2 \
  if (runtime_debug) {\
    DEBUG_IN;\
    asm("pushl 8(%edi)\n\t"\
	"pushl 4(%edi)\n\tpushl 4(%edi)\n\t"\
	"pushl (%edi)");\
    PUSH_CONSTSTR("  match: %d, target offset: 0x%08x(%d), trampoline code: 0x%08x\n");\
    asm("call  " SYMBOL(printf) "@PLT\n\t"\
	"addl  $20,%esp");\
    FFLUSH;\
    DEBUG_OUT;\
  }
#else
#  define LUSW_DEBUG1(KEY)
#  define LUSW_DEBUG2
#endif

#define LUSW(KEY, STATE) \
    COMPILEDCODE(%edi);\
    asm("pushl %edi");	/* push mb->CompiledCode */\
    \
    asm("movl  $" STR(CONST) ",%eax");	/* npairs */\
    asm("addl  $" STR(CONST) ",%edi");	/* offset of the table */\
		/* edi = addr. of the table */\
    LUSW_DEBUG1(KEY);\
    asm(\
      "lusw_st" #STATE "_loop:\n\t"\
	"cmpl  (%edi)," #KEY "\n\t"\
	"je    lusw_st" #STATE "_loopend\n\t"\
	"addl  $12,%edi\n\t"\
	"decl  %eax\n\t"\
	"jnz   lusw_st" #STATE "_loop\n\t"\
      "lusw_st" #STATE "_loopend:");\
    LUSW_DEBUG2;\
    asm("movl  4(%edi),%eax");\
    \
    asm("addl  (%esp),%eax\n\t"	/* eax += mb->CompiledCode */\
	"addl  $4,%esp");\
		/* eax = tgt addr. */\
    \
    asm("jmp   *8(%edi)")


  CODE(opc_lookupswitch, lookupswitch, ST0, ST0, 0) {
    asm("popl  %edx");	/* now state 1 */
    LUSW(%edx, 0);
  }
  CODE(opc_lookupswitch, lookupswitch, ST1, ST0, 0) {
    LUSW(%edx, 1);
  }
  CODE(opc_lookupswitch, lookupswitch, ST2, ST1, 0) {
    LUSW(%ecx, 2);
  }
  CODE(opc_lookupswitch, lookupswitch, ST3, ST0, 0) {
    LUSW(%ecx, 3);
  }
  CODE(opc_lookupswitch, lookupswitch, ST4, ST3, 0) {
    LUSW(%edx, 4);
  }

  /* ireturn */
#define IRETURN(OPTOP1_REG) \
    /* (ee->current_frame->prev->optop++)[0] = OPTOP1_REG */\
    {\
      register ExecEnv *cur_ee asm("eax");\
      cur_ee = ee;\
    }\
    asm("movl  " EE_CURRENTFRAME(%eax) ",%edi\n\t"\
	"movl  " FRAME_PREV(%edi) ",%eax\n\t"\
	"movl  " FRAME_OPTOP(%eax) ",%edi\n\t"\
	"movl  " #OPTOP1_REG ",(%edi)\n\t"\
	"addl  $4," FRAME_OPTOP(%eax));\
    BIPUSH_DEBUG1(OPTOP1_REG);\
    asm("jmp   " STR(ADDR_FIN))

  CODE(opc_ireturn, [ifa]return, ST0, ST0, 0) {
    asm("popl  %edx");	/* now state 1 */
    IRETURN(%edx);
  }
  CODE(opc_ireturn, [ifa]return, ST1, ST0, 0) {
    IRETURN(%edx);
  }
  CODE(opc_ireturn, [ifa]return, ST2, ST1, 0) {
    IRETURN(%ecx);
  }
  CODE(opc_ireturn, [ifa]return, ST3, ST0, 0) {
    IRETURN(%ecx);
  }
  CODE(opc_ireturn, [ifa]return, ST4, ST3, 0) {
    IRETURN(%edx);
  }

  /* lreturn */
#define LRETURN(OPTOP1_REG, OPTOP2_REG) \
    /* (ee->current_frame->prev->optop++)[0] = OPTOP1_REG\
       (ee->current_frame->prev->optop++)[1] = OPTOP2_REG */\
    {\
      register ExecEnv *cur_ee asm("eax");\
      cur_ee = ee;\
    }\
    asm("movl  " EE_CURRENTFRAME(%eax) ",%edi\n\t"\
	"movl  " FRAME_PREV(%edi) ",%eax\n\t"\
	"movl  " FRAME_OPTOP(%eax) ",%edi\n\t"\
	"movl  " #OPTOP1_REG ",(%edi)\n\t"\
	"movl  " #OPTOP2_REG ",4(%edi)\n\t"\
	"addl  $8," FRAME_OPTOP(%eax));\
    LDC2_W_DEBUG1(OPTOP1_REG, OPTOP2_REG);\
    asm("jmp   " STR(ADDR_FIN))

  CODE(opc_lreturn, [ld]return, ST0, ST0, 0) {
    asm("popl  %ecx\n\t"
	"popl  %edx");	/* now state 2 */
    LRETURN(%ecx, %edx);
  }
  CODE(opc_lreturn, [ld]return, ST1, ST0, 0) {
    asm("popl  %ecx");	/* now state 4 */
    LRETURN(%edx, %ecx);
  }
  CODE(opc_lreturn, [ld]return, ST2, ST0, 0) {
    LRETURN(%ecx, %edx);
  }
  CODE(opc_lreturn, [ld]return, ST3, ST0, 0) {
    asm("popl  %edx");	/* now state 2 */
    LRETURN(%ecx, %edx);
  }
  CODE(opc_lreturn, [ld]return, ST4, ST0, 0) {
    LRETURN(%edx, %ecx);
  }

  /* return */
  CODE(opc_return, return, STANY, STSTA, 0) {
    asm("jmp   " STR(ADDR_FIN));
  }

  /* getstatic */
	/* const: address */
/* stuff to rewrite code for opc_{get,put}static */
#define GETSTATIC_REWRITE_OFFSET	"0x26"

#if defined(INITCLASS_IN_COMPILING) || defined(NO_REWRITE)
#  define INITCLASS_GETSTATIC(LABEL)
#else
#  define INITCLASS_GETSTATIC(LABEL) \
  asm("movl  $" STR(CONST) ",%edi");	/* edi = cb */\
/*asm("nop\n\tnop\n\tnop\n\tnop");*/\
  asm("jmp   " LABEL "_call_initclass\n\t"\
      "jmp   " LABEL "_initclass_done\n\t"\
   LABEL "_call_initclass:");\
  asm("pushl %edx\n\tpushl %ecx");	/* save */\
  {\
    register ClassClass *cb asm("edi");\
    if (!CB_INITIALIZED(cb)) {\
      FUNCCALL_IN_0;\
      InitClass(cb);\
      FUNCCALL_OUT_0;\
    }\
  }\
  asm("popl  %ecx\n\tpopl  %edx");	/* restore */\
  \
  /* rewrite */\
  asm("call  0\n\t"\
      "popl  %edi");\
/*asm("nop\n\tnop\n\tnop\n\tnop");*/\
  asm("subl  $" GETSTATIC_REWRITE_OFFSET ",%edi\n\t"\
      "movb  $0x90,(%edi)\n\t"\
      "movb  $0x90,1(%edi)");\
  asm(LABEL "_initclass_done:")
#endif	/* INITCLASS_IN_COMPILING || NO_REWRITE */

  CODE(opc_getstatic, getstatic, ST0, ST1, 0) {
    INITCLASS_GETSTATIC("getstatic_st0");
    asm("movl  (" STR(CONST) "),%edx");
    BIPUSH_DEBUG1(%edx);
  }
  CODE(opc_getstatic, getstatic, ST1, ST2, 0) {
    INITCLASS_GETSTATIC("getstatic_st1");
    asm("movl  (" STR(CONST) "),%ecx");
    BIPUSH_DEBUG1(%ecx);
  }
  CODE(opc_getstatic, getstatic, ST2, ST4, 0) {
    INITCLASS_GETSTATIC("getstatic_st2");
    asm("pushl %edx\n\t"	/* now state 3 */
	"movl  (" STR(CONST) "),%edx");
    BIPUSH_DEBUG1(%edx);
  }
  CODE(opc_getstatic, getstatic, ST3, ST4, 0) {
    INITCLASS_GETSTATIC("getstatic_st3");
    asm("movl  (" STR(CONST) "),%edx");
    BIPUSH_DEBUG1(%edx);
  }
  CODE(opc_getstatic, getstatic, ST4, ST2, 0) {
    INITCLASS_GETSTATIC("getstatic_st4");
    asm("pushl %ecx\n\t"	/* now state 1 */
	"movl  (" STR(CONST) "),%ecx");
    BIPUSH_DEBUG1(%ecx);
  }

	/* const: address, address + 4 */
#define GETSTATIC2_ST0(LOW_REG, HIGH_REG) \
    asm("movl  (" STR(CONST) ")," #LOW_REG "\n\t"\
	"movl  (" STR(CONST) ")," #HIGH_REG)
  CODE(opc_getstatic2, getstatic2, ST0, ST2, 0) {
    INITCLASS_GETSTATIC("getstatic2_st0");
    GETSTATIC2_ST0(%ecx, %edx);
  }
  CODE(opc_getstatic2, getstatic2, ST1, ST2, 0) {
    asm("pushl %edx");	/* now state 0 */
    INITCLASS_GETSTATIC("getstatic2_st1");
    GETSTATIC2_ST0(%ecx, %edx);
  }
  CODE(opc_getstatic2, getstatic2, ST2, ST4, 0) {
    asm("pushl %edx\n\t"\
	"pushl %ecx");	/* now state 0 */\
    INITCLASS_GETSTATIC("getstatic2_st2");
    GETSTATIC2_ST0(%edx, %ecx);
  }
  CODE(opc_getstatic2, getstatic2, ST3, ST4, 0) {
    asm("pushl %ecx");	/* now state 0 */\
    INITCLASS_GETSTATIC("getstatic2_st3");
    GETSTATIC2_ST0(%edx, %ecx);
  }
  CODE(opc_getstatic2, getstatic2, ST4, ST2, 0) {
    asm("pushl %ecx\n\t"\
	"pushl %edx");	/* now state 0 */\
    INITCLASS_GETSTATIC("getstatic2_st4");
    GETSTATIC2_ST0(%ecx, %edx);
  }

  /* putstatic */
	/* const: address */
  CODE(opc_putstatic, putstatic, ST0, ST0, 0) {
    INITCLASS_GETSTATIC("putstatic_st0");
    asm("popl  %edx\n\t"	/* now state 1 */
	"movl  %edx,(" STR(CONST) ")");
    BIPUSH_DEBUG1(%edx);
  }
  CODE(opc_putstatic, putstatic, ST1, ST0, 0) {
    INITCLASS_GETSTATIC("putstatic_st1");
    asm("movl  %edx,(" STR(CONST) ")");
    BIPUSH_DEBUG1(%edx);
  }
  CODE(opc_putstatic, putstatic, ST2, ST1, 0) {
    INITCLASS_GETSTATIC("putstatic_st2");
    asm("movl  %ecx,(" STR(CONST) ")");
    BIPUSH_DEBUG1(%ecx);
  }
  CODE(opc_putstatic, putstatic, ST3, ST0, 0) {
    INITCLASS_GETSTATIC("putstatic_st3");
    asm("movl  %ecx,(" STR(CONST) ")");
    BIPUSH_DEBUG1(%ecx);
  }
  CODE(opc_putstatic, putstatic, ST4, ST3, 0) {
    INITCLASS_GETSTATIC("putstatic_st4");
    asm("movl  %edx,(" STR(CONST) ")");
    BIPUSH_DEBUG1(%edx);
  }

	/* const: address, address + 4 */
#define PUTSTATIC2(OPTOP1_REG, OPTOP2_REG) \
    asm("movl  " #OPTOP1_REG ",(" STR(CONST) ")\n\t"\
	"movl  " #OPTOP2_REG ",(" STR(CONST) ")")
	/* now state 0 */
  
  CODE(opc_putstatic2, putstatic2, ST0, ST0, 0) {
    INITCLASS_GETSTATIC("putstatic2_st0");
    asm("popl  %ecx\n\t"
	"popl  %edx");	/* now state 2 */
    PUTSTATIC2(%ecx, %edx);
  }
  CODE(opc_putstatic2, putstatic2, ST1, ST0, 0) {
    INITCLASS_GETSTATIC("putstatic2_st1");
    asm("popl  %ecx");	/* now state 4 */
    PUTSTATIC2(%edx, %ecx);
  }
  CODE(opc_putstatic2, putstatic2, ST2, ST0, 0) {
    INITCLASS_GETSTATIC("putstatic2_st2");
    PUTSTATIC2(%ecx, %edx);
  }
  CODE(opc_putstatic2, putstatic2, ST3, ST0, 0) {
    INITCLASS_GETSTATIC("putstatic2_st3");
    asm("popl  %edx");	/* now state 2 */
    PUTSTATIC2(%ecx, %edx);
  }
  CODE(opc_putstatic2, putstatic2, ST4, ST0, 0) {
    INITCLASS_GETSTATIC("putstatic2_st4");
    PUTSTATIC2(%edx, %ecx);
  }

  /* getfield */
	/* const: slot */
#ifndef NO_CHECK
#  define FIELD_ACC(HANDLE, VOP, STATE) \
    asm("movl  $" STR(CONST) ",%eax");\
	/* slot: fb->u.offset / sizeof(OBJECT) */\
    NULL_TEST(HANDLE, #VOP "_st" #STATE "_1", STATE)
#else
#  define FIELD_ACC(HANDLE, VOP, STATE) \
    asm("movl  $" STR(CONST) ",%eax")
	/* fb->u.offset / sizeof(OBJECT) */
#endif	/* NO_CHECK */
	/* eax = index */

  CODE(opc_getfield, getfield, ST0, ST3, 1) {
    asm("popl  %edx");	/* now state 1 */
    FIELD_ACC(%edx, getfield, 0);
    METAVM_GETFIELD(%edx, %eax, %ecx, "getfield_st0", 0);
    OBJ_GETSLOT(%edx, %eax, %ecx);
    asm("getfield_st0_done:");
    ILOAD_DEBUG1(%ecx);
  }
  CODE(opc_getfield, getfield, ST1, ST3, 1) {
    FIELD_ACC(%edx, getfield, 1);
    METAVM_GETFIELD(%edx, %eax, %ecx, "getfield_st1", 0);
    OBJ_GETSLOT(%edx, %eax, %ecx);
    asm("getfield_st1_done:");
    ILOAD_DEBUG1(%ecx);
  }
  CODE(opc_getfield, getfield, ST2, ST2, 1) {
    FIELD_ACC(%ecx, getfield, 2);
    METAVM_GETFIELD(%ecx, %eax, %ecx, "getfield_st2", 1);
    OBJ_GETSLOT(%ecx, %eax, %ecx);
    asm("getfield_st2_done:");
    ILOAD_DEBUG1(%ecx);
  }
  CODE(opc_getfield, getfield, ST3, ST1, 1) {
    FIELD_ACC(%ecx, getfield, 3);
    METAVM_GETFIELD(%ecx, %eax, %edx, "getfield_st3", 0);
    OBJ_GETSLOT(%ecx, %eax, %edx);
    asm("getfield_st3_done:");
    ILOAD_DEBUG1(%edx);
  }
  CODE(opc_getfield, getfield, ST4, ST4, 1) {
    FIELD_ACC(%edx, getfield, 4);
    METAVM_GETFIELD(%edx, %eax, %edx, "getfield_st4", 3);
    OBJ_GETSLOT(%edx, %eax, %edx);
    asm("getfield_st4_done:");
    ILOAD_DEBUG1(%edx);
  }

	/* const: slot */
  CODE(opc_getfield2, getfield2, ST0, ST2, 1) {
    asm("popl  %edx");	/* now state 1 */
    FIELD_ACC(%edx, getfield2, 0);
    METAVM_GETFIELD2(%edx, %eax, %ecx, %edx, "getfield2_st0", 1);
    OBJ_GETSLOT2(%edx, %eax, %ecx, %edx);
    asm("getfield2_st0_done:");
    LLOAD_DEBUG1(%ecx, %edx);
  }
  CODE(opc_getfield2, getfield2, ST1, ST2, 1) {
    FIELD_ACC(%edx, getfield2, 1);
    METAVM_GETFIELD2(%edx, %eax, %ecx, %edx, "getfield2_st1", 2);
    OBJ_GETSLOT2(%edx, %eax, %ecx, %edx);
    asm("getfield2_st1_done:");
    LLOAD_DEBUG1(%ecx, %edx);
  }
  CODE(opc_getfield2, getfield2, ST2, ST4, 1) {
    asm("pushl %edx");	/* now state 3 */
    FIELD_ACC(%ecx, getfield2, 2);
    METAVM_GETFIELD2(%ecx, %eax, %edx, %ecx, "getfield2_st2", 2);
    OBJ_GETSLOT2(%ecx, %eax, %edx, %ecx);
    asm("getfield2_st2_done:");
    LLOAD_DEBUG1(%edx, %ecx);
  }
  CODE(opc_getfield2, getfield2, ST3, ST4, 1) {
    FIELD_ACC(%ecx, getfield2, 3);
    METAVM_GETFIELD2(%ecx, %eax, %edx, %ecx, "getfield2_st3", 3);
    OBJ_GETSLOT2(%ecx, %eax, %edx, %ecx);
    asm("getfield2_st3_done:");
    LLOAD_DEBUG1(%edx, %ecx);
  }
  CODE(opc_getfield2, getfield2, ST4, ST2, 1) {
    asm("pushl  %ecx");	/* now state 1 */
    FIELD_ACC(%edx, getfield2, 4);
    METAVM_GETFIELD2(%edx, %eax, %ecx, %edx, "getfield2_st4", 4);
    OBJ_GETSLOT2(%edx, %eax, %ecx, %edx);
    asm("getfield2_st4_done:");
    LLOAD_DEBUG1(%ecx, %edx);
  }

  /* putfield */
	/* const: slot */
#define PUTFIELD_ST24(OPTOP1_REG, OPTOP2_REG, STATE) \
    FIELD_ACC(OPTOP2_REG, putfield, STATE);\
    METAVM_PUTFIELD(OPTOP2_REG, %eax, OPTOP1_REG, "putfield_st" #STATE, STATE);\
    OBJ_SETSLOT(OPTOP2_REG, %eax, OPTOP1_REG);\
    asm("putfield_st" #STATE "_done:")

  CODE(opc_putfield, putfield, ST0, ST0, 1) {
    asm("popl  %ecx\n\t"
	"popl  %edx");	/* now state 2 */
    PUTFIELD_ST24(%ecx, %edx, 0);
    ILOAD_DEBUG1(%ecx);
  }
  CODE(opc_putfield, putfield, ST1, ST0, 1) {
    asm("popl  %ecx");	/* now state 4 */
    PUTFIELD_ST24(%edx, %ecx, 1);
    ILOAD_DEBUG1(%edx);
  }
  CODE(opc_putfield, putfield, ST2, ST0, 1) {
    PUTFIELD_ST24(%ecx, %edx, 2);
    ILOAD_DEBUG1(%ecx);
  }
  CODE(opc_putfield, putfield, ST3, ST0, 1) {
    asm("popl  %edx");	/* now state 2 */
    PUTFIELD_ST24(%ecx, %edx, 3);
    ILOAD_DEBUG1(%ecx);
  }
  CODE(opc_putfield, putfield, ST4, ST0, 1) {
    PUTFIELD_ST24(%edx, %ecx, 4);
    ILOAD_DEBUG1(%edx);
  }

	/* const: slot */
#define PUTFIELD2_ST24(OPTOP1_REG, OPTOP2_REG, STATE) \
    asm("popl  %edi");	/* edi = handle */\
    FIELD_ACC(%edi, putfield2, STATE);\
    METAVM_PUTFIELD2(%edi, %eax, OPTOP1_REG, OPTOP2_REG, "putfield2_st" #STATE, STATE);\
    OBJ_SETSLOT2(%edi, %eax, OPTOP1_REG, OPTOP2_REG);\
    asm("putfield2_st" #STATE "_done:");\
    \
    LLOAD_DEBUG1(OPTOP1_REG, OPTOP2_REG)

  CODE(opc_putfield2, putfield2, ST0, ST0, 1) {
    asm("popl  %ecx\n\t"
	"popl  %edx");	/* now state 2 */
    PUTFIELD2_ST24(%ecx, %edx, 0);
  }
  CODE(opc_putfield2, putfield2, ST1, ST0, 1) {
    asm("popl  %ecx");	/* now state 4 */
    PUTFIELD2_ST24(%edx, %ecx, 1);
  }
  CODE(opc_putfield2, putfield2, ST2, ST0, 1) {
    PUTFIELD2_ST24(%ecx, %edx, 2);
  }
  CODE(opc_putfield2, putfield2, ST3, ST0, 1) {
    asm("popl  %edx");	/* now state 2 */
    PUTFIELD2_ST24(%ecx, %edx, 3);
  }
  CODE(opc_putfield2, putfield2, ST4, ST0, 1) {
    PUTFIELD2_ST24(%edx, %ecx, 4);
  }

  /* invokevirtual */
	/* const: args_size, methodIndex, retsize */
  /* invokespecial */
	/* const: args_size, method, local_var_space, retsize */
  /* invokestatic */
	/* const: args_size, method, local_var_space, retsize */
  /* invokeinterface */
	/* const: args_size, guessptr, imethod, retsize */
#ifdef RUNTIME_DEBUG
#  define CALL_INVOKEHELPER_DEBUG1 \
  if (runtime_debug) {\
    DEBUG_IN;\
    asm("pushl %eax");\
    PUSH_CONSTSTR("  invocationHelper() returns: %d\n");\
    asm("call  " SYMBOL(printf) "@PLT\n\t"\
	"addl  $8,%esp");\
    FFLUSH;\
    DEBUG_OUT;\
  }
#else
#  define CALL_INVOKEHELPER_DEBUG1
#endif

#ifdef RUNTIME_DEBUG
#  define CALL_INVOKEHELPER_FUNC \
  asm("pushl %0" : : "m" (runtime_debug));\
  asm("call  " SYMBOL(invocationHelper) "@PLT");\
  \
  asm("movl  12(%esp),%ecx");	/* restore args_size */\
  \
  asm("addl  $32,%esp")
#else
#  define CALL_INVOKEHELPER_FUNC \
  asm("call  " SYMBOL(invocationHelper) "@PLT");\
  \
  asm("movl  8(%esp),%ecx");	/* restore args_size */\
  \
  asm("addl  $28,%esp")
#endif

#define CALL_INVOKEHELPER(LABEL) \
    asm("pushl %0" : : "m" (bytepcoff));/* bytepcoff */\
    asm("pushl $" STR(CONST));		/* retsize */\
    asm("pushl %edi");			/* base of native stack */\
    asm("pushl %0" : : "m" (ee));	/* ee */\
    asm("pushl %ecx\n\t"		/* args_size */\
	"pushl %eax\n\t"		/* method */\
	"pushl %edx");			/* obj */\
    CALL_INVOKEHELPER_FUNC;\
    CALL_INVOKEHELPER_DEBUG1

#define INVOKE_RESTACK(LABEL) \
	/* restack\
	   eax: return value from invocationHelper()\
	   ecx: arg_size */\
    \
    asm(LABEL "_restack:");\
	/* adjust optop */\
    asm("leal  (%esp,%ecx,4),%esp");	/* esp += (args_size * 4) */\
	/* if (eax < 0)  goto exception_handler */\
    asm("testl %eax,%eax\n\t"\
	"jl    " STR(ADDR_EXC));\
    \
    asm("jz    " LABEL "_done");	/* if (ret_size == 0) done */\
    \
    /* Now we can break edi, edx and ecx ! */\
    /* edi = ee->current_frame->optop */\
    {\
      register ExecEnv *cur_ee asm("edi");\
      cur_ee = ee;\
    }\
    asm("movl  " EE_CURRENTFRAME(%edi) ",%ecx\n\t"\
	"movl  " FRAME_OPTOP(%ecx) ",%edi");\
    \
    asm("cmpl  $2,%eax\n\t"\
	"jne   " LABEL "_1");		/* if (ret_size != 2) jump */\
		/* ret_size: 2 */\
    asm("subl  $8," FRAME_OPTOP(%ecx) "\n\t"\
	"pushl -4(%edi)\n\t"\
	"pushl -8(%edi)\n\t"\
	"jmp   " LABEL "_done\n\t"\
      LABEL "_1:");\
		/* ret_size: 1 */\
    asm("subl  $4," FRAME_OPTOP(%ecx) "\n\t"\
	"pushl -4(%edi)\n\t"\
      LABEL "_done:")
		/* now state 0 */


#ifdef METAVM
#  define METAVM_INVOKE(LABEL) \
    JUMP_IF_NOT_PROXY(%edx /* is obj */, LABEL "_inv_local");\
    JUMP_IF_NOT_REMOTE(LABEL "_inv_local");\
	/* these break edi */\
    \
    /* call Proxy#* at local */\
    asm("pushl %ecx\n\tpushl %eax\n\t"	/* save */\
	"leal  8(%esp),%ecx");		/* save original esp to ecx */\
    \
    asm("movl  " METHOD_CLAZZ(%eax) ",%eax");\
    CB_METHODTABLE(%eax,%eax);	/* break edi */\
	/* eax = cbMethodTable(mb->fb.clazz) */\
    METHODTABLE_OF_PROXY(%edi);\
	/* edi = cbMethodTable(Proxy clazz) */\
    asm("cmpl  %eax,%edi");\
    asm("jnz   " LABEL "_inv_remote\n\t"\
	"popl  %eax\n\tpopl  %ecx\n\t"	/* restore */\
	"jmp   " LABEL "_inv_local");\
    \
    asm(LABEL "_inv_remote:\n\t"\
	"popl  %eax");		/* restore */\
    \
    asm("pushl %ecx\n\t"	/* stack pointer */\
	"pushl " METHOD_SIGNATURE(%eax) "\n\t"	/* signature */\
	"pushl " METHOD_FB_U_OFFSET(%eax) "\n\t"  /* index in methodtable */\
	"pushl %eax\n\t"			/* methodblock */\
	"pushl %edx");		/* obj (Proxy) */\
    asm("pushl %0" : : "m" (ee));	/* ee */\
    asm("call  " SYMBOL(proxy_invoke) "@PLT\n\t"\
	"addl  $24,%esp");\
    \
    asm("popl  %ecx");		/* restore */\
    asm("jmp   " LABEL "_restack");\
    \
    asm(LABEL "_inv_local:")
#else
#  define METAVM_INVOKE(LABEL)
#endif	/* METAVM */

#define INVOKE_ST0(VOP, LABEL) \
    asm("movl  $" STR(CONST) ",%ecx");		/* ecx = args_size */\
    bytepcoff = BYTEPCOFF;\
    \
    TGTOBJ_##VOP(LABEL, 0);			/* edx = obj */\
	/* TGTOBJ_* performs null check, too */\
    \
    METHODBLOCK_##VOP(LABEL);			/* eax = method */\
    \
    METAVM_INVOKE_##VOP(LABEL);\
    \
    VARSPACE_##VOP(LABEL);			/* edi = local var. space */\
    \
    asm("subl  %edi,%esp\n\t"\
	"pushl %edi\n\t"	/* save */\
	"leal  4(%esp,%edi),%edi");		/* edi = original esp */\
    \
    asm("leal  -4(%edi,%ecx,4),%edi");	/* base of native stack */\
			/* edi = original esp + 4 * (args_size - 1) */\
    \
    CALL_INVOKEHELPER(LABEL);\
    \
    asm("popl  %edi");		/* restore */\
    asm("addl  %edi,%esp");	/* free local var space */\
    \
    INVOKE_RESTACK(LABEL)


#define CODE_INVOKE(vop, VOP, THROW_EXC) \
  CODE(opc_invoke##vop, invoke##vop, ST0, ST0, THROW_EXC) {\
    INVOKE_ST0(VOP, #vop "_st0");\
  }\
  CODE(opc_invoke##vop, invoke##vop, ST1, ST0, THROW_EXC) {\
    asm("pushl %edx");	/* now state 0 */\
    INVOKE_ST0(VOP, #vop "_st1");\
  }\
  CODE(opc_invoke##vop, invoke##vop, ST2, ST0, THROW_EXC) {\
    asm("pushl %edx\n\t"\
	"pushl %ecx");	/* now state 0 */\
    INVOKE_ST0(VOP, #vop "_st2");\
  }\
  CODE(opc_invoke##vop, invoke##vop, ST3, ST0, THROW_EXC) {\
    asm("pushl %ecx");	/* now state 0 */\
    INVOKE_ST0(VOP, #vop "_st3");\
  }\
  CODE(opc_invoke##vop, invoke##vop, ST4, ST0, THROW_EXC) {\
    asm("pushl %ecx\n\t"\
	"pushl %edx");	/* now state 0 */\
    INVOKE_ST0(VOP, #vop "_st4");\
  }


/* stuff to rewrite code for opc_new */
#undef INIT_DEBUG
#ifdef INIT_DEBUG
#  define INVOKE_REWRITE_OFFSET	"0x52"
#  define INITCLASS_INVOKE_DEBUG1 \
	printf("not initialized: %s\n", cbName(cb));\
	fflush(stdout)
#else
#  define INVOKE_REWRITE_OFFSET	"0x2a"
#  define INITCLASS_INVOKE_DEBUG1
#endif


#if defined(INITCLASS_IN_COMPILING) || defined(NO_REWRITE)
#  define INITCLASS_INVOKE(MB, LABEL)
#else
#  define INITCLASS_INVOKE(MB, LABEL) \
/*asm("nop\n\tnop\n\tnop\n\tnop");*/\
    asm("jmp   " LABEL "_call_initclass\n\t"\
	"jmp   " LABEL "_initclass_done\n\t"\
     LABEL "_call_initclass:");\
    asm("pushl %eax\n\tpushl %edx\n\tpushl %ecx");	/* save */\
    {\
      register struct methodblock *mb asm(#MB);\
      register ClassClass *cb asm("edi");\
      cb = mb->fb.clazz;\
      if (!CB_INITIALIZED(cb)) {\
	FUNCCALL_IN(0);\
	InitClass(cb);\
	INITCLASS_INVOKE_DEBUG1;\
	FUNCCALL_OUT(0);\
      }\
    }\
    asm("popl  %ecx\n\tpopl  %edx\n\tpopl  %eax");	/* restore */\
    \
    /* rewrite */\
    asm("call  0\n\t"\
	"popl  %edi");\
/*asm("nop\n\tnop\n\tnop\n\tnop");*/\
    asm("subl  $" INVOKE_REWRITE_OFFSET ",%edi\n\t"\
	"movb  $0x90,(%edi)\n\t"\
	"movb  $0x90,1(%edi)");\
    asm(LABEL "_initclass_done:")
#endif	/* INITCLASS_IN_COMPILING || NO_REWRITE */

#define TGTOBJ_VIRTUAL(LABEL, STATE) \
    asm("movl  -4(%esp,%ecx,4),%edx");\
    NULL_TEST(%edx, LABEL, STATE)

#ifdef METAVM
#  define METHODBLOCK_VIRTUAL(LABEL) \
    OBJ_ARRAY_METHODTABLE(%edx, %eax, LABEL);	/* eax = obj_array_..(obj) */\
    \
    JUMP_IF_NOT_REMOTE(LABEL "_not_proxy");	/* break edi */\
    \
    METHODTABLE_OF_PROXY(%edi);\
    asm("cmpl  %eax,%edi\n\t"\
	"jnz   " LABEL "_not_proxy");\
    PROXY_CLAZZ(%edx, %eax);		/* eax = Proxy.clazz */\
    CB_METHODTABLE(%eax, %eax);		/* eax = methodtable of Proxy.clazz */\
    \
    asm(LABEL "_not_proxy:");\
    asm("movl  $" STR(CONST) ",%edi");		/* edi = methodIndex */\
    MT_SLOT(%eax, %edi, %eax)			/* eax = method */
#else
#  define METHODBLOCK_VIRTUAL(LABEL) \
    /* get methodblock */\
    OBJ_ARRAY_METHODTABLE(%edx, %eax, LABEL);	/* eax = obj_array_..(obj) */\
    asm("movl  $" STR(CONST) ",%edi");		/* edi = methodIndex */\
    MT_SLOT(%eax, %edi, %eax)			/* eax = method */
#endif	/* METAVM */

#define VARSPACE_VIRTUAL(LABEL) \
    /* allocate local var space */\
    METHOD_NLOCALS(%eax, %edi);		/* edi = method->nlocals */\
    asm("subl  %ecx,%edi\n\t"		/* edi -= args_size */\
	"jle   " LABEL "_nlocal_le_0\n\t"\
	"shll  $2,%edi\n\t"		/* edi *= 4 */\
	"jmp   " LABEL "_nlocal_done\n\t"\
      LABEL "_nlocal_le_0:\n\t"\
	"xorl  %edi,%edi\n\t"		/* edi = 0 */\
      LABEL "_nlocal_done:")

#define METAVM_INVOKE_VIRTUAL(LABEL)	METAVM_INVOKE(LABEL)

#define TGTOBJ_SPECIAL(LABEL, STATE)	TGTOBJ_VIRTUAL(LABEL, STATE)
#define METHODBLOCK_SPECIAL(LABEL)	asm("movl  $" STR(CONST) ",%eax")
#define VARSPACE_SPECIAL(LABEL)		asm("movl  $" STR(CONST) ",%edi")
#define METAVM_INVOKE_SPECIAL(LABEL)	METAVM_INVOKE(LABEL)

#define TGTOBJ_STATIC(LABEL, STATE)
	/* null instead of 0 clear (asm("xorl  %edx,%edx")) */
#define METHODBLOCK_STATIC(LABEL) \
    asm("movl  $" STR(CONST) ",%eax\n\t"\
	"movl  " METHOD_CLAZZ(%eax) ",%edx");\
		/* edx = cbHandle(method->fb.clazz) */\
    /* call InitClass(cb) */\
    INITCLASS_INVOKE(eax, LABEL)
#define VARSPACE_STATIC(LABEL)		asm("movl  $" STR(CONST) ",%edi")
#define METAVM_INVOKE_STATIC(LABEL)	/* nothing */

#define TGTOBJ_INTERFACE(LABEL, STATE)	TGTOBJ_VIRTUAL(LABEL, STATE)

#define METHODBLOCK_INTERFACE(LABEL) \
    /* get methodblock: call getInterfaceMethod() */\
    asm("pushl %ecx\n\tpushl  %edx");	/* save */\
    FUNCCALL_IN(0);\
    asm("pushl $" STR(CONST) "\n\t"	/* guessptr */\
	"pushl $" STR(CONST) "\n\t"	/* imethod */\
	"pushl %edx");			/* obj */\
    asm("pushl %0" : : "m" (ee));	/* ee */\
    CALL_GETINTFMETHOD;\
    FUNCCALL_OUT(0);\
    asm("popl  %edx\n\tpopl  %ecx")	/* restore */

#define VARSPACE_INTERFACE(LABEL)	VARSPACE_VIRTUAL(LABEL)
#define METAVM_INVOKE_INTERFACE(LABEL)	METAVM_INVOKE(LABEL)

#ifdef RUNTIME_DEBUG
#  define CALL_GETINTFMETHOD \
    asm("pushl %0" : : "m" (runtime_debug));\
    asm("call  " SYMBOL(getInterfaceMethod) "@PLT\n\t"\
	"addl  $20,%esp")
#else
#  define CALL_GETINTFMETHOD \
    asm("call  " SYMBOL(getInterfaceMethod) "@PLT\n\t"\
	"addl  $16,%esp")
#endif


  CODE_INVOKE(virtual, VIRTUAL, 1);
  CODE_INVOKE(special, SPECIAL, 1);
  CODE_INVOKE(static, STATIC, 0);
  CODE_INVOKE(interface, INTERFACE, 1);

#if 0	/* how to get methodblock */
#  if 0
    if (opcode == opc_invokevirtual_quick)	/* obj isn't an array */
      method = mt_slot(obj_methodtable(obj), methodIndex);
    else
#  endif
      method = mt_slot(obj_array_methodtable(obj), methodIndex);
#endif

  /* invokevirtual_quick */
	/* const: args_size, methodIndex, retsize */
  CODE_INVOKE(virtual_quick, VIRTUAL, 1);

  /* invokevirtualobject_quick */
	/* const: args_size, methodIndex, retsize */
  CODE_INVOKE(virtualobject_quick, VIRTUAL, 1);

  /* xxxunusedxxx */
  CODE(opc_xxxunusedxxx, xxxunusesxxx, STANY, STSTA, 0) {}

  /* new */
	/* cosnt: cb */
#ifndef NO_CHECK
#  define NEW_TEST(CB_REG, LABEL, STATE) \
    /* call VerifyClassAccess() */\
    \
    asm("pushl " #CB_REG);\
    FUNCCALL_IN(STATE);\
    \
    asm("pushl $1\n\t"	/* classloader_only */\
	"pushl " #CB_REG);	/* new_class */\
    /* %eax = ee->current_frame->current_method */\
    {\
      register ExecEnv *cur_ee asm("eax");\
      cur_ee = ee;\
    }\
    asm("movl  " EE_CURRENTFRAME(%eax) ",%edi\n\t"\
	"movl  " FRAME_CURRENTMETHOD(%edi) ",%eax");\
    {\
      register struct methodblock *method asm("eax");\
      if (method)\
	asm("pushl %0" : : "m" (method->fb.clazz));\
      else\
	asm("pushl $0");\
    }\
    asm("call  " SYMBOL(VerifyClassAccess) "@PLT\n\t"\
	"addl  $12,%esp");\
    FUNCCALL_OUT(STATE);\
    asm("popl  " #CB_REG);\
    \
    asm("testl %eax,%eax\n\t"\
	"jnz   " LABEL "_testok");\
    SIGNAL_ERROR0(IllegalAccessError, STATE);\
    asm(LABEL "_testok:")
#else
#  define NEW_TEST(CB_REG, LABEL, STATE)
#endif

#if defined(INITCLASS_IN_COMPILING) || defined(NO_REWRITE)
#  define INITCLASS_NEW(CB_REG, STATE)
#else
#  define INITCLASS_NEW(CB_REG, STATE) \
    FUNCCALL_IN(STATE);\
    asm("pushl " #CB_REG);\
    {\
      register ClassClass *cb asm(#CB_REG);\
      if (!CB_INITIALIZED(cb))  InitClass(cb);\
    }\
    asm("popl " #CB_REG);\
    FUNCCALL_OUT(STATE)
#endif	/* INITCLASS_IN_COMPILING || NO_REWRITE */

#ifdef RUNTIME_DEBUG
#  define NEW_DEBUG1(CB_REG) \
    if (runtime_debug) {\
      DEBUG_IN;\
      CB_NAME(CB_REG, %eax);  asm("pushl %eax");\
      PUSH_CONSTSTR("  clazz: %s\n");\
      asm("call  " SYMBOL(printf) "@PLT\n\t"\
	"addl  $8,%esp");\
      FFLUSH;\
      DEBUG_OUT;\
    }
#  define NEW_DEBUG2(OBJ_REG) \
    if (runtime_debug) {\
      DEBUG_IN;\
      asm("pushl " #OBJ_REG);\
      PUSH_CONSTSTR("  obj: 0x%08x\n");\
      asm("call  " SYMBOL(printf) "@PLT\n\t"\
	"addl  $8,%esp");\
      FFLUSH;\
      DEBUG_OUT;\
    }
#else
#  define NEW_DEBUG1(CB_REG)
#  define NEW_DEBUG2(OBJ_REG)
#endif

#ifdef METAVM
#  define METAVM_NEW(CB_REG, DST_REG, LABEL, STATE) \
    JUMP_IF_NOT_REMOTE(LABEL "_local");\
    \
    asm("movl  %0,%%edi" : : "m" (ee));	/* edi = ee */\
    /* local operation if remote VM addr is null */\
    asm("movl  " EE_REMOTE_ADDR(%edi) ",%eax\n\t"\
	"testl %eax,%eax\n\t"\
	"jz    " LABEL "_local");\
    \
    /* call isByValue() */\
    FUNCCALL_IN(STATE);\
    asm("pushl " #CB_REG "\n\t"\
	"pushl %edi\n\t"\
	"call  " SYMBOL(isByValue) "@PLT");\
    asm("popl  %edi\n\t"\
	"popl  " #CB_REG);\
    FUNCCALL_OUT(STATE);\
    asm("testl %eax,%eax\n\t"\
	"jnz   " LABEL "_local");\
    \
    /* call proxy_new() */\
    FUNCCALL_IN(STATE);\
    asm("pushl " #CB_REG "\n\t"\
	"pushl " EE_REMOTE_ADDR(%edi) "\n\t"\
	"movl  " EE_CURRENTFRAME(%edi) ",%eax\n\t"\
	"movl  " FRAME_CURRENTMETHOD(%eax) ",%eax\n\t"\
	"movl  " METHOD_CLAZZ(%eax) ",%eax\n\t"\
	"pushl %eax\n\t"\
		/* ee->current_frame->current_method->fb.clazz */\
	"pushl %edi\n\t"	/* ee */\
	"call  " SYMBOL(proxy_new) "@PLT\n\t"\
	"popl  %edi\n\t"	/* edi = ee */\
	"addl  $12,%esp");\
    FUNCCALL_OUT(STATE);\
    \
    JUMP_IF_EXC_HASNT_OCCURRED(%edi /* is ee */, LABEL "_done");\
DEBUG_IN;\
PUSH_CONSTSTR("METAVM_NEW exc. occurred.\n");\
asm("call  " SYMBOL(printf) "@PLT\n\t"\
    "addl  $4,%esp");\
FFLUSH;\
DEBUG_OUT;\
    SIGNAL_ERROR_JUMP(STATE);\
    asm(LABEL "_local:")
#else
#  define METAVM_NEW(CB_REG, DST_REG, LABEL, STATE)
#endif	/* METAVM */

/* stuff to rewrite code for opc_new */
#define NEW_REWRITE_OFFSET	"0x1b"

#ifndef NO_REWRITE
#  define NEW_REWRITE(CB_REG, LABEL, STATE) \
/*asm("nop\n\tnop\n\tnop\n\tnop");*/\
    asm("jmp  " LABEL "_do_once\n\t"\
	"jmp  " LABEL "_done_once\n\t"\
     LABEL "_do_once:");\
    \
    FUNCCALL_IN(2);\
    asm("pushl " #CB_REG);\
    asm("pushl %0" : : "m" (ee));\
    asm("call  " SYMBOL(once_in_new) "@PLT\n\t"\
	"addl  $8,%esp");\
    FUNCCALL_OUT(2);\
    \
    /* rewrite */\
    asm("call  0\n\t"\
	"popl  %edi");\
/*asm("nop\n\tnop\n\tnop\n\tnop");*/\
    asm("subl  $" NEW_REWRITE_OFFSET ",%edi\n\t"\
	"movb  $0x90,(%edi)\n\t"\
	"movb  $0x90,1(%edi)");\
    \
    /* exc. check */\
    asm("testl %eax,%eax\n\t"\
	"jz    " LABEL "_done_once");\
    SIGNAL_ERROR_JUMP(STATE);\
    \
    asm(LABEL "_done_once:")
#else
#  define NEW_REWRITE(CB_REG, LABEL, STATE)
#endif

#define NEW(CB_REG, DST_REG, LABEL, STATE) \
    asm("movl  $" STR(CONST) "," #CB_REG);	/* cb */\
    \
    NEW_REWRITE(CB_REG, LABEL, STATE);\
    \
    NEW_DEBUG1(CB_REG);\
    \
    /* instantiate */\
    METAVM_NEW(CB_REG, DST_REG, LABEL, STATE);\
    /* call newobject() */\
    FUNCCALL_IN(STATE);\
    asm("pushl %0" : : "m" (ee));	/* ee */\
    asm("pushl $0\n\t"		/* pc */\
	"pushl " #CB_REG "\n\t"\
	"call  " SYMBOL(newobject) "@PLT\n\t"\
	"addl  $12,%esp");\
    FUNCCALL_OUT(STATE);\
    NEW_DEBUG2(%eax);\
    asm(LABEL "_done:");\
    asm("movl  %eax," #DST_REG)


  CODE(opc_new, new, ST0, ST1, 0) {
    NEW(%edx, %edx, "new_st0", 0);
  }
  CODE(opc_new, new, ST1, ST2, 0) {
    NEW(%ecx, %ecx, "new_st1", 1);
  }
  CODE(opc_new, new, ST2, ST4, 0) {
    asm("pushl %edx");	/* now state 3 */
    NEW(%edx, %edx, "new_st2", 3);
  }
  CODE(opc_new, new, ST3, ST4, 0) {
    NEW(%edx, %edx, "new_st3", 3);
  }
  CODE(opc_new, new, ST4, ST2, 0) {
    asm("pushl %ecx");	/* now state 1 */
    NEW(%ecx, %ecx, "new_st4", 1);
  }

  /* newarray */
	/* const: type */
#ifndef NO_CHECK
#  define NEWARRAY_TEST(OPTOP1_REG, LABEL, STATE) \
    asm("testl " #OPTOP1_REG "," #OPTOP1_REG "\n\t"\
	"jge   " LABEL "_1");\
    SIGNAL_ERROR0(NegativeArraySizeException, STATE);\
    asm(LABEL "_1:")
#else
#  define NEWARRAY_TEST(OPTOP1_REG, LABEL, STATE)
#endif

#ifdef RUNTIME_DEBUG
#  define NEWARRAY_DEBUG1(TYPE, COUNT) \
  if (runtime_debug) {\
    DEBUG_IN;\
    asm("pushl " #COUNT "\n\tpushl " #TYPE);\
    PUSH_CONSTSTR("  type: 0x%x, count: %d\n");\
    asm("call  " SYMBOL(printf) "@PLT\n\t"\
	"addl  $12,%esp");\
    FFLUSH;\
    DEBUG_OUT;\
  }
#else
#  define NEWARRAY_DEBUG1(TYPE, COUNT)
#endif

#if defined(METAVM) && !defined(METAVM_NO_ARRAY)
#  define METAVM_NEWARRAY(TYPE, COUNT, LABEL, STATE) \
    JUMP_IF_NOT_REMOTE(LABEL "_local");\
    \
    FUNCCALL_IN(STATE);\
    asm("pushl " #COUNT "\n\t"\
	"pushl " #TYPE);\
    \
    asm("movl  %0,%%edi" : : "m" (ee));	/* edi = ee*/\
    /* local operation if remote VM addr is null */\
    asm("movl  " EE_REMOTE_ADDR(%edi) ",%eax");\
    asm("testl %eax,%eax\n\t"\
	"jz    " LABEL "_addr_null");\
    \
    asm("pushl %eax\n\t"	/* addr */\
	"movl  " EE_CURRENTFRAME(%edi) ",%eax\n\t"\
	"movl  " FRAME_CURRENTMETHOD(%eax) ",%eax\n\t"\
	"movl  " METHOD_CLAZZ(%eax) ",%eax\n\t"\
	"pushl %eax\n\t"\
		/* ee->current_frame->current_method->fb.clazz */\
	"pushl %edi\n\t"	/* ee */\
	"call  " SYMBOL(proxy_newarray) "@PLT\n\t"\
	"popl  %edi\n\t"	/* edi = ee */\
	"addl  $16,%esp");\
    FUNCCALL_OUT(STATE);\
    \
    JUMP_IF_EXC_HASNT_OCCURRED(%edi /* is ee */, LABEL "_done");\
DEBUG_IN;\
PUSH_CONSTSTR("METAVM_NEWARRAY exc. occurred.\n");\
asm("call  " SYMBOL(printf) "@PLT\n\t"\
    "addl  $4,%esp");\
FFLUSH;\
DEBUG_OUT;\
    SIGNAL_ERROR_JUMP(STATE);\
    \
    asm(LABEL "_addr_null:\n\t"\
	"popl  " #TYPE "\n\t"	/* restore */\
	"popl  " #COUNT);	/* restore */\
    FUNCCALL_OUT(STATE);\
    asm(LABEL "_local:")
#else
#  define METAVM_NEWARRAY(TYPE, COUNT, LABEL, STATE)
#endif	/* METAVM_NO_ARRAY */

#define NEWARRAY(OPTOP1_REG, LABEL, STATE) \
    asm("movl  $" STR(CONST) ",%eax");	/* eax = type */\
    NEWARRAY_DEBUG1(%eax, OPTOP1_REG);\
    \
    NEWARRAY_TEST(OPTOP1_REG, LABEL, STATE);\
    \
    METAVM_NEWARRAY(%eax, OPTOP1_REG, LABEL, STATE);\
    \
    /* call ArrayAlloc() */\
    FUNCCALL_IN(STATE);\
    asm("pushl " #OPTOP1_REG "\n\t"	/* count */\
	"pushl %eax\n\t"		/* type */\
	"call  " SYMBOL(ArrayAlloc) "@PLT\n\t"\
	"addl  $8,%esp");\
    FUNCCALL_OUT(STATE);\
    asm("testl %eax,%eax\n\t"\
	"jnz   " LABEL "_done");\
    SIGNAL_ERROR0(OutOfMemoryError, STATE);\
    asm(LABEL "_done:\n\t"\
	"movl  %eax," #OPTOP1_REG)	/* store to dst. */

  CODE(opc_newarray, newarray, ST0, ST1, 0) {
    asm("popl  %edx");	/* now state 1 */
    NEWARRAY(%edx, "newarray_st0", 1);
  }
  CODE(opc_newarray, newarray, ST1, ST1, 0) {
    NEWARRAY(%edx, "newarray_st1", 1);
  }
  CODE(opc_newarray, newarray, ST2, ST2, 0) {
    NEWARRAY(%ecx, "newarray_st2", 2);
  }
  CODE(opc_newarray, newarray, ST3, ST3, 0) {
    NEWARRAY(%ecx, "newarray_st3", 3);
  }
  CODE(opc_newarray, newarray, ST4, ST4, 0) {
    NEWARRAY(%edx, "newarray_st4", 4);
  }

  /* anewarray */
	/* const: elem_clazz */
#if defined(METAVM) && !defined(METAVM_NO_ARRAY)
#  define METAVM_ANEWARRAY(COUNT, LABEL, STATE) \
    JUMP_IF_NOT_REMOTE(LABEL "_local");\
    \
    asm("movl  %0,%%edi" : : "m" (ee));	/* edi = ee */\
    /* local operation if remote VM addr is null */\
    asm("movl  " EE_REMOTE_ADDR(%edi) ",%eax\n\t"\
	"testl %eax,%eax\n\t"\
	"jz    " LABEL "_local");\
    \
    /* call proxy_anewarray() */\
    FUNCCALL_IN(STATE);\
    asm("pushl " #COUNT "\n\t"		/* count */\
	"pushl $" STR(CONST) "\n\t"	/* clazz of elements */\
	"pushl %eax\n\t"		/* addr */\
	"movl  " EE_CURRENTFRAME(%edi) ",%eax\n\t"\
	"movl  " FRAME_CURRENTMETHOD(%eax) ",%eax\n\t"\
	"movl  " METHOD_CLAZZ(%eax) ",%eax\n\t"\
	"pushl %eax\n\t"\
		/* ee->current_frame->current_method->fb.clazz */\
	"pushl %edi\n\t"		/* ee */\
	"call  " SYMBOL(proxy_anewarray) "@PLT\n\t"\
	"popl  %edi\n\t"		/* edi = ee */\
	"addl  $16,%esp");\
    FUNCCALL_OUT(STATE);\
    \
    JUMP_IF_EXC_HASNT_OCCURRED(%edi /* is ee */, LABEL "_done");\
DEBUG_IN;\
PUSH_CONSTSTR("METAVM_ANEWARRAY exc. occurred.\n");\
asm("call  " SYMBOL(printf) "@PLT\n\t"\
    "addl  $4,%esp");\
FFLUSH;\
DEBUG_OUT;\
    SIGNAL_ERROR_JUMP(STATE);\
    asm(LABEL "_local:")
#else
#  define METAVM_ANEWARRAY(COUNT, LABEL, STATE)
#endif	/* METAVM_NO_ARRAY */

#define ANEWARRAY(OPTOP1_REG, LABEL, STATE) \
    NEWARRAY_TEST(OPTOP1_REG, LABEL, STATE);\
    \
    METAVM_ANEWARRAY(OPTOP1_REG, LABEL, STATE);\
    \
    /* call ArrayAlloc() */\
    FUNCCALL_IN(STATE);\
    asm("pushl " #OPTOP1_REG "\n\t"	/* count */\
	"pushl $" STR(T_CLASS) "\n\t"	/* type (T_CLASS) */\
	"call  " SYMBOL(ArrayAlloc) "@PLT\n\t"\
	"addl  $8,%esp");\
    FUNCCALL_OUT(STATE);\
    asm("testl %eax,%eax\n\t"\
	"jnz   " LABEL "_2");\
    SIGNAL_ERROR0(OutOfMemoryError, STATE);\
    asm(LABEL "_2:");\
    \
    UNHAND(%eax, %edi);\
    asm("movl  $" STR(CONST) ",(%edi," #OPTOP1_REG ",4)");\
	/* unhand(array)->body[count] = clazz of elements */\
    asm(LABEL "_done:\n\t"\
	"movl  %eax," #OPTOP1_REG)		/* store to dst. */

  CODE(opc_anewarray, anewarray, ST0, ST1, 0) {
    asm("popl  %edx");	/* now state 1 */
    ANEWARRAY(%edx, "anewarray_st0", 1);
  }
  CODE(opc_anewarray, anewarray, ST1, ST1, 0) {
    ANEWARRAY(%edx, "anewarray_st1", 1);
  }
  CODE(opc_anewarray, anewarray, ST2, ST2, 0) {
    ANEWARRAY(%ecx, "anewarray_st2", 2);
  }
  CODE(opc_anewarray, anewarray, ST3, ST3, 0) {
    ANEWARRAY(%ecx, "anewarray_st3", 3);
  }
  CODE(opc_anewarray, anewarray, ST4, ST4, 0) {
    ANEWARRAY(%edx, "anewarray_st4", 4);
  }

  /* arraylength */
#ifdef METAVM
#  define METAVM_ARRAYLENGTH(HANDLE, DST, LABEL, STATE) \
    JUMP_IF_NOT_PROXY(HANDLE, LABEL "_local");\
    JUMP_IF_NOT_REMOTE(LABEL "_local");\
    \
    FUNCCALL_IN(STATE);\
    asm("pushl " #HANDLE);\
    asm("pushl %0" : : "m" (ee));	/* ee */\
    asm("call  " SYMBOL(proxy_arraylength) "@PLT\n\t"\
	"movl  %eax," #DST "\n\t"\
	"addl  $8,%esp");\
    FUNCCALL_OUT(STATE);\
    \
    asm("jmp  " LABEL "_done");\
    \
    asm(LABEL "_local:")
#else
#  define METAVM_ARRAYLENGTH(HANDLE, DST, LABEL, STATE)
#endif	/* METAVM */

  CODE(opc_arraylength, arraylength, ST0, ST3, 1) {
    asm("popl  %edx");	/* now state 1 */
    NULL_TEST(%edx, "arylen_null_st0", 1);
    METAVM_ARRAYLENGTH(%edx, %ecx, "arraylength_st0", 0);
    OBJ_LENGTH(%edx, %ecx);
    asm("arraylength_st0_done:");
  }
  CODE(opc_arraylength, arraylength, ST1, ST3, 1) {
    NULL_TEST(%edx, "arylen_null_st1", 1);
    METAVM_ARRAYLENGTH(%edx, %ecx, "arraylength_st1", 0);
    OBJ_LENGTH(%edx, %ecx);
    asm("arraylength_st1_done:");
  }
  CODE(opc_arraylength, arraylength, ST2, ST2, 1) {
    NULL_TEST(%ecx, "arylen_null_st2", 2);
    METAVM_ARRAYLENGTH(%ecx, %ecx, "arraylength_st2", 1);
    OBJ_LENGTH(%ecx, %ecx);
    asm("arraylength_st2_done:");
  }
  CODE(opc_arraylength, arraylength, ST3, ST1, 1) {
    NULL_TEST(%ecx, "arylen_null_st3", 3);
    METAVM_ARRAYLENGTH(%ecx, %edx, "arraylength_st3", 0);
    OBJ_LENGTH(%ecx, %edx);
    asm("arraylength_st3_done:");
  }
  CODE(opc_arraylength, arraylength, ST4, ST4, 1) {
    NULL_TEST(%edx, "arylen_null_st4", 4);
    METAVM_ARRAYLENGTH(%edx, %edx, "arraylength_st4", 3);
    OBJ_LENGTH(%edx, %edx);
    asm("arraylength_st4_done:");
  }

  /* athrow */
#define ATHROW(OPTOP1_REG, STATE) \
    NULL_TEST_CANT_BE_ELIMINATED(OPTOP1_REG, "athrow_st" #STATE "_1", STATE);\
    \
    /* macro exceptionThrow(ee, obj) */\
    {\
      register ExecEnv *cur_ee asm("eax");\
      register JHandle *obj asm(#OPTOP1_REG);\
      \
      cur_ee = ee;\
      cur_ee->exceptionKind = EXCKIND_THROW;\
      cur_ee->exception.exc = obj;\
    }\
    \
    bytepcoff = BYTEPCOFF;\
    asm("jmp  " STR(ADDR_EXC))

  CODE(opc_athrow, athrow, ST0, ST1, 1) {
    asm("popl  %edx");	/* now state 1 */
    ATHROW(%edx, 0);
  }
  CODE(opc_athrow, athrow, ST1, ST1, 1) {
    ATHROW(%edx, 1);
  }
  CODE(opc_athrow, athrow, ST2, ST2, 1) {
    ATHROW(%ecx, 2);
  }
  CODE(opc_athrow, athrow, ST3, ST3, 1) {
    ATHROW(%ecx, 3);
  }
  CODE(opc_athrow, athrow, ST4, ST4, 1) {
    ATHROW(%edx, 4);
  }

  /* checkcast */
	/* const: cb */
#ifdef METAVM
#  define METAVM_CHECKCAST(OPTOP1_REG, LABEL, STATE) \
    FUNCCALL_IN(STATE);\
    asm("pushl %eax\n\t"	/* cb */\
	"call  " SYMBOL(isCheckPassType) "@PLT\n\t"\
	"testl %eax,%eax\n\t"\
	"popl  %eax");\
    FUNCCALL_OUT(STATE);\
    asm("jnz   " LABEL "_true");\
    \
    /* compare handle->methods with cb_of_Proxy->methodtable */\
    JUMP_IF_NOT_PROXY(OPTOP1_REG, LABEL "_local");\
    JUMP_IF_NOT_REMOTE(LABEL "_local");\
    {\
      register ClassNET_shudo_metavm_Proxy *edi asm("edi");\
      register Hjava_lang_Class *clz asm("edi");\
      \
      UNHAND(OPTOP1_REG, %edi);\
      clz = edi->clazz;\
    }	/* edi = Proxy.clazz */\
    asm("cmpl %eax,%edi\n\t"\
	"jnz  " LABEL "_fail\n\t"\
	"jmp  " LABEL "_done\n\t"\
      LABEL "_local:");
#else
#  define METAVM_CHECKCAST(OPTOP1_REG, LABEL, STATE)
#endif	/* METAVM */

#ifdef RUNTIME_DEBUG
#  define CHECKCAST_DEBUG(HANDLE, CB, LABEL) \
    if (runtime_debug) {\
      DEBUG_IN;\
      CB_NAME(CB, %edi);\
      asm("pushl %edi");\
      OBJ_ARRAY_METHODTABLE(HANDLE, %eax, LABEL);\
      \
      asm("testl %eax,%eax\n\t"\
	  "jnz   " LABEL "_cc_debug_not_null");\
      PUSH_CONSTSTR("  methodtable is null\n");\
      asm("call  " SYMBOL(printf) "@PLT\n\t"\
	  "addl  $8,%esp\n\t"\
	  "jmp   " LABEL "_cc_debug_done");\
      \
      asm(LABEL "_cc_debug_not_null:");\
      MT_CLASSDESCRIPTOR(%eax, %eax);\
      CB_NAME(%eax, %eax);\
      asm("pushl %eax");\
      PUSH_CONSTSTR("  %s instanceof %s\n");\
      asm("call  " SYMBOL(printf) "@PLT\n\t"\
	  "addl  $12,%esp");\
      \
      asm(LABEL "_cc_debug_done:");\
      \
      FFLUSH;\
      DEBUG_OUT;\
    }
#else
#  define CHECKCAST_DEBUG(HANDLE, CB, LABEL)
#endif

#define CHECKCAST(OPTOP1_REG, LABEL, STATE) \
    asm("testl " #OPTOP1_REG "," #OPTOP1_REG "\n\t"\
	"jz    " LABEL "_done");\
    asm("movl  $" STR(CONST) ",%eax");	/* cb */\
    METAVM_CHECKCAST(OPTOP1_REG, LABEL, STATE);\
    CHECKCAST_DEBUG(OPTOP1_REG, %eax, LABEL);\
    FUNCCALL_IN(STATE);\
    asm("pushl %0" : : "m" (ee));	/* ee */\
    asm("pushl %eax\n\t"		/* cb */\
	"pushl " #OPTOP1_REG "\n\t"\
	"call  " SYMBOL(is_instance_of) "@PLT\n\t"\
	"addl  $12,%esp");\
    FUNCCALL_OUT(STATE);\
    asm("testl %eax,%eax\n\t"\
	"jnz   " LABEL "_done");\
    asm(LABEL "_fail:");\
    SIGNAL_ERROR0(ClassCastException, STATE);\
    asm(LABEL "_done:")

  CODE(opc_checkcast, checkcast, ST0, ST1, 0) {
    asm("popl  %edx");	/* now state 1 */
    CHECKCAST(%edx, "checkcast_st0", 1);
  }
  CODE(opc_checkcast, checkcast, ST1, ST1, 0) {
    CHECKCAST(%edx, "checkcast_st1", 1);
  }
  CODE(opc_checkcast, checkcast, ST2, ST2, 0) {
    CHECKCAST(%ecx, "checkcast_st2", 2);
  }
  CODE(opc_checkcast, checkcast, ST3, ST3, 0) {
    CHECKCAST(%ecx, "checkcast_st3", 3);
  }
  CODE(opc_checkcast, checkcast, ST4, ST4, 0) {
    CHECKCAST(%edx, "checkcast_st4", 4);
  }

  /* instanceof */
	/* const: cb */
#ifdef METAVM
#  define METAVM_INSTANCEOF(OPTOP1_REG, LABEL, STATE) \
    FUNCCALL_IN(STATE);\
    asm("pushl %eax\n\t"	/* cb */\
	"call  " SYMBOL(isCheckPassType) "@PLT\n\t"\
	"testl %eax,%eax\n\t"\
	"popl  %eax");\
    FUNCCALL_OUT(STATE);\
    asm("jnz   " LABEL "_true");\
    \
    /* compare handle->methods with cb_of_Proxy->methodtable */\
    JUMP_IF_NOT_PROXY(OPTOP1_REG, LABEL "_local");\
    JUMP_IF_NOT_REMOTE(LABEL "_local");\
    {\
      register ClassNET_shudo_metavm_Proxy *edi asm("edi");\
      register Hjava_lang_Class *clz asm("edi");\
      \
      UNHAND(OPTOP1_REG, %edi);\
      clz = edi->clazz;\
    }	/* edi = Proxy.clazz */\
    asm("cmpl %eax,%edi\n\t"\
	"jz   " LABEL "_false\n\t"\
      LABEL "_true:"\
	"movl $1," #OPTOP1_REG "\n\t"\
	"jmp  " LABEL "_done\n\t"\
      LABEL "_false:"\
	"movl $0," #OPTOP1_REG "\n\t"\
	"jmp  " LABEL "_done\n\t"\
      LABEL "_local:");
#else
#  define METAVM_INSTANCEOF(OPTOP1_REG, LABEL, STATE)
#endif	/* METAVM */

#define INSTANCEOF(OPTOP1_REG, LABEL, STATE) \
    asm("testl " #OPTOP1_REG "," #OPTOP1_REG "\n\t"\
	"jz    " LABEL "_done");\
    asm("movl  $" STR(CONST) ",%eax");	/* cb */\
    METAVM_INSTANCEOF(OPTOP1_REG, LABEL, STATE);\
    CHECKCAST_DEBUG(OPTOP1_REG, %eax, LABEL);\
    FUNCCALL_IN(STATE);\
    asm("pushl %0" : : "m" (ee));	/* ee */\
    asm("pushl %eax\n\t"		/* cb */\
	"pushl " #OPTOP1_REG "\n\t"\
	"call  " SYMBOL(is_instance_of) "@PLT\n\t"\
	"addl  $12,%esp");\
    FUNCCALL_OUT(STATE);\
    asm("movl  %eax," #OPTOP1_REG "\n\t"\
      LABEL "_done:")

  CODE(opc_instanceof, instanceof, ST0, ST1, 0) {
    asm("popl  %edx");	/* now state 1 */
    INSTANCEOF(%edx, "instanceof_st0", 1);
  }
  CODE(opc_instanceof, instanceof, ST1, ST1, 0) {
    INSTANCEOF(%edx, "instanceof_st1", 1);
  }
  CODE(opc_instanceof, instanceof, ST2, ST2, 0) {
    INSTANCEOF(%ecx, "instanceof_st2", 2);
  }
  CODE(opc_instanceof, instanceof, ST3, ST3, 0) {
    INSTANCEOF(%ecx, "instanceof_st3", 3);
  }
  CODE(opc_instanceof, instanceof, ST4, ST4, 0) {
    INSTANCEOF(%edx, "instanceof_st4", 4);
  }

  /* monitorenter, monitorexit */
#ifdef METAVM
#  define METAVM_MONITOR(OPTOP1_REG, METAVM_FUNCNAME, LABEL, STATE) \
    JUMP_IF_NOT_PROXY(OPTOP1_REG, LABEL "_local");\
    JUMP_IF_NOT_REMOTE(LABEL "_local");\
    \
    FUNCCALL_IN(STATE);\
    \
    asm("movl  %0,%%edi" : : "m" (ee));	/* edi = ee*/\
    \
    asm("pushl " #OPTOP1_REG "\n\t"\
	"pushl %edi\n\t"\
	"call  " SYMBOL(METAVM_FUNCNAME) "@PLT\n\t"\
	"popl  %edi\n\t"	/* edi = ee */\
	"addl  $4,%esp");\
    \
    FUNCCALL_OUT(STATE);\
    \
    JUMP_IF_EXC_HASNT_OCCURRED(%edi /* is ee */, LABEL "_done");\
DEBUG_IN;\
PUSH_CONSTSTR("METAVM_MONITOR exc. occurred.\n");\
asm("call  " SYMBOL(printf) "@PLT\n\t"\
    "addl  $4,%esp");\
FFLUSH;\
DEBUG_OUT;\
    SIGNAL_ERROR_JUMP(STATE);\
    asm(LABEL "_local:")
#else
#  define METAVM_MONITOR(OPTOP1_REG, METAVM_FUNCNAME, LABEL, STATE)
#endif	/* METAVM */

#if JDK_VER < 12
#  define CALL_MONITOR(MON, FUNCNAME) \
    asm("pushl " #MON "\n\t"\
	"call  " SYMBOL(FUNCNAME) "@PLT\n\t"\
	"addl  $4,%esp")
#else
#  define CALL_MONITOR(MON, FUNCNAME) \
    asm("pushl " #MON);\
    asm("pushl %0" : : "m" (ee));	/* ee */\
    asm("call  " SYMBOL(FUNCNAME) "@PLT\n\t"\
	"addl  $8,%esp")
#endif	/* JDK_VER */

#ifdef RUNTIME_DEBUG
#  define MONITOR_DEBUG \
    if (runtime_debug) {\
      DEBUG_IN;\
      PUSH_CONSTSTR("  monitor*() done.\n");\
      asm("call  " SYMBOL(printf) "@PLT\n\t"\
	  "addl  $4,%esp");\
      FFLUSH;\
      DEBUG_OUT;\
    }
#else
#  define MONITOR_DEBUG
#endif


#define MONITOR(OPTOP1_REG, FUNCNAME, METAVM_FUNCNAME, LABEL, STATE) \
    BIPUSH_DEBUG1(OPTOP1_REG);\
    NULL_TEST_CANT_BE_ELIMINATED(OPTOP1_REG, LABEL "_1", STATE);\
    METAVM_MONITOR(OPTOP1_REG, METAVM_FUNCNAME, LABEL, STATE);\
    OBJ_MONITOR(OPTOP1_REG, OPTOP1_REG);\
    FUNCCALL_IN(STATE);\
    CALL_MONITOR(OPTOP1_REG, FUNCNAME);\
    FUNCCALL_OUT(STATE);\
    asm(LABEL "_done:");\
    MONITOR_DEBUG;

#define CODE_MONITOR(vop, FUNCNAME, METAVM_FUNCNAME) \
  CODE(opc_##vop, ##vop, ST0, ST0, 1) {\
    asm("popl  %edx");	/* now state 1 */\
    MONITOR(%edx, FUNCNAME, METAVM_FUNCNAME, #vop "_st0", 0);\
  }\
  CODE(opc_##vop, ##vop, ST1, ST0, 1) {\
    MONITOR(%edx, FUNCNAME, METAVM_FUNCNAME, #vop "_st1", 0);\
  }\
  CODE(opc_##vop, ##vop, ST2, ST1, 1) {\
    MONITOR(%ecx, FUNCNAME, METAVM_FUNCNAME, #vop "_st2", 1);\
  }\
  CODE(opc_##vop, ##vop, ST3, ST0, 1) {\
    MONITOR(%ecx, FUNCNAME, METAVM_FUNCNAME, #vop "_st3", 0);\
  }\
  CODE(opc_##vop, ##vop, ST4, ST3, 1) {\
    MONITOR(%edx, FUNCNAME, METAVM_FUNCNAME, #vop "_st4", 3);\
  }

#if JDK_VER < 12
  CODE_MONITOR(monitorenter, monitorEnter, proxy_monitorenter);
  CODE_MONITOR(monitorexit, monitorExit, proxy_monitorexit);
#else
  CODE_MONITOR(monitorenter, monitorEnter2, proxy_monitorenter);
  CODE_MONITOR(monitorexit, monitorExit2, proxy_monitorexit);
#endif	/* JDK_VER */

  /* multianewarray */
	/* const: dimensions, arrayclazz */
#define MULTIANEWARRAY_TEST(STATE) \
    asm("cmpl  $-1,%eax\n\t"  /* eax is returned by multianewarray() */\
	"jne   mulary_st" #STATE "_1");\
    SIGNAL_ERROR0(NegativeArraySizeException, STATE);\
    asm("mulary_st" #STATE "_1:");\
    asm("testl %eax,%eax\n\t"\
	"jnz   mulary_st" #STATE "_2");\
    SIGNAL_ERROR0(OutOfMemoryError, STATE);\
    asm("mulary_st" #STATE "_2:")

#ifdef RUNTIME_DEBUG
#  define MULTIANEWARRAY_FUNC \
  asm("pushl %0" : : "m" (runtime_debug));\
  asm("call  " SYMBOL(multianewarray) "@PLT\n\t"\
      "addl  $20,%esp")
#else
#  define MULTIANEWARRAY_FUNC \
  asm("call  " SYMBOL(multianewarray) "@PLT\n\t"\
      "addl  $16,%esp")
#endif

#if defined(METAVM) && !defined(METAVM_NO_ARRAY)
#  define METAVM_MULTIANEWARRAY(DIM, STACKPOINTER, LABEL) \
	/* DIM: edx, STACKPOINTER: ecx */\
    JUMP_IF_NOT_REMOTE(LABEL "_local");\
    \
    asm("movl  %0,%%edi" : : "m" (ee));	/* edi = ee */\
    /* local operation if remote VM addr is null */\
    asm("movl  " EE_REMOTE_ADDR(%edi) ",%eax\n\t"\
	"testl %eax,%eax\n\t"\
	"jz    " LABEL "_local");\
    \
    FUNCCALL_IN(0);\
    asm("pushl " #DIM);	/* save */\
    \
    asm("pushl " #STACKPOINTER "\n\t"	/* stackpointer */\
	"pushl " #DIM "\n\t"		/* dim */\
	"pushl $" STR(CONST) "\n\t"	/* arrayclazz */\
	"pushl %eax\n\t"		/* addr */\
	"movl  " EE_CURRENTFRAME(%edi) ",%eax\n\t"\
	"movl  " FRAME_CURRENTMETHOD(%eax) ",%eax\n\t"\
	"movl  " METHOD_CLAZZ(%eax) ",%eax\n\t"\
	"pushl %eax\n\t"\
		/* ee->current_frame->current_method->fb.clazz */\
	"pushl %edi\n\t"		/* ee */\
	"call  " SYMBOL(proxy_multianewarray) "@PLT\n\t"\
	"popl  %edi\n\t"		/* edi = ee */\
	"addl  $20,%esp");\
    \
    asm("popl  " #DIM);	/* restore */\
    FUNCCALL_OUT(0);\
    \
    JUMP_IF_EXC_HASNT_OCCURRED(%edi /* is ee */, LABEL "_done");\
DEBUG_IN;\
PUSH_CONSTSTR("METAVM_MULTIANEWARRAY exc. occurred.\n");\
asm("call  " SYMBOL(printf) "@PLT\n\t"\
    "addl  $4,%esp");\
FFLUSH;\
DEBUG_OUT;\
    SIGNAL_ERROR_JUMP(0);\
    asm(LABEL "_local:")
#else
#  define METAVM_MULTIANEWARRAY(DIM, STACKPOINTER, LABEL)
#endif	/* METAVM_NO_ARRAY */

#define MULTIANEWARRAY_ST0(DST_REG, LABEL, STATE) \
    asm("movl  $" STR(CONST) ",%edx");	/* dimensions */\
    \
    asm("movl  %esp,%ecx");	/* stackpointer */\
    \
    METAVM_MULTIANEWARRAY(%edx, %ecx, LABEL);\
    \
    FUNCCALL_IN(0);\
    asm("pushl %edx");	/* save */\
    \
    asm("pushl %ecx\n\t"		/* stackpointer */\
	"pushl $" STR(CONST) "\n\t"	/* arrayclazz */\
	"pushl %edx");			/* dimensions */\
    asm("pushl %0" : : "m" (ee));	/* ee */\
    MULTIANEWARRAY_FUNC;\
    \
    asm("popl  %edx");	/* restore */\
    FUNCCALL_OUT(0);\
    \
    asm(LABEL "_done:");\
    asm("leal  (%esp,%edx,4),%esp");/* pop dimensions */\
    \
    MULTIANEWARRAY_TEST(STATE);\
    asm("movl  %eax," #DST_REG)

  CODE(opc_multianewarray, multianewarray, ST0, ST1, 0) {
    MULTIANEWARRAY_ST0(%edx, "multianewarray_st0", 0);
  }
  CODE(opc_multianewarray, multianewarray, ST1, ST1, 0) {
    asm("pushl %edx");	/* now state 0 */
    MULTIANEWARRAY_ST0(%edx, "multianewarray_st1", 1);
  }
  CODE(opc_multianewarray, multianewarray, ST2, ST1, 0) {
    asm("pushl %edx\n\t"
	"pushl %ecx");	/* now state 0 */
    MULTIANEWARRAY_ST0(%edx, "multianewarray_st2", 2);
  }
  CODE(opc_multianewarray, multianewarray, ST3, ST1, 0) {
    asm("pushl %ecx");	/* now state 0 */
    MULTIANEWARRAY_ST0(%edx, "multianewarray_st3", 3);
  }
  CODE(opc_multianewarray, multianewarray, ST4, ST1, 0) {
    asm("pushl %ecx\n\t"
	"pushl %edx");	/* now state 0 */
    MULTIANEWARRAY_ST0(%edx, "multianewarray_st4", 4);
  }

  /* invokeignored_quick */
	/* const: args_size */
#define INVOKEIGNORED_QUICK_ST0(STATE) \
    asm("movl  $" STR(CONST) ",%edi\n\t"\
	"movl  -4(%esp,%edi,4),%eax\n\t"\
	"leal  (%esp,%edi,4),%esp\n\t"\
	"testl %eax,%eax\n\t"\
	"jnz   invign_st" #STATE "_done");\
    SIGNAL_ERROR0(NullPointerException, STATE);\
    asm("invign_st" #STATE "_done:")

#define INVOKEIGNORED_NOCHECK_ST0(STATE) \
    asm("movl  $" STR(CONST) ",%edi\n\t"\
	"leal  (%esp,%edi,4),%esp")

#define CODE_INVOKEIGNORED(suffix, SUFFIX) \
  CODE(opc_invokeignored_##suffix, invokeignored_##suffix, ST0, ST0, 0) {\
    INVOKEIGNORED_##SUFFIX##_ST0(0);\
  }\
  CODE(opc_invokeignored_##suffix, invokeignored_##suffix, ST1, ST0, 0) {\
    asm("pushl %edx");	/* now state 0 */\
    INVOKEIGNORED_##SUFFIX##_ST0(1);\
  }\
  CODE(opc_invokeignored_##suffix, invokeignored_##suffix, ST2, ST0, 0) {\
    asm("pushl %edx\n\t"\
	"pushl %ecx");	/* now state 0 */\
    INVOKEIGNORED_##SUFFIX##_ST0(2);\
  }\
  CODE(opc_invokeignored_##suffix, invokeignored_##suffix, ST3, ST0, 0) {\
    asm("pushl %ecx");	/* now state 0 */\
    INVOKEIGNORED_##SUFFIX##_ST0(3);\
  }\
  CODE(opc_invokeignored_##suffix, invokeignored_##suffix, ST4, ST0, 0) {\
    asm("pushl %ecx\n\t"\
	"pushl %edx");	/* now state 0 */\
    INVOKEIGNORED_##SUFFIX##_ST0(4);\
  }

  CODE_INVOKEIGNORED(quick, QUICK);
  CODE_INVOKEIGNORED(nocheck, NOCHECK);

  /* new_quick */
	/* const: cb */
#define NEW_QUICK(DST_REG, STATE) \
    FUNCCALL_IN(STATE);\
    asm("pushl %0" : : "m" (ee));	/* ee */\
    asm("pushl $0\n\t"		/* pc */\
	"pushl $" STR(CONST) "\n\t"\
	"call  " SYMBOL(newobject) "@PLT\n\t"\
	"addl  $12,%esp");\
    FUNCCALL_OUT(STATE);\
    asm("movl  %eax," #DST_REG)

  CODE(opc_new_quick, new_quick, ST0, ST1, 0) {
    NEW_QUICK(%edx, 0);
  }
  CODE(opc_new_quick, new_quick, ST1, ST2, 0) {
    NEW_QUICK(%ecx, 1);
  }
  CODE(opc_new_quick, new_quick, ST2, ST4, 0) {
    asm("pushl %edx");	/* now state 3 */
    NEW_QUICK(%edx, 3);
  }
  CODE(opc_new_quick, new_quick, ST3, ST4, 0) {
    NEW_QUICK(%edx, 3);
  }
  CODE(opc_new_quick, new_quick, ST4, ST2, 0) {
    asm("pushl %ecx");	/* now state 1 */
    NEW_QUICK(%ecx, 1);
  }

  /* nonnull_quick */
  CODE(opc_nonnull_quick, nonnull_quick, ST0, ST0, 0) {
    asm("popl  %edx");	/* now state 1 */
    NULL_TEST(%edx, "nonnull_quick_st0_1", 0);
  }
  CODE(opc_nonnull_quick, nonnull_quick, ST1, ST0, 0) {
    NULL_TEST(%edx, "nonnull_quick_st1_1", 1);
  }
  CODE(opc_nonnull_quick, nonnull_quick, ST2, ST1, 0) {
    NULL_TEST(%ecx, "nonnull_quick_st2_1", 2);
  }
  CODE(opc_nonnull_quick, nonnull_quick, ST3, ST0, 0) {
    NULL_TEST(%ecx, "nonnull_quick_st3_1", 3);
  }
  CODE(opc_nonnull_quick, nonnull_quick, ST4, ST3, 0) {
    NULL_TEST(%edx, "nonnull_quick_st4_1", 4);
  }

  CODEEND;
}
